/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.IndependentSubquery;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.translator.LangExpressionToPlanTranslator;
import org.apache.asterix.translator.PositionWriter;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingPositionWriter;

class SqlppExpressionToPlanTranslator
extends LangExpressionToPlanTranslator
implements ILangExpressionToPlanTranslator,
ISqlppVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>> {
    private static final String ERR_MSG = "Translator should never enter this method!";
    private Deque<Mutable<ILogicalOperator>> uncorrelatedLeftBranchStack = new ArrayDeque<Mutable<ILogicalOperator>>();

    public SqlppExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounter) throws AlgebricksException {
        super(metadataProvider, currentVarCounter);
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Expression queryBody = q.getBody();
        if (queryBody.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            SelectExpression selectExpr = (SelectExpression)queryBody;
            if (q.isTopLevel()) {
                selectExpr.setSubquery(false);
            }
            return (Pair)queryBody.accept((ILangVisitor)this, tupSource);
        }
        LogicalVariable var = this.context.newVar();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(queryBody, tupSource);
        AssignOperator assignOp = new AssignOperator(var, (Mutable)new MutableObject(eo.first));
        assignOp.getInputs().add(eo.second);
        ProjectOperator projectOp = new ProjectOperator(var);
        projectOp.getInputs().add(new MutableObject((Object)assignOp));
        return new Pair((Object)projectOp, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectExpression selectExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        if (selectExpression.isSubquery()) {
            this.context.enterSubplan();
        }
        MutableObject currentOpRef = tupSource;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        Pair select = (Pair)selectExpression.getSelectSetOperation().accept((ILangVisitor)this, currentOpRef);
        currentOpRef = new MutableObject(select.first);
        if (selectExpression.hasOrderby()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectExpression.hasLimit()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        Pair<ILogicalOperator, LogicalVariable> result = this.produceSelectPlan(selectExpression.isSubquery(), (Mutable<ILogicalOperator>)currentOpRef, (LogicalVariable)select.second);
        if (selectExpression.isSubquery()) {
            this.context.exitSubplan();
        }
        return result;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(IndependentSubquery independentSubquery, Mutable<ILogicalOperator> tupleSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(independentSubquery.getExpr(), tupleSource);
        LogicalVariable var = this.context.newVar();
        AssignOperator assignOp = new AssignOperator(var, (Mutable)new MutableObject(eo.first));
        assignOp.getInputs().add(eo.second);
        return new Pair((Object)assignOp, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectSetOperation selectSetOperation, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        if (!selectSetOperation.hasRightInputs()) {
            return (Pair)leftInput.accept((ILangVisitor)this, tupSource);
        }
        ArrayList<ILangExpression> inputExprs = new ArrayList<ILangExpression>();
        inputExprs.add((ILangExpression)(leftInput.selectBlock() ? new SelectExpression(null, new SelectSetOperation(leftInput, null), null, null, true) : leftInput.getSubquery()));
        for (SetOperationRight setOperationRight : selectSetOperation.getRightInputs()) {
            SetOpType setOpType = setOperationRight.getSetOpType();
            if (setOpType != SetOpType.UNION || setOperationRight.isSetSemantics()) {
                throw new CompilationException("Operation " + setOpType + (setOperationRight.isSetSemantics() ? " with set semantics" : "ALL") + " is not supported.");
            }
            SetOperationInput rightInput = setOperationRight.getSetOperationRightInput();
            inputExprs.add((ILangExpression)(rightInput.selectBlock() ? new SelectExpression(null, new SelectSetOperation(rightInput, null), null, null, true) : rightInput.getSubquery()));
        }
        return this.translateUnionAllFromInputExprs(inputExprs, tupSource);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        if (selectBlock.hasFromClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getFromClause().accept((ILangVisitor)this, currentOpRef)).first);
        }
        if (selectBlock.hasLetClauses()) {
            for (LetClause letClause : selectBlock.getLetList()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        if (selectBlock.hasWhereClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectBlock.hasGroupbyClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectBlock.hasLetClausesAfterGroupby()) {
            for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        if (selectBlock.hasHavingClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getHavingClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        return this.processSelectClause(selectBlock, (Mutable<ILogicalOperator>)currentOpRef);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromClause fromClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        MutableObject inputSrc = arg;
        Pair topUnnest = null;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            topUnnest = (Pair)fromTerm.accept((ILangVisitor)this, inputSrc);
            inputSrc = new MutableObject(topUnnest.first);
        }
        return topUnnest;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromTerm fromTerm, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        UnnestOperator unnestOp;
        LogicalVariable fromVar = this.context.newVarFromExpression((Expression)fromTerm.getLeftVariable());
        Expression fromExpr = fromTerm.getLeftExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(fromExpr, tupSource);
        if (fromTerm.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)fromTerm.getPositionalVariable());
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter());
        } else {
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)));
        }
        unnestOp.getInputs().add(eo.second);
        MutableObject topOpRef = new MutableObject((Object)unnestOp);
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                if (correlateClause.getClauseType() == Clause.ClauseType.UNNEST_CLAUSE) {
                    topOpRef = new MutableObject(((Pair)correlateClause.accept((ILangVisitor)this, (Object)topOpRef)).first);
                    continue;
                }
                this.uncorrelatedLeftBranchStack.push((Mutable<ILogicalOperator>)topOpRef);
                topOpRef = new MutableObject(((Pair)correlateClause.accept((ILangVisitor)this, tupSource)).first);
            }
        }
        return new Pair(topOpRef.getValue(), (Object)fromVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(JoinClause joinClause, Mutable<ILogicalOperator> inputRef) throws CompilationException {
        LogicalVariable varToListify;
        boolean hasRightPosVar;
        Mutable<ILogicalOperator> leftInputRef = this.uncorrelatedLeftBranchStack.pop();
        if (joinClause.getJoinType() == JoinType.INNER) {
            Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, inputRef, true);
            InnerJoinOperator joinOperator = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), leftInputRef, (Mutable)new MutableObject(rightBranch.first));
            MutableObject joinOpRef = new MutableObject((Object)joinOperator);
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)joinOpRef);
            SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
            filter.getInputs().add(conditionExprOpPair.second);
            return new Pair((Object)filter, rightBranch.second);
        }
        SubplanOperator subplanOp = new SubplanOperator();
        MutableObject ntsRef = new MutableObject((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp)));
        subplanOp.getInputs().add(leftInputRef);
        this.context.enterSubplan();
        Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, (Mutable<ILogicalOperator>)ntsRef, true);
        AbstractUnnestNonMapOperator rightUnnestOp = (AbstractUnnestNonMapOperator)rightBranch.first;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)new MutableObject((Object)rightUnnestOp));
        SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
        filter.getInputs().add(conditionExprOpPair.second);
        SelectOperator currentTopOp = filter;
        boolean bl = hasRightPosVar = rightUnnestOp.getPositionalVariable() != null;
        if (hasRightPosVar) {
            ScalarFunctionCallExpression recordCreationFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR), new Mutable[]{new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("unnestvar")))), new MutableObject((Object)new VariableReferenceExpression(rightUnnestOp.getVariable())), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("posvar")))), new MutableObject((Object)new VariableReferenceExpression(rightUnnestOp.getPositionalVariable()))});
            LogicalVariable recordVar = this.context.newVar();
            AssignOperator assignOp = new AssignOperator(recordVar, (Mutable)new MutableObject((Object)recordCreationFunc));
            assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
            currentTopOp = assignOp;
            varToListify = recordVar;
        } else {
            varToListify = rightUnnestOp.getVariable();
        }
        AggregateFunctionCallExpression fListify = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, this.mkSingletonArrayList(new MutableObject((Object)new VariableReferenceExpression(varToListify))));
        LogicalVariable aggVar = this.context.newSubplanOutputVar();
        AggregateOperator aggOp = new AggregateOperator(this.mkSingletonArrayList(aggVar), this.mkSingletonArrayList(new MutableObject((Object)fListify)));
        aggOp.getInputs().add(new MutableObject((Object)currentTopOp));
        this.context.exitSubplan();
        ALogicalPlanImpl subplan = new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
        subplanOp.getNestedPlans().add(subplan);
        LogicalVariable outerUnnestVar = this.context.newVar();
        LeftOuterUnnestOperator outerUnnestOp = new LeftOuterUnnestOperator(outerUnnestVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)new VariableReferenceExpression(aggVar))));
        outerUnnestOp.getInputs().add(new MutableObject((Object)subplanOp));
        currentTopOp = outerUnnestOp;
        if (hasRightPosVar) {
            ScalarFunctionCallExpression fieldAccessForRightUnnestVar = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(outerUnnestVar)), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0))))});
            ScalarFunctionCallExpression fieldAccessForRightPosVar = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(outerUnnestVar)), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(1))))});
            LogicalVariable rightUnnestVar = this.context.newVar();
            LogicalVariable rightPosVar = this.context.newVar();
            this.context.setVar(joinClause.getRightVariable(), rightUnnestVar);
            this.context.setVar(joinClause.getPositionalVariable(), rightPosVar);
            ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>();
            assignVars.add(rightUnnestVar);
            assignVars.add(rightPosVar);
            ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
            assignExprs.add(new MutableObject((Object)fieldAccessForRightUnnestVar));
            assignExprs.add(new MutableObject((Object)fieldAccessForRightPosVar));
            AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
            assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
            currentTopOp = assignOp;
        } else {
            this.context.setVar(joinClause.getRightVariable(), outerUnnestVar);
        }
        return new Pair((Object)currentTopOp, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(NestClause nestClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new NotImplementedException("Nest clause has not been implemented");
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnnestClause unnestClause, Mutable<ILogicalOperator> inputOpRef) throws CompilationException {
        return this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)unnestClause, inputOpRef, unnestClause.getJoinType() == JoinType.INNER);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(HavingClause havingClause, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(havingClause.getFilterExpression(), tupSource);
        SelectOperator s = new SelectOperator((Mutable)new MutableObject(p.first), false, null);
        s.getInputs().add(p.second);
        return new Pair((Object)s, null);
    }

    private Pair<ILogicalOperator, LogicalVariable> generateUnnestForBinaryCorrelateRightBranch(AbstractBinaryCorrelateClause binaryCorrelate, Mutable<ILogicalOperator> inputOpRef, boolean innerUnnest) throws CompilationException {
        UnnestOperator unnestOp;
        LogicalVariable rightVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getRightVariable());
        Expression rightExpr = binaryCorrelate.getRightExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(rightExpr, inputOpRef);
        if (binaryCorrelate.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getPositionalVariable());
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter()) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter());
        } else {
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first))) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)));
        }
        unnestOp.getInputs().add(eo.second);
        return new Pair((Object)unnestOp, (Object)rightVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectClause selectClause, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectElement selectElement, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectRegular selectRegular, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(Projection projection, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(CaseExpression caseExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        ILogicalOperator currentOperator = null;
        List whenExprList = caseExpression.getWhenExprs();
        List thenExprList = caseExpression.getThenExprs();
        ArrayList<ILogicalExpression> branchCondVarReferences = new ArrayList<ILogicalExpression>();
        ArrayList<VariableReferenceExpression> allVarReferences = new ArrayList<VariableReferenceExpression>();
        for (int index = 0; index < whenExprList.size(); ++index) {
            Pair whenExprResult = (Pair)((Expression)whenExprList.get(index)).accept((ILangVisitor)this, (Object)currentOpRef);
            currentOperator = (ILogicalOperator)whenExprResult.first;
            LogicalVariable whenConditionVar = (LogicalVariable)whenExprResult.second;
            MutableObject branchEntraceConditionExprRef = new MutableObject((Object)new VariableReferenceExpression(whenConditionVar));
            if (!branchCondVarReferences.isEmpty()) {
                ArrayList<Object> andArgs = new ArrayList<Object>();
                andArgs.add(this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences));
                andArgs.add(branchEntraceConditionExprRef);
                branchEntraceConditionExprRef = new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), andArgs));
            }
            Iterator opAndVarForThen = this.constructSubplanOperatorForBranch(currentOperator, (Mutable<ILogicalExpression>)branchEntraceConditionExprRef, (Expression)thenExprList.get(index));
            branchCondVarReferences.add((ILogicalExpression)new VariableReferenceExpression(whenConditionVar));
            allVarReferences.add(new VariableReferenceExpression(whenConditionVar));
            allVarReferences.add(new VariableReferenceExpression((LogicalVariable)((Pair)opAndVarForThen).second));
            currentOperator = (ILogicalOperator)((Pair)opAndVarForThen).first;
            currentOpRef = new MutableObject((Object)currentOperator);
        }
        Mutable<ILogicalExpression> elseCondExprRef = this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences);
        Pair<ILogicalOperator, LogicalVariable> opAndVarForElse = this.constructSubplanOperatorForBranch(currentOperator, elseCondExprRef, caseExpression.getElseExpr());
        LogicalVariable selectVar = this.context.newVar();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE))));
        for (ILogicalExpression iLogicalExpression : allVarReferences) {
            arguments.add(new MutableObject((Object)iLogicalExpression));
        }
        arguments.add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)opAndVarForElse.second)));
        ScalarFunctionCallExpression swithCaseExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), arguments);
        AssignOperator assignOperator = new AssignOperator(selectVar, (Mutable)new MutableObject((Object)swithCaseExpr));
        assignOperator.getInputs().add(new MutableObject(opAndVarForElse.first));
        LogicalVariable unnestVar = this.context.newVar();
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)new VariableReferenceExpression(selectVar))))));
        unnestOp.getInputs().add(new MutableObject((Object)assignOperator));
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator finalAssignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)new VariableReferenceExpression(unnestVar)));
        finalAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        return new Pair((Object)finalAssignOp, (Object)resultVar);
    }

    private Pair<ILogicalOperator, LogicalVariable> produceSelectPlan(boolean isSubquery, Mutable<ILogicalOperator> returnOpRef, LogicalVariable resVar) {
        if (isSubquery) {
            return this.aggListifyForSubquery(resVar, returnOpRef, false);
        }
        ProjectOperator pr = new ProjectOperator(resVar);
        pr.getInputs().add(returnOpRef);
        return new Pair((Object)pr, (Object)resVar);
    }

    private void replaceNtsWithEtsTopDown(Mutable<ILogicalOperator> opRef) {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            opRef.setValue((Object)new EmptyTupleSourceOperator());
        }
        for (Mutable childRef : op.getInputs()) {
            this.replaceNtsWithEtsTopDown((Mutable<ILogicalOperator>)childRef);
        }
    }

    private Pair<ILogicalOperator, LogicalVariable> processSelectClause(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        LogicalVariable returnVar;
        ILogicalOperator returnOperator;
        SelectClause selectClause = selectBlock.getSelectClause();
        Expression returnExpr = selectClause.selectElement() ? selectClause.getSelectElement().getExpression() : this.generateReturnExpr(selectClause, selectBlock);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(returnExpr, tupSrc);
        if (returnExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            VariableExpr varExpr = (VariableExpr)returnExpr;
            returnOperator = (ILogicalOperator)((Mutable)eo.second).getValue();
            returnVar = this.context.getVar(varExpr.getVar().getId());
        } else {
            returnVar = this.context.newVar();
            returnOperator = new AssignOperator(returnVar, (Mutable)new MutableObject(eo.first));
            returnOperator.getInputs().add(eo.second);
        }
        if (selectClause.distinct()) {
            DistinctOperator distinctOperator = new DistinctOperator(this.mkSingletonArrayList(new MutableObject((Object)new VariableReferenceExpression(returnVar))));
            distinctOperator.getInputs().add(new MutableObject((Object)returnOperator));
            return new Pair((Object)distinctOperator, (Object)returnVar);
        }
        return new Pair((Object)returnOperator, (Object)returnVar);
    }

    private Expression generateReturnExpr(SelectClause selectClause, SelectBlock selectBlock) {
        SelectRegular selectRegular = selectClause.getSelectRegular();
        ArrayList<FieldBinding> fieldBindings = new ArrayList<FieldBinding>();
        List projections = selectRegular.getProjections();
        for (Projection projection : projections) {
            if (projection.star()) {
                if (selectBlock.hasGroupbyClause()) {
                    fieldBindings.addAll(this.getGroupBindings(selectBlock.getGroupbyClause()));
                    continue;
                }
                if (!selectBlock.hasFromClause()) continue;
                fieldBindings.addAll(this.getFromBindings(selectBlock.getFromClause()));
                continue;
            }
            fieldBindings.add(new FieldBinding((Expression)new LiteralExpr((Literal)new StringLiteral(projection.getName())), projection.getExpression()));
        }
        return new RecordConstructor(fieldBindings);
    }

    private List<FieldBinding> getFromBindings(FromClause fromClause) {
        ArrayList<FieldBinding> fieldBindings = new ArrayList<FieldBinding>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            fieldBindings.add(this.getFieldBinding(fromTerm.getLeftVariable()));
            if (fromTerm.hasPositionalVariable()) {
                fieldBindings.add(this.getFieldBinding(fromTerm.getPositionalVariable()));
            }
            if (!fromTerm.hasCorrelateClauses()) continue;
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                fieldBindings.add(this.getFieldBinding(correlateClause.getRightVariable()));
                if (!correlateClause.hasPositionalVariable()) continue;
                fieldBindings.add(this.getFieldBinding(correlateClause.getPositionalVariable()));
            }
        }
        return fieldBindings;
    }

    private List<FieldBinding> getGroupBindings(GroupbyClause groupbyClause) {
        ArrayList<FieldBinding> fieldBindings = new ArrayList<FieldBinding>();
        for (GbyVariableExpressionPair pair : groupbyClause.getGbyPairList()) {
            fieldBindings.add(this.getFieldBinding(pair.getVar()));
        }
        if (groupbyClause.hasWithMap() && groupbyClause.hasGroupVar()) {
            fieldBindings.add(this.getFieldBinding((VariableExpr)groupbyClause.getWithVarMap().get(groupbyClause.getGroupVar())));
        }
        return fieldBindings;
    }

    private FieldBinding getFieldBinding(VariableExpr var) {
        LiteralExpr fieldName = new LiteralExpr((Literal)new StringLiteral(SqlppVariableUtil.variableNameToDisplayedFieldName((String)var.getVar().getValue())));
        return new FieldBinding((Expression)fieldName, (Expression)var);
    }
}

