/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SessionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OOB_HYRACKS_JOB = "oob-hyracks-job";
    public static final String OOB_EXPR_TREE = "oob-expr-tree";
    public static final String OOB_REWRITTEN_EXPR_TREE = "oob-rewritten-expr-tree";
    public static final String OOB_LOGICAL_PLAN = "oob-logical-plan";
    public static final String OOB_OPTIMIZED_LOGICAL_PLAN = "oob-optimized-logical-plan";
    public static final String FORMAT_ONLY_PHYSICAL_OPS = "format-only-physical-ops";
    public static final String FORMAT_HTML = "format-html";
    public static final String FORMAT_CSV_HEADER = "format-csv-header";
    public static final String FORMAT_WRAPPER_ARRAY = "format-wrapper-array";
    public static final String FORMAT_INDENT_JSON = "indent-json";
    public static final String FORMAT_QUOTE_RECORD = "quote-record";
    private final OutputFormat fmt;
    private final boolean executeQuery;
    private final boolean generateJobSpec;
    private final boolean optimize;
    private final Map<String, Boolean> flags;

    public SessionConfig(OutputFormat fmt) {
        this(fmt, true, true, true);
    }

    public SessionConfig(OutputFormat fmt, boolean optimize, boolean executeQuery, boolean generateJobSpec) {
        this.fmt = fmt;
        this.optimize = optimize;
        this.executeQuery = executeQuery;
        this.generateJobSpec = generateJobSpec;
        this.flags = new HashMap<String, Boolean>();
    }

    public OutputFormat fmt() {
        return this.fmt;
    }

    public boolean isExecuteQuery() {
        return this.executeQuery;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public boolean isGenerateJobSpec() {
        return this.generateJobSpec;
    }

    public void setOOBData(boolean exprTree, boolean rewrittenExprTree, boolean logicalPlan, boolean optimizedLogicalPlan, boolean hyracksJob) {
        this.set(OOB_EXPR_TREE, exprTree);
        this.set(OOB_REWRITTEN_EXPR_TREE, rewrittenExprTree);
        this.set(OOB_LOGICAL_PLAN, logicalPlan);
        this.set(OOB_OPTIMIZED_LOGICAL_PLAN, optimizedLogicalPlan);
        this.set(OOB_HYRACKS_JOB, hyracksJob);
    }

    public void set(String flag, boolean value) {
        this.flags.put(flag, value);
    }

    public boolean is(String flag) {
        Boolean value = this.flags.get(flag);
        return value == null ? false : value;
    }

    public static enum OutputFormat {
        ADM,
        CSV,
        CLEAN_JSON,
        LOSSLESS_JSON;

    }
}

