/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.lang.aql.util.RangeMapBuilder;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.AbstractQueryExpressionVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.LoadableDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.functions.ExternalFunctionCompilerUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.FunctionInfo;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ConstantHelper;
import org.apache.asterix.translator.TranslationContext;
import org.apache.asterix.translator.TranslationException;
import org.apache.asterix.translator.util.PlanTranslationUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorDelegate;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.ManagedFileSplit;
import org.apache.hyracks.dataflow.common.data.partition.range.IRangeMap;

class LangExpressionToPlanTranslator
extends AbstractQueryExpressionVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>>
implements ILangExpressionToPlanTranslator {
    protected final MetadataProvider metadataProvider;
    protected final TranslationContext context;
    private static final AtomicLong outputFileID = new AtomicLong(0L);
    private static final String OUTPUT_FILE_PREFIX = "OUTPUT_";

    public LangExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounterValue) throws AlgebricksException {
        this.context = new TranslationContext(new Counter(currentVarCounterValue));
        this.metadataProvider = metadataProvider;
    }

    public LangExpressionToPlanTranslator(MetadataProvider metadataProvider, Counter currentVarCounter) throws AlgebricksException {
        this.context = new TranslationContext(currentVarCounter);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public int getVarCounter() {
        return this.context.getVarCounter();
    }

    @Override
    public ILogicalPlan translateLoad(CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        LoadableDataSource lds;
        CompiledStatements.CompiledLoadFromFileStatement clffs = (CompiledStatements.CompiledLoadFromFileStatement)stmt;
        Dataset dataset = this.metadataProvider.findDataset(clffs.getDataverseName(), clffs.getDatasetName());
        if (dataset == null) {
            throw new AlgebricksException("Unable to load dataset " + clffs.getDatasetName() + " since it does not exist");
        }
        IAType itemType = this.metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        IAType metaItemType = this.metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        DatasetDataSource targetDatasource = this.validateDatasetInfo(this.metadataProvider, stmt.getDataverseName(), stmt.getDatasetName());
        List partitionKeys = targetDatasource.getDataset().getPrimaryKeys();
        if (dataset.hasMetaPart()) {
            throw new AlgebricksException(dataset.getDatasetName() + ": load dataset is not supported on Datasets with Meta records");
        }
        try {
            lds = new LoadableDataSource(dataset, itemType, metaItemType, clffs.getAdapter(), clffs.getProperties());
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        EmptyTupleSourceOperator etsOp = new EmptyTupleSourceOperator();
        ArrayList<LogicalVariable> payloadVars = new ArrayList<LogicalVariable>();
        payloadVars.add(this.context.newVar());
        DataSourceScanOperator dssOp = new DataSourceScanOperator(payloadVars, (IDataSource)lds);
        dssOp.getInputs().add(new MutableObject((Object)etsOp));
        VariableReferenceExpression payloadExpr = new VariableReferenceExpression((LogicalVariable)payloadVars.get(0));
        MutableObject payloadRef = new MutableObject((Object)payloadExpr);
        ArrayList<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> pkExprs = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> varRefsForLoading = new ArrayList<Mutable<ILogicalExpression>>();
        LogicalVariable payloadVar = (LogicalVariable)payloadVars.get(0);
        for (List keyFieldName : partitionKeys) {
            PlanTranslationUtil.prepareVarAndExpression(keyFieldName, payloadVar, pkVars, pkExprs, varRefsForLoading, this.context);
        }
        AssignOperator assign = new AssignOperator(pkVars, pkExprs);
        assign.getInputs().add(new MutableObject((Object)dssOp));
        if (clffs.alreadySorted()) {
            ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
            for (int i = 0; i < pkVars.size(); ++i) {
                orderColumns.add(new OrderColumn(pkVars.get(i), OrderOperator.IOrder.OrderKind.ASC));
            }
            assign.setExplicitOrderingProperty(new LocalOrderProperty(orderColumns));
        }
        List additionalFilteringField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
        ArrayList<Mutable<ILogicalExpression>> additionalFilteringExpressions = null;
        AssignOperator additionalFilteringAssign = null;
        if (additionalFilteringField != null) {
            ArrayList<LogicalVariable> additionalFilteringVars = new ArrayList<LogicalVariable>();
            ArrayList<Mutable<ILogicalExpression>> additionalFilteringAssignExpressions = new ArrayList<Mutable<ILogicalExpression>>();
            additionalFilteringExpressions = new ArrayList<Mutable<ILogicalExpression>>();
            PlanTranslationUtil.prepareVarAndExpression(additionalFilteringField, payloadVar, additionalFilteringVars, additionalFilteringAssignExpressions, additionalFilteringExpressions, this.context);
            additionalFilteringAssign = new AssignOperator(additionalFilteringVars, additionalFilteringAssignExpressions);
        }
        InsertDeleteUpsertOperator insertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, (Mutable)payloadRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.INSERT, true);
        insertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        if (additionalFilteringAssign != null) {
            additionalFilteringAssign.getInputs().add(new MutableObject((Object)assign));
            insertOp.getInputs().add(new MutableObject((Object)additionalFilteringAssign));
        } else {
            insertOp.getInputs().add(new MutableObject((Object)assign));
        }
        SinkOperator leafOperator = new SinkOperator();
        leafOperator.getInputs().add(new MutableObject((Object)insertOp));
        return new ALogicalPlanImpl((Mutable)new MutableObject((Object)leafOperator));
    }

    @Override
    public ILogicalPlan translate(Query expr, String outputDatasetName, CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        return this.translate(expr, outputDatasetName, stmt, null);
    }

    public ILogicalPlan translate(Query expr, String outputDatasetName, CompiledStatements.ICompiledDmlStatement stmt, ILogicalOperator baseOp) throws AlgebricksException {
        LogicalVariable unnestVar;
        MutableObject base = new MutableObject((Object)new EmptyTupleSourceOperator());
        if (baseOp != null) {
            base = new MutableObject((Object)baseOp);
        }
        Pair p = (Pair)expr.accept((ILangVisitor)this, (Object)base);
        ArrayList<MutableObject> globalPlanRoots = new ArrayList<MutableObject>();
        ILogicalOperator topOp = (ILogicalOperator)p.first;
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)topOp, liveVars);
        LogicalVariable resVar = unnestVar = (LogicalVariable)liveVars.get(0);
        if (outputDatasetName == null) {
            FileSplit outputFileSplit = this.metadataProvider.getOutputFile();
            if (outputFileSplit == null) {
                outputFileSplit = this.getDefaultOutputFileLocation(this.metadataProvider.getApplicationContext());
            }
            this.metadataProvider.setOutputFile(outputFileSplit);
            ArrayList<MutableObject> writeExprList = new ArrayList<MutableObject>(1);
            writeExprList.add(new MutableObject((Object)new VariableReferenceExpression(resVar)));
            ResultSetSinkId rssId = new ResultSetSinkId(this.metadataProvider.getResultSetId());
            ResultSetDataSink sink = new ResultSetDataSink(rssId, null);
            DistributeResultOperator newTop = new DistributeResultOperator(writeExprList, (IDataSink)sink);
            newTop.getInputs().add(new MutableObject((Object)topOp));
            topOp = newTop;
            ARecordType outputRecordType = this.metadataProvider.findOutputRecordType();
            if (outputRecordType != null) {
                topOp.getAnnotations().put("output-record-type", outputRecordType);
            }
        } else {
            ILogicalOperator leafOperator;
            LogicalVariable seqVar = this.context.newVar();
            AssignOperator assignCollectionToSequence = new AssignOperator(seqVar, (Mutable)new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.COLLECTION_TO_SEQUENCE), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(resVar))})));
            assignCollectionToSequence.getInputs().add(new MutableObject(((Mutable)topOp.getInputs().get(0)).getValue()));
            ((Mutable)topOp.getInputs().get(0)).setValue((Object)assignCollectionToSequence);
            ProjectOperator projectOperator = (ProjectOperator)topOp;
            projectOperator.getVariables().set(0, seqVar);
            resVar = seqVar;
            DatasetDataSource targetDatasource = this.validateDatasetInfo(this.metadataProvider, stmt.getDataverseName(), stmt.getDatasetName());
            List keySourceIndicator = ((InternalDatasetDetails)targetDatasource.getDataset().getDatasetDetails()).getKeySourceIndicator();
            ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
            ArrayList<Mutable<ILogicalExpression>> exprs = new ArrayList<Mutable<ILogicalExpression>>();
            ArrayList<Mutable<ILogicalExpression>> varRefsForLoading = new ArrayList<Mutable<ILogicalExpression>>();
            List partitionKeys = targetDatasource.getDataset().getPrimaryKeys();
            int numOfPrimaryKeys = partitionKeys.size();
            for (int i = 0; i < numOfPrimaryKeys; ++i) {
                if (keySourceIndicator == null || (Integer)keySourceIndicator.get(i) == 0) {
                    PlanTranslationUtil.prepareVarAndExpression((List)partitionKeys.get(i), resVar, vars, exprs, varRefsForLoading, this.context);
                    continue;
                }
                PlanTranslationUtil.prepareMetaKeyAccessExpression((List)partitionKeys.get(i), unnestVar, exprs, vars, varRefsForLoading, this.context);
            }
            AssignOperator assign = new AssignOperator(vars, exprs);
            List additionalFilteringField = DatasetUtil.getFilterField((Dataset)targetDatasource.getDataset());
            ArrayList<Mutable<ILogicalExpression>> additionalFilteringExpressions = null;
            AssignOperator additionalFilteringAssign = null;
            if (additionalFilteringField != null) {
                ArrayList<LogicalVariable> additionalFilteringVars = new ArrayList<LogicalVariable>();
                ArrayList<Mutable<ILogicalExpression>> additionalFilteringAssignExpressions = new ArrayList<Mutable<ILogicalExpression>>();
                additionalFilteringExpressions = new ArrayList<Mutable<ILogicalExpression>>();
                PlanTranslationUtil.prepareVarAndExpression(additionalFilteringField, resVar, additionalFilteringVars, additionalFilteringAssignExpressions, additionalFilteringExpressions, this.context);
                additionalFilteringAssign = new AssignOperator(additionalFilteringVars, additionalFilteringAssignExpressions);
                additionalFilteringAssign.getInputs().add(new MutableObject((Object)topOp));
                assign.getInputs().add(new MutableObject((Object)additionalFilteringAssign));
            } else {
                assign.getInputs().add(new MutableObject((Object)topOp));
            }
            MutableObject varRef = new MutableObject((Object)new VariableReferenceExpression(resVar));
            switch (stmt.getKind()) {
                case 5: {
                    leafOperator = this.translateInsert(targetDatasource, (Mutable<ILogicalExpression>)varRef, varRefsForLoading, additionalFilteringExpressions, (ILogicalOperator)assign, stmt);
                    break;
                }
                case 6: {
                    leafOperator = this.translateUpsert(targetDatasource, (Mutable<ILogicalExpression>)varRef, varRefsForLoading, additionalFilteringExpressions, (ILogicalOperator)assign, additionalFilteringField, unnestVar, topOp, exprs, resVar, additionalFilteringAssign, stmt);
                    break;
                }
                case 4: {
                    leafOperator = this.translateDelete(targetDatasource, (Mutable<ILogicalExpression>)varRef, varRefsForLoading, additionalFilteringExpressions, (ILogicalOperator)assign);
                    break;
                }
                case 26: {
                    leafOperator = this.translateConnectFeed(targetDatasource, (Mutable<ILogicalExpression>)varRef, varRefsForLoading, additionalFilteringExpressions, (ILogicalOperator)assign);
                    break;
                }
                case 36: {
                    leafOperator = this.translateSubscribeFeed((CompiledStatements.CompiledSubscribeFeedStatement)stmt, targetDatasource, unnestVar, topOp, exprs, resVar, varRefsForLoading, (Mutable<ILogicalExpression>)varRef, (ILogicalOperator)assign, additionalFilteringField, additionalFilteringAssign, additionalFilteringExpressions);
                    break;
                }
                default: {
                    throw new AlgebricksException("Unsupported statement kind " + stmt.getKind());
                }
            }
            topOp = leafOperator;
        }
        globalPlanRoots.add(new MutableObject((Object)topOp));
        ALogicalPlanImpl plan = new ALogicalPlanImpl(globalPlanRoots);
        this.eliminateSharedOperatorReferenceForPlan((ILogicalPlan)plan);
        return plan;
    }

    private ILogicalOperator translateConnectFeed(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, List<Mutable<ILogicalExpression>> additionalFilteringExpressions, ILogicalOperator assign) {
        InsertDeleteUpsertOperator insertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.INSERT, false);
        insertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        insertOp.getInputs().add(new MutableObject((Object)assign));
        DelegateOperator leafOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(true));
        leafOperator.getInputs().add(new MutableObject((Object)insertOp));
        return leafOperator;
    }

    private ILogicalOperator translateDelete(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, List<Mutable<ILogicalExpression>> additionalFilteringExpressions, ILogicalOperator assign) throws AlgebricksException {
        if (targetDatasource.getDataset().hasMetaPart()) {
            throw new AlgebricksException(targetDatasource.getDataset().getDatasetName() + ": delete from dataset is not supported on Datasets with Meta records");
        }
        InsertDeleteUpsertOperator deleteOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.DELETE, false);
        deleteOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        deleteOp.getInputs().add(new MutableObject((Object)assign));
        DelegateOperator leafOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(true));
        leafOperator.getInputs().add(new MutableObject((Object)deleteOp));
        return leafOperator;
    }

    private ILogicalOperator translateSubscribeFeed(CompiledStatements.CompiledSubscribeFeedStatement sfs, DatasetDataSource targetDatasource, LogicalVariable unnestVar, ILogicalOperator topOp, ArrayList<Mutable<ILogicalExpression>> exprs, LogicalVariable resVar, List<Mutable<ILogicalExpression>> varRefsForLoading, Mutable<ILogicalExpression> varRef, ILogicalOperator assign, List<String> additionalFilteringField, AssignOperator additionalFilteringAssign, List<Mutable<ILogicalExpression>> additionalFilteringExpressions) throws AlgebricksException {
        InsertDeleteUpsertOperator feedModificationOp;
        ArrayList<LogicalVariable> metaAndKeysVars = null;
        ArrayList<MutableObject> metaAndKeysExprs = null;
        ArrayList<MutableObject> metaExpSingletonList = null;
        Feed feed = this.metadataProvider.findFeed(sfs.getDataverseName(), sfs.getFeedName());
        boolean isChangeFeed = ExternalDataUtils.isChangeFeed((Map)feed.getAdapterConfiguration());
        boolean isUpsertFeed = ExternalDataUtils.isUpsertFeed((Map)feed.getAdapterConfiguration());
        ProjectOperator project = (ProjectOperator)topOp;
        if (targetDatasource.getDataset().hasMetaPart() || isChangeFeed) {
            metaAndKeysVars = new ArrayList<LogicalVariable>();
            metaAndKeysExprs = new ArrayList<MutableObject>();
            if (targetDatasource.getDataset().hasMetaPart()) {
                IFunctionInfo finfoMeta = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.META);
                ScalarFunctionCallExpression metaFunction = new ScalarFunctionCallExpression(finfoMeta, new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(unnestVar))});
                LogicalVariable metaVar = this.context.newVar();
                metaExpSingletonList = new ArrayList<MutableObject>(1);
                metaExpSingletonList.add(new MutableObject((Object)new VariableReferenceExpression(metaVar)));
                metaAndKeysVars.add(metaVar);
                metaAndKeysExprs.add(new MutableObject((Object)metaFunction));
                project.getVariables().add(metaVar);
            }
        }
        if (isChangeFeed) {
            varRefsForLoading.clear();
            for (Mutable<ILogicalExpression> assignExpr : exprs) {
                if (((ILogicalExpression)assignExpr.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression funcCall = (AbstractFunctionCallExpression)assignExpr.getValue();
                funcCall.substituteVar(resVar, unnestVar);
                LogicalVariable pkVar = this.context.newVar();
                metaAndKeysVars.add(pkVar);
                metaAndKeysExprs.add(new MutableObject(assignExpr.getValue()));
                project.getVariables().add(pkVar);
                varRefsForLoading.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(pkVar)));
            }
            feedModificationOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, metaExpSingletonList, InsertDeleteUpsertOperator.Kind.UPSERT, false);
            feedModificationOp.setPrevRecordVar(this.context.newVar());
            feedModificationOp.setPrevRecordType((Object)targetDatasource.getItemType());
            if (targetDatasource.getDataset().hasMetaPart()) {
                ArrayList<LogicalVariable> metaVars = new ArrayList<LogicalVariable>();
                metaVars.add(this.context.newVar());
                feedModificationOp.setPrevAdditionalNonFilteringVars(metaVars);
                ArrayList<IAType> metaTypes = new ArrayList<IAType>();
                metaTypes.add(targetDatasource.getMetaItemType());
                feedModificationOp.setPrevAdditionalNonFilteringTypes(metaTypes);
            }
            if (additionalFilteringField != null) {
                feedModificationOp.setPrevFilterVar(this.context.newVar());
                feedModificationOp.setPrevFilterType((Object)((ARecordType)targetDatasource.getItemType()).getFieldType(additionalFilteringField.get(0)));
                additionalFilteringAssign.getInputs().clear();
                additionalFilteringAssign.getInputs().add(assign.getInputs().get(0));
                feedModificationOp.getInputs().add(new MutableObject((Object)additionalFilteringAssign));
            } else {
                feedModificationOp.getInputs().add(assign.getInputs().get(0));
            }
        } else {
            InsertDeleteUpsertOperator.Kind opKind = isUpsertFeed ? InsertDeleteUpsertOperator.Kind.UPSERT : InsertDeleteUpsertOperator.Kind.INSERT;
            feedModificationOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, metaExpSingletonList, opKind, false);
            if (isUpsertFeed) {
                feedModificationOp.setPrevRecordVar(this.context.newVar());
                feedModificationOp.setPrevRecordType((Object)targetDatasource.getItemType());
            }
            feedModificationOp.getInputs().add(new MutableObject((Object)assign));
        }
        if (targetDatasource.getDataset().hasMetaPart() || isChangeFeed) {
            AssignOperator metaAndKeysAssign = new AssignOperator(metaAndKeysVars, metaAndKeysExprs);
            metaAndKeysAssign.getInputs().add(topOp.getInputs().get(0));
            topOp.getInputs().set(0, new MutableObject((Object)metaAndKeysAssign));
        }
        feedModificationOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        DelegateOperator leafOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(true));
        leafOperator.getInputs().add(new MutableObject((Object)feedModificationOp));
        return leafOperator;
    }

    private ILogicalOperator translateUpsert(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, List<Mutable<ILogicalExpression>> additionalFilteringExpressions, ILogicalOperator assign, List<String> additionalFilteringField, LogicalVariable unnestVar, ILogicalOperator topOp, List<Mutable<ILogicalExpression>> exprs, LogicalVariable resVar, AssignOperator additionalFilteringAssign, CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        InsertDeleteUpsertOperator upsertOp;
        if (!targetDatasource.getDataset().allow(topOp, (byte)3)) {
            throw new AlgebricksException(targetDatasource.getDataset().getDatasetName() + ": upsert into dataset is not supported on Datasets with Meta records");
        }
        ProjectOperator project = (ProjectOperator)topOp;
        CompiledStatements.CompiledUpsertStatement compiledUpsert = (CompiledStatements.CompiledUpsertStatement)stmt;
        Expression returnExpression = compiledUpsert.getReturnExpression();
        if (targetDatasource.getDataset().hasMetaPart()) {
            if (returnExpression != null) {
                throw new AlgebricksException("Returning not allowed on datasets with Meta records");
            }
            ArrayList<LogicalVariable> metaAndKeysVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> metaAndKeysExprs = new ArrayList<MutableObject>();
            IFunctionInfo finfoMeta = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.META);
            ScalarFunctionCallExpression metaFunction = new ScalarFunctionCallExpression(finfoMeta, new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(unnestVar))});
            LogicalVariable metaVar = this.context.newVar();
            ArrayList<MutableObject> metaExpSingletonList = new ArrayList<MutableObject>(1);
            metaExpSingletonList.add(new MutableObject((Object)new VariableReferenceExpression(metaVar)));
            metaAndKeysVars.add(metaVar);
            metaAndKeysExprs.add(new MutableObject((Object)metaFunction));
            project.getVariables().add(metaVar);
            varRefsForLoading.clear();
            for (Mutable<ILogicalExpression> assignExpr : exprs) {
                if (((ILogicalExpression)assignExpr.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression funcCall = (AbstractFunctionCallExpression)assignExpr.getValue();
                funcCall.substituteVar(resVar, unnestVar);
                LogicalVariable pkVar = this.context.newVar();
                metaAndKeysVars.add(pkVar);
                metaAndKeysExprs.add(new MutableObject(assignExpr.getValue()));
                project.getVariables().add(pkVar);
                varRefsForLoading.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(pkVar)));
            }
            upsertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, metaExpSingletonList, InsertDeleteUpsertOperator.Kind.UPSERT, false);
            upsertOp.setPrevRecordVar(this.context.newVar());
            upsertOp.setPrevRecordType((Object)targetDatasource.getItemType());
            if (targetDatasource.getDataset().hasMetaPart()) {
                ArrayList<LogicalVariable> metaVars = new ArrayList<LogicalVariable>();
                metaVars.add(this.context.newVar());
                upsertOp.setPrevAdditionalNonFilteringVars(metaVars);
                ArrayList<IAType> metaTypes = new ArrayList<IAType>();
                metaTypes.add(targetDatasource.getMetaItemType());
                upsertOp.setPrevAdditionalNonFilteringTypes(metaTypes);
            }
            if (additionalFilteringField != null) {
                upsertOp.setPrevFilterVar(this.context.newVar());
                upsertOp.setPrevFilterType((Object)((ARecordType)targetDatasource.getItemType()).getFieldType(additionalFilteringField.get(0)));
                additionalFilteringAssign.getInputs().clear();
                additionalFilteringAssign.getInputs().add(assign.getInputs().get(0));
                upsertOp.getInputs().add(new MutableObject((Object)additionalFilteringAssign));
            } else {
                upsertOp.getInputs().add(assign.getInputs().get(0));
            }
            AssignOperator metaAndKeysAssign = new AssignOperator(metaAndKeysVars, metaAndKeysExprs);
            metaAndKeysAssign.getInputs().add(topOp.getInputs().get(0));
            topOp.getInputs().set(0, new MutableObject((Object)metaAndKeysAssign));
            upsertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        } else {
            upsertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.UPSERT, false);
            upsertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
            upsertOp.getInputs().add(new MutableObject((Object)assign));
            ARecordType recordType = (ARecordType)targetDatasource.getItemType();
            upsertOp.setPrevRecordVar(this.context.newVar());
            upsertOp.setPrevRecordType((Object)recordType);
            if (additionalFilteringField != null) {
                upsertOp.setPrevFilterVar(this.context.newVar());
                upsertOp.setPrevFilterType((Object)recordType.getFieldType(additionalFilteringField.get(0)));
            }
        }
        DelegateOperator rootOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(returnExpression == null));
        rootOperator.getInputs().add(new MutableObject((Object)upsertOp));
        return this.processReturningExpression((ILogicalOperator)rootOperator, upsertOp, compiledUpsert);
    }

    private ILogicalOperator translateInsert(DatasetDataSource targetDatasource, Mutable<ILogicalExpression> varRef, List<Mutable<ILogicalExpression>> varRefsForLoading, List<Mutable<ILogicalExpression>> additionalFilteringExpressions, ILogicalOperator assign, CompiledStatements.ICompiledDmlStatement stmt) throws AlgebricksException {
        if (targetDatasource.getDataset().hasMetaPart()) {
            throw new AlgebricksException(targetDatasource.getDataset().getDatasetName() + ": insert into dataset is not supported on Datasets with Meta records");
        }
        InsertDeleteUpsertOperator insertOp = new InsertDeleteUpsertOperator((IDataSource)targetDatasource, varRef, varRefsForLoading, InsertDeleteUpsertOperator.Kind.INSERT, false);
        insertOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
        insertOp.getInputs().add(new MutableObject((Object)assign));
        CompiledStatements.CompiledInsertStatement compiledInsert = (CompiledStatements.CompiledInsertStatement)stmt;
        Expression returnExpression = compiledInsert.getReturnExpression();
        DelegateOperator rootOperator = new DelegateOperator((IOperatorDelegate)new CommitOperator(returnExpression == null));
        rootOperator.getInputs().add(new MutableObject((Object)insertOp));
        return this.processReturningExpression((ILogicalOperator)rootOperator, insertOp, compiledInsert);
    }

    private ILogicalOperator processReturningExpression(ILogicalOperator inputOperator, InsertDeleteUpsertOperator insertOp, CompiledStatements.CompiledInsertStatement compiledInsert) throws AlgebricksException {
        Expression returnExpression = compiledInsert.getReturnExpression();
        if (returnExpression == null) {
            return inputOperator;
        }
        ILogicalOperator rootOperator = inputOperator;
        this.context.newVarFromExpression((Expression)compiledInsert.getVar());
        this.context.setVar(compiledInsert.getVar(), ((VariableReferenceExpression)insertOp.getPayloadExpression().getValue()).getVariableReference());
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(returnExpression, (Mutable<ILogicalOperator>)new MutableObject((Object)rootOperator));
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator assignOperator = new AssignOperator(resultVar, (Mutable)new MutableObject(p.first));
        assignOperator.getInputs().add(p.second);
        ArrayList<MutableObject> expressions = new ArrayList<MutableObject>();
        expressions.add(new MutableObject((Object)new VariableReferenceExpression(resultVar)));
        ResultSetSinkId rssId = new ResultSetSinkId(this.metadataProvider.getResultSetId());
        ResultSetDataSink sink = new ResultSetDataSink(rssId, null);
        rootOperator = new DistributeResultOperator(expressions, (IDataSink)sink);
        rootOperator.getInputs().add(new MutableObject((Object)assignOperator));
        return rootOperator;
    }

    private DatasetDataSource validateDatasetInfo(MetadataProvider metadataProvider, String dataverseName, String datasetName) throws AlgebricksException {
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Cannot find dataset " + datasetName + " in dataverse " + dataverseName);
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            throw new AlgebricksException("Cannot write output to an external dataset.");
        }
        DataSourceId sourceId = new DataSourceId(dataverseName, datasetName);
        IAType itemType = metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        IAType metaItemType = metadataProvider.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        INodeDomain domain = metadataProvider.findNodeDomain(dataset.getNodeGroupName());
        return new DatasetDataSource(sourceId, dataset, itemType, metaItemType, 0, dataset.getDatasetDetails(), domain);
    }

    private FileSplit getDefaultOutputFileLocation(ICcApplicationContext appCtx) throws MetadataException {
        String outputDir = System.getProperty("java.io.tmpDir");
        String filePath = outputDir + System.getProperty("file.separator") + OUTPUT_FILE_PREFIX + outputFileID.incrementAndGet();
        MetadataProperties metadataProperties = appCtx.getMetadataProperties();
        return new ManagedFileSplit(metadataProperties.getMetadataNodeName(), filePath);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LetClause lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        AssignOperator returnedOp;
        LogicalVariable v;
        if (lc.getBindingExpr().getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            v = this.context.newVarFromExpression((Expression)lc.getVarExpr());
            LogicalVariable prev = this.context.getVar(((VariableExpr)lc.getBindingExpr()).getVar().getId());
            returnedOp = new AssignOperator(v, (Mutable)new MutableObject((Object)new VariableReferenceExpression(prev)));
            returnedOp.getInputs().add(tupSource);
        } else {
            v = this.context.newVarFromExpression((Expression)lc.getVarExpr());
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(lc.getBindingExpr(), tupSource);
            returnedOp = new AssignOperator(v, (Mutable)new MutableObject(eo.first));
            returnedOp.getInputs().add(eo.second);
        }
        return new Pair((Object)returnedOp, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FieldAccessor fa, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(fa.getExpr(), tupSource);
        LogicalVariable v = this.context.newVarFromExpression((Expression)fa);
        ScalarFunctionCallExpression fldAccess = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME));
        fldAccess.getArguments().add(new MutableObject(p.first));
        ConstantExpression faExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(fa.getIdent().getValue())));
        fldAccess.getArguments().add(new MutableObject((Object)faExpr));
        AssignOperator a = new AssignOperator(v, (Mutable)new MutableObject((Object)fldAccess));
        a.getInputs().add(p.second);
        return new Pair((Object)a, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(IndexAccessor ia, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ScalarFunctionCallExpression f;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(ia.getExpr(), tupSource);
        LogicalVariable v = this.context.newVar();
        if (ia.isAny()) {
            f = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.ANY_COLLECTION_MEMBER));
            f.getArguments().add(new MutableObject(p.first));
        } else {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> indexPair = this.langExprToAlgExpression(ia.getIndexExpr(), tupSource);
            f = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_ITEM));
            f.getArguments().add(new MutableObject(p.first));
            f.getArguments().add(new MutableObject(indexPair.first));
        }
        AssignOperator a = new AssignOperator(v, (Mutable)new MutableObject((Object)f));
        a.getInputs().add(p.second);
        return new Pair((Object)a, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(CallExpr fcall, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        LogicalVariable v = this.context.newVar();
        FunctionSignature signature = fcall.getFunctionSignature();
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        Mutable topOp = tupSource;
        block4: for (Object expr : fcall.getExprList()) {
            switch (expr.getKind()) {
                case VARIABLE_EXPRESSION: {
                    LogicalVariable var = this.context.getVar(((VariableExpr)expr).getVar().getId());
                    args.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(var)));
                    continue block4;
                }
                case LITERAL_EXPRESSION: {
                    LiteralExpr val = (LiteralExpr)expr;
                    args.add((Mutable<ILogicalExpression>)new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(ConstantHelper.objectFromLiteral(val.getValue())))));
                    continue block4;
                }
            }
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression((Expression)expr, topOp);
            AbstractLogicalOperator o1 = (AbstractLogicalOperator)((Mutable)eo.second).getValue();
            args.add((Mutable<ILogicalExpression>)new MutableObject(eo.first));
            if (o1 == null || o1.getOperatorTag() == LogicalOperatorTag.ASSIGN && LangExpressionToPlanTranslator.hasOnlyChild((ILogicalOperator)o1, topOp)) continue;
            topOp = (Mutable)eo.second;
        }
        AbstractFunctionCallExpression f = this.lookupUserDefinedFunction(signature, args);
        if (f == null) {
            f = this.lookupBuiltinFunction(signature.getName(), signature.getArity(), args);
        }
        if (f == null) {
            throw new CompilationException(" Unknown function " + signature.getName() + "@" + signature.getArity());
        }
        if (fcall.hasHints()) {
            for (IExpressionAnnotation hint : fcall.getHints()) {
                f.getAnnotations().put(hint, hint);
            }
        }
        AssignOperator op = new AssignOperator(v, (Mutable)new MutableObject((Object)f));
        if (topOp != null) {
            op.getInputs().add(topOp);
        }
        return new Pair((Object)op, (Object)v);
    }

    private AbstractFunctionCallExpression lookupUserDefinedFunction(FunctionSignature signature, List<Mutable<ILogicalExpression>> args) throws MetadataException {
        ScalarFunctionCallExpression f;
        if (signature.getNamespace() == null) {
            return null;
        }
        Function function = MetadataManager.INSTANCE.getFunction(this.metadataProvider.getMetadataTxnContext(), signature);
        if (function == null) {
            return null;
        }
        if (function.getLanguage().equalsIgnoreCase("JAVA")) {
            IFunctionInfo finfo = ExternalFunctionCompilerUtil.getExternalFunctionInfo((MetadataTransactionContext)this.metadataProvider.getMetadataTxnContext(), (Function)function);
            f = new ScalarFunctionCallExpression(finfo, args);
        } else if (function.getLanguage().equalsIgnoreCase("AQL")) {
            IFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionSignature)signature);
            f = new ScalarFunctionCallExpression(finfo, args);
        } else {
            throw new MetadataException(" User defined functions written in " + function.getLanguage() + " are not supported");
        }
        return f;
    }

    private AbstractFunctionCallExpression lookupBuiltinFunction(String functionName, int arity, List<Mutable<ILogicalExpression>> args) {
        AggregateFunctionCallExpression f;
        FunctionIdentifier builtinAquafi;
        FunctionIdentifier fi = new FunctionIdentifier("algebricks", functionName, arity);
        FunctionInfo afi = BuiltinFunctions.lookupFunction((FunctionIdentifier)fi);
        FunctionIdentifier functionIdentifier = builtinAquafi = afi == null ? null : afi.getFunctionIdentifier();
        if (builtinAquafi != null) {
            fi = builtinAquafi;
        } else {
            fi = new FunctionIdentifier("asterix", functionName, arity);
            afi = BuiltinFunctions.lookupFunction((FunctionIdentifier)fi);
            if (afi == null) {
                return null;
            }
        }
        if (BuiltinFunctions.isBuiltinAggregateFunction((FunctionIdentifier)fi)) {
            f = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)fi, args);
        } else if (BuiltinFunctions.isBuiltinUnnestingFunction((FunctionIdentifier)fi)) {
            UnnestingFunctionCallExpression ufce = new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)fi), args);
            ufce.setReturnsUniqueValues(BuiltinFunctions.returnsUniqueValues((FunctionIdentifier)fi));
            f = ufce;
        } else {
            f = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)fi), args);
        }
        return f;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FunctionDecl fd, Mutable<ILogicalOperator> tupSource) {
        throw new IllegalStateException("Function declarations should be inlined at AST rewriting phase.");
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(GroupbyClause gc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo;
        LogicalVariable v;
        VariableExpr vexpr;
        Mutable topOp = tupSource;
        if (gc.hasGroupVar()) {
            List groupFieldList = gc.getGroupFieldList();
            ArrayList<MutableObject> groupRecordConstructorArgList = new ArrayList<MutableObject>();
            for (Pair groupField : groupFieldList) {
                ILogicalExpression groupFieldNameExpr = (ILogicalExpression)this.langExprToAlgExpression((Expression)new LiteralExpr((Literal)new StringLiteral((String)((Identifier)groupField.second).getValue())), (Mutable<ILogicalOperator>)topOp).first;
                groupRecordConstructorArgList.add(new MutableObject((Object)groupFieldNameExpr));
                ILogicalExpression groupFieldExpr = (ILogicalExpression)this.langExprToAlgExpression((Expression)((Expression)groupField.first), (Mutable<ILogicalOperator>)topOp).first;
                groupRecordConstructorArgList.add(new MutableObject((Object)groupFieldExpr));
            }
            LogicalVariable logicalVariable = this.context.newVarFromExpression((Expression)gc.getGroupVar());
            AssignOperator groupVarAssignOp = new AssignOperator(logicalVariable, (Mutable)new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), groupRecordConstructorArgList)));
            groupVarAssignOp.getInputs().add(topOp);
            topOp = new MutableObject((Object)groupVarAssignOp);
        }
        GroupByOperator gOp = new GroupByOperator();
        for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getGbyPairList()) {
            vexpr = gbyVariableExpressionPair.getVar();
            v = vexpr == null ? this.context.newVar() : this.context.newVarFromExpression((Expression)vexpr);
            eo = this.langExprToAlgExpression(gbyVariableExpressionPair.getExpr(), (Mutable<ILogicalOperator>)topOp);
            gOp.addGbyExpression(v, (ILogicalExpression)eo.first);
            topOp = (Mutable)eo.second;
        }
        for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getDecorPairList()) {
            vexpr = gbyVariableExpressionPair.getVar();
            v = vexpr == null ? this.context.newVar() : this.context.newVarFromExpression((Expression)vexpr);
            eo = this.langExprToAlgExpression(gbyVariableExpressionPair.getExpr(), (Mutable<ILogicalOperator>)topOp);
            gOp.addDecorExpression(v, (ILogicalExpression)eo.first);
            topOp = (Mutable)eo.second;
        }
        gOp.getInputs().add(topOp);
        for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> listifyInput = this.langExprToAlgExpression((Expression)entry.getKey(), (Mutable<ILogicalOperator>)new MutableObject((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)gOp))));
            ArrayList<MutableObject> flArgs = new ArrayList<MutableObject>(1);
            flArgs.add(new MutableObject(listifyInput.first));
            AggregateFunctionCallExpression fListify = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, flArgs);
            LogicalVariable aggVar = this.context.newVar();
            AggregateOperator agg = new AggregateOperator(this.mkSingletonArrayList(aggVar), this.mkSingletonArrayList(new MutableObject((Object)fListify)));
            agg.getInputs().add(listifyInput.second);
            ALogicalPlanImpl plan = new ALogicalPlanImpl((Mutable)new MutableObject((Object)agg));
            gOp.getNestedPlans().add(plan);
            this.context.setVar((VariableExpr)entry.getValue(), aggVar);
        }
        gOp.setGroupAll(gc.isGroupAll());
        gOp.getAnnotations().put("USE_HASH_GROUP_BY", gc.hasHashGroupByHint());
        return new Pair((Object)gOp, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(IfExpr ifexpr, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair pCond = (Pair)ifexpr.getCondExpr().accept((ILangVisitor)this, tupSource);
        LogicalVariable varCond = (LogicalVariable)pCond.second;
        Pair<ILogicalOperator, LogicalVariable> opAndVarForThen = this.constructSubplanOperatorForBranch((ILogicalOperator)pCond.first, (Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(varCond)), ifexpr.getThenExpr());
        ScalarFunctionCallExpression notVarCond = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.NOT), Collections.singletonList(this.generateAndNotIsUnknownWrap((ILogicalExpression)new VariableReferenceExpression(varCond))));
        Pair<ILogicalOperator, LogicalVariable> opAndVarForElse = this.constructSubplanOperatorForBranch((ILogicalOperator)opAndVarForThen.first, (Mutable<ILogicalExpression>)new MutableObject((Object)notVarCond), ifexpr.getElseExpr());
        LogicalVariable selectVar = this.context.newVar();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)new VariableReferenceExpression(varCond)));
        arguments.add(new MutableObject((Object)ConstantExpression.TRUE));
        arguments.add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)opAndVarForThen.second)));
        arguments.add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)opAndVarForElse.second)));
        ScalarFunctionCallExpression swithCaseExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), arguments);
        AssignOperator assignOp = new AssignOperator(selectVar, (Mutable)new MutableObject((Object)swithCaseExpr));
        assignOp.getInputs().add(new MutableObject(opAndVarForElse.first));
        LogicalVariable unnestVar = this.context.newVar();
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)new VariableReferenceExpression(selectVar))))));
        unnestOp.getInputs().add(new MutableObject((Object)assignOp));
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator finalAssignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)new VariableReferenceExpression(unnestVar)));
        finalAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        return new Pair((Object)finalAssignOp, (Object)resultVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LiteralExpr l, Mutable<ILogicalOperator> tupSource) {
        LogicalVariable var = this.context.newVar();
        AssignOperator a = new AssignOperator(var, (Mutable)new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(ConstantHelper.objectFromLiteral(l.getValue())))));
        if (tupSource != null) {
            a.getInputs().add(tupSource);
        }
        return new Pair((Object)a, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(OperatorExpr op, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        List ops = op.getOpList();
        int nOps = ops.size();
        if (nOps > 0 && (ops.get(0) == OperatorType.AND || ops.get(0) == OperatorType.OR)) {
            return this.visitAndOrOperator(op, tupSource);
        }
        List exprs = op.getExprList();
        Mutable topOp = tupSource;
        AbstractFunctionCallExpression currExpr = null;
        for (int i = 0; i <= nOps; ++i) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression((Expression)exprs.get(i), topOp);
            topOp = (Mutable)p.second;
            ILogicalExpression e = (ILogicalExpression)p.first;
            if (i < nOps) {
                if (OperatorExpr.opIsComparison((OperatorType)((OperatorType)ops.get(i)))) {
                    BroadcastExpressionAnnotation bcast;
                    AbstractFunctionCallExpression c = this.createComparisonExpression((OperatorType)ops.get(i));
                    if (i == 0) {
                        c.getArguments().add(new MutableObject((Object)e));
                        currExpr = c;
                        if (!op.isBroadcastOperand(i)) continue;
                        bcast = new BroadcastExpressionAnnotation();
                        bcast.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.LEFT);
                        c.getAnnotations().put("broadcast", bcast);
                        continue;
                    }
                    ((AbstractFunctionCallExpression)currExpr).getArguments().add(new MutableObject((Object)e));
                    c.getArguments().add(new MutableObject((Object)currExpr));
                    currExpr = c;
                    if (i != 1 || !op.isBroadcastOperand(i)) continue;
                    bcast = new BroadcastExpressionAnnotation();
                    bcast.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
                    c.getAnnotations().put("broadcast", bcast);
                    continue;
                }
                AbstractFunctionCallExpression f = this.createFunctionCallExpressionForBuiltinOperator((OperatorType)ops.get(i));
                if (i == 0) {
                    f.getArguments().add(new MutableObject((Object)e));
                    currExpr = f;
                    continue;
                }
                ((AbstractFunctionCallExpression)currExpr).getArguments().add(new MutableObject((Object)e));
                f.getArguments().add(new MutableObject((Object)currExpr));
                currExpr = f;
                continue;
            }
            ((AbstractFunctionCallExpression)currExpr).getArguments().add(new MutableObject((Object)e));
            if (i != 1 || !op.isBroadcastOperand(i)) continue;
            BroadcastExpressionAnnotation bcast = new BroadcastExpressionAnnotation();
            bcast.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
            currExpr.getAnnotations().put("broadcast", bcast);
        }
        if (op.hasHints() && currExpr instanceof AbstractFunctionCallExpression) {
            AbstractFunctionCallExpression currFuncExpr = currExpr;
            for (IExpressionAnnotation hint : op.getHints()) {
                currFuncExpr.getAnnotations().put(hint, hint);
            }
        }
        LogicalVariable assignedVar = this.context.newVar();
        AssignOperator a = new AssignOperator(assignedVar, (Mutable)new MutableObject(currExpr));
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)assignedVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(OrderbyClause oc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        OrderOperator ord = new OrderOperator();
        Iterator modifIter = oc.getModifierList().iterator();
        Mutable topOp = tupSource;
        for (Expression e : oc.getOrderbyList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(e, topOp);
            OrderbyClause.OrderModifier m = (OrderbyClause.OrderModifier)modifIter.next();
            OrderOperator.IOrder comp = m == OrderbyClause.OrderModifier.ASC ? OrderOperator.ASC_ORDER : OrderOperator.DESC_ORDER;
            ord.getOrderExpressions().add(new Pair((Object)comp, (Object)new MutableObject(p.first)));
            topOp = (Mutable)p.second;
        }
        ord.getInputs().add(topOp);
        if (oc.getNumTuples() > 0) {
            ord.getAnnotations().put("CARDINALITY", oc.getNumTuples());
        }
        if (oc.getNumFrames() > 0) {
            ord.getAnnotations().put("MAX_NUMBER_FRAMES", oc.getNumFrames());
        }
        if (oc.getRangeMap() != null) {
            Iterator orderModifIter = oc.getModifierList().iterator();
            boolean ascending = orderModifIter.next() == OrderbyClause.OrderModifier.ASC;
            RangeMapBuilder.verifyRangeOrder((IRangeMap)oc.getRangeMap(), (boolean)ascending);
            ord.getAnnotations().put("USE_RANGE_CONNECTOR", oc.getRangeMap());
        }
        return new Pair((Object)ord, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        AggregateFunctionCallExpression fAgg;
        SelectOperator s;
        Mutable topOp = tupSource;
        UnnestOperator firstOp = null;
        MutableObject lastOp = null;
        for (QuantifiedPair qt : qe.getQuantifiedList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(qt.getExpr(), topOp);
            topOp = (Mutable)eo1.second;
            LogicalVariable uVar = this.context.newVarFromExpression((Expression)qt.getVarExpr());
            UnnestOperator u = new UnnestOperator(uVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo1.first)));
            if (firstOp == null) {
                firstOp = u;
            }
            if (lastOp != null) {
                u.getInputs().add(lastOp);
            }
            lastOp = new MutableObject((Object)u);
        }
        firstOp.getInputs().add(topOp);
        topOp = lastOp;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo2 = this.langExprToAlgExpression(qe.getSatisfiesExpr(), topOp);
        if (qe.getQuantifier() == QuantifiedExpression.Quantifier.SOME) {
            s = new SelectOperator((Mutable)new MutableObject(eo2.first), false, null);
            s.getInputs().add(eo2.second);
            fAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.NON_EMPTY_STREAM, new ArrayList());
        } else {
            ArrayList<MutableObject> satExprList = new ArrayList<MutableObject>(1);
            satExprList.add(new MutableObject(eo2.first));
            s = new SelectOperator((Mutable)new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.NOT), satExprList)), false, null);
            s.getInputs().add(eo2.second);
            fAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.EMPTY_STREAM, new ArrayList());
        }
        LogicalVariable qeVar = this.context.newVar();
        AggregateOperator a = new AggregateOperator(this.mkSingletonArrayList(qeVar), this.mkSingletonArrayList(new MutableObject((Object)fAgg)));
        a.getInputs().add(new MutableObject((Object)s));
        return new Pair((Object)a, (Object)qeVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return (Pair)q.getBody().accept((ILangVisitor)this, tupSource);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(RecordConstructor rc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR));
        LogicalVariable v1 = this.context.newVar();
        AssignOperator a = new AssignOperator(v1, (Mutable)new MutableObject((Object)f));
        Mutable topOp = tupSource;
        for (FieldBinding fb : rc.getFbList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(fb.getLeftExpr(), topOp);
            f.getArguments().add(new MutableObject(eo1.first));
            topOp = (Mutable)eo1.second;
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo2 = this.langExprToAlgExpression(fb.getRightExpr(), (Mutable<ILogicalOperator>)topOp);
            f.getArguments().add(new MutableObject(eo2.first));
            topOp = (Mutable)eo2.second;
        }
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(ListConstructor lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        FunctionIdentifier fid = lc.getType() == ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR ? BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR : BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR;
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)fid));
        LogicalVariable v1 = this.context.newVar();
        AssignOperator a = new AssignOperator(v1, (Mutable)new MutableObject((Object)f));
        Mutable topOp = tupSource;
        for (Expression expr : lc.getExprList()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(expr, topOp);
            f.getArguments().add(new MutableObject(eo.first));
            topOp = (Mutable)eo.second;
        }
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnaryExpr u, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        AssignOperator a;
        Expression expr = u.getExpr();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(expr, tupSource);
        LogicalVariable v1 = this.context.newVar();
        switch (u.getExprType()) {
            case POSITIVE: {
                a = new AssignOperator(v1, (Mutable)new MutableObject(eo.first));
                break;
            }
            case NEGATIVE: {
                ScalarFunctionCallExpression m = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NUMERIC_UNARY_MINUS));
                m.getArguments().add(new MutableObject(eo.first));
                a = new AssignOperator(v1, (Mutable)new MutableObject((Object)m));
                break;
            }
            case EXISTS: {
                a = this.processExists((ILogicalExpression)eo.first, v1, false);
                break;
            }
            case NOT_EXISTS: {
                a = this.processExists((ILogicalExpression)eo.first, v1, true);
                break;
            }
            default: {
                throw new CompilationException("Unsupported operator: " + u);
            }
        }
        a.getInputs().add(eo.second);
        return new Pair((Object)a, (Object)v1);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(VariableExpr v, Mutable<ILogicalOperator> tupSource) {
        LogicalVariable var = this.context.newVar();
        LogicalVariable oldV = this.context.getVar(v.getVar().getId());
        AssignOperator a = new AssignOperator(var, (Mutable)new MutableObject((Object)new VariableReferenceExpression(oldV)));
        a.getInputs().add(tupSource);
        return new Pair((Object)a, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(WhereClause w, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(w.getWhereExpr(), tupSource);
        SelectOperator s = new SelectOperator((Mutable)new MutableObject(p.first), false, null);
        s.getInputs().add(p.second);
        return new Pair((Object)s, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(LimitClause lc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        LimitOperator opLim;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p1 = this.langExprToAlgExpression(lc.getLimitExpr(), tupSource);
        Expression offset = lc.getOffset();
        if (offset != null) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p2 = this.langExprToAlgExpression(offset, (Mutable<ILogicalOperator>)((Mutable)p1.second));
            opLim = new LimitOperator((ILogicalExpression)p1.first, (ILogicalExpression)p2.first);
            opLim.getInputs().add(p2.second);
        } else {
            opLim = new LimitOperator((ILogicalExpression)p1.first);
            opLim.getInputs().add(p1.second);
        }
        return new Pair((Object)opLim, null);
    }

    protected AbstractFunctionCallExpression createComparisonExpression(OperatorType t) {
        FunctionIdentifier fi = LangExpressionToPlanTranslator.operatorTypeToFunctionIdentifier(t);
        IFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)fi);
        return new ScalarFunctionCallExpression(finfo);
    }

    private static FunctionIdentifier operatorTypeToFunctionIdentifier(OperatorType t) {
        switch (t) {
            case EQ: {
                return AlgebricksBuiltinFunctions.EQ;
            }
            case NEQ: {
                return AlgebricksBuiltinFunctions.NEQ;
            }
            case GT: {
                return AlgebricksBuiltinFunctions.GT;
            }
            case GE: {
                return AlgebricksBuiltinFunctions.GE;
            }
            case LT: {
                return AlgebricksBuiltinFunctions.LT;
            }
            case LE: {
                return AlgebricksBuiltinFunctions.LE;
            }
        }
        throw new IllegalStateException();
    }

    protected AbstractFunctionCallExpression createFunctionCallExpressionForBuiltinOperator(OperatorType t) throws CompilationException {
        FunctionIdentifier fid;
        switch (t) {
            case PLUS: {
                fid = AlgebricksBuiltinFunctions.NUMERIC_ADD;
                break;
            }
            case MINUS: {
                fid = BuiltinFunctions.NUMERIC_SUBTRACT;
                break;
            }
            case MUL: {
                fid = BuiltinFunctions.NUMERIC_MULTIPLY;
                break;
            }
            case DIV: {
                fid = BuiltinFunctions.NUMERIC_DIVIDE;
                break;
            }
            case MOD: {
                fid = BuiltinFunctions.NUMERIC_MOD;
                break;
            }
            case IDIV: {
                fid = BuiltinFunctions.NUMERIC_IDIV;
                break;
            }
            case CARET: {
                fid = BuiltinFunctions.CARET;
                break;
            }
            case AND: {
                fid = AlgebricksBuiltinFunctions.AND;
                break;
            }
            case OR: {
                fid = AlgebricksBuiltinFunctions.OR;
                break;
            }
            case FUZZY_EQ: {
                fid = BuiltinFunctions.FUZZY_EQ;
                break;
            }
            default: {
                throw new NotImplementedException("Operator " + t + " is not yet implemented");
            }
        }
        return new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)fid));
    }

    private static boolean hasOnlyChild(ILogicalOperator parent, Mutable<ILogicalOperator> childCandidate) {
        List inp = parent.getInputs();
        if (inp == null || inp.size() != 1) {
            return false;
        }
        return inp.get(0) == childCandidate;
    }

    protected Pair<ILogicalExpression, Mutable<ILogicalOperator>> langExprToAlgExpression(Expression expr, Mutable<ILogicalOperator> topOpRef) throws CompilationException {
        switch (expr.getKind()) {
            case VARIABLE_EXPRESSION: {
                VariableReferenceExpression ve = new VariableReferenceExpression(this.context.getVar(((VariableExpr)expr).getVar().getId()));
                return new Pair((Object)ve, topOpRef);
            }
            case LITERAL_EXPRESSION: {
                LiteralExpr val = (LiteralExpr)expr;
                return new Pair((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(ConstantHelper.objectFromLiteral(val.getValue()))), topOpRef);
            }
        }
        if (this.expressionNeedsNoNesting(expr)) {
            Pair p = (Pair)expr.accept((ILangVisitor)this, topOpRef);
            ILogicalExpression exp = (ILogicalExpression)((Mutable)((AssignOperator)p.first).getExpressions().get(0)).getValue();
            return new Pair((Object)exp, ((ILogicalOperator)p.first).getInputs().get(0));
        }
        MutableObject srcRef = new MutableObject();
        Pair p = (Pair)expr.accept((ILangVisitor)this, (Object)srcRef);
        if (((ILogicalOperator)p.first).getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
            if (topOpRef.getValue() != null) {
                srcRef.setValue(topOpRef.getValue());
            } else {
                this.rebindBottomOpRef((ILogicalOperator)p.first, (Mutable<ILogicalOperator>)srcRef, topOpRef);
            }
            MutableObject top2 = new MutableObject(p.first);
            return new Pair((Object)new VariableReferenceExpression((LogicalVariable)p.second), (Object)top2);
        }
        SubplanOperator s = new SubplanOperator();
        s.getInputs().add(topOpRef);
        srcRef.setValue((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)s)));
        MutableObject planRoot = new MutableObject(p.first);
        s.setRootOp((Mutable)planRoot);
        return new Pair((Object)new VariableReferenceExpression((LogicalVariable)p.second), (Object)new MutableObject((Object)s));
    }

    protected Pair<ILogicalOperator, LogicalVariable> aggListifyForSubquery(LogicalVariable var, Mutable<ILogicalOperator> opRef, boolean bProject) {
        AggregateOperator res;
        AggregateFunctionCallExpression funAgg = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, new ArrayList());
        funAgg.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(var)));
        LogicalVariable varListified = this.context.newSubplanOutputVar();
        AggregateOperator agg = new AggregateOperator(this.mkSingletonArrayList(varListified), this.mkSingletonArrayList(new MutableObject((Object)funAgg)));
        agg.getInputs().add(opRef);
        if (bProject) {
            ProjectOperator pr = new ProjectOperator(varListified);
            pr.getInputs().add(new MutableObject((Object)agg));
            res = pr;
        } else {
            res = agg;
        }
        return new Pair((Object)res, (Object)varListified);
    }

    protected Pair<ILogicalOperator, LogicalVariable> visitAndOrOperator(OperatorExpr op, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        List ops = op.getOpList();
        int nOps = ops.size();
        List exprs = op.getExprList();
        Mutable topOp = tupSource;
        OperatorType opLogical = (OperatorType)ops.get(0);
        AbstractFunctionCallExpression f = this.createFunctionCallExpressionForBuiltinOperator(opLogical);
        for (int i = 0; i <= nOps; ++i) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression((Expression)exprs.get(i), topOp);
            topOp = (Mutable)p.second;
            if (i < nOps && ops.get(i) != opLogical) {
                throw new TranslationException("Unexpected operator " + ops.get(i) + " in an OperatorExpr starting with " + opLogical);
            }
            f.getArguments().add(new MutableObject(p.first));
        }
        LogicalVariable assignedVar = this.context.newVar();
        AssignOperator a = new AssignOperator(assignedVar, (Mutable)new MutableObject((Object)f));
        a.getInputs().add(topOp);
        return new Pair((Object)a, (Object)assignedVar);
    }

    protected boolean expressionNeedsNoNesting(Expression expr) {
        Expression.Kind k = expr.getKind();
        boolean noNesting = k == Expression.Kind.LITERAL_EXPRESSION || k == Expression.Kind.LIST_CONSTRUCTOR_EXPRESSION || k == Expression.Kind.RECORD_CONSTRUCTOR_EXPRESSION || k == Expression.Kind.VARIABLE_EXPRESSION;
        noNesting = noNesting || k == Expression.Kind.CALL_EXPRESSION || k == Expression.Kind.OP_EXPRESSION || k == Expression.Kind.FIELD_ACCESSOR_EXPRESSION;
        noNesting = noNesting || k == Expression.Kind.INDEX_ACCESSOR_EXPRESSION || k == Expression.Kind.UNARY_EXPRESSION || k == Expression.Kind.IF_EXPRESSION;
        return noNesting || k == Expression.Kind.INDEPENDENT_SUBQUERY || k == Expression.Kind.CASE_EXPRESSION;
    }

    protected <T> List<T> mkSingletonArrayList(T item) {
        ArrayList<T> array = new ArrayList<T>(1);
        array.add(item);
        return array;
    }

    protected ILogicalExpression makeUnnestExpression(ILogicalExpression expr) {
        ArrayList<MutableObject> argRefs = new ArrayList<MutableObject>();
        argRefs.add(new MutableObject((Object)expr));
        switch (expr.getExpressionTag()) {
            case CONSTANT: 
            case VARIABLE: {
                return new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), argRefs);
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
                return fce.getKind() == AbstractFunctionCallExpression.FunctionKind.UNNEST ? expr : new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), argRefs);
            }
        }
        return expr;
    }

    private boolean rebindBottomOpRef(ILogicalOperator currentOp, Mutable<ILogicalOperator> opRef, Mutable<ILogicalOperator> replacementOpRef) {
        int index = 0;
        for (Mutable childRef : currentOp.getInputs()) {
            if (childRef == opRef) {
                currentOp.getInputs().set(index, replacementOpRef);
                return true;
            }
            if (this.rebindBottomOpRef((ILogicalOperator)childRef.getValue(), opRef, replacementOpRef)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void eliminateSharedOperatorReferenceForPlan(ILogicalPlan plan) throws CompilationException {
        for (Mutable opRef : plan.getRoots()) {
            HashSet<Mutable<ILogicalOperator>> opRefSet = new HashSet<Mutable<ILogicalOperator>>();
            this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)opRef, opRefSet);
        }
    }

    private LinkedHashMap<LogicalVariable, LogicalVariable> eliminateSharedOperatorReference(Mutable<ILogicalOperator> currentOpRef, Set<Mutable<ILogicalOperator>> opRefSet) throws CompilationException {
        try {
            opRefSet.add(currentOpRef);
            AbstractLogicalOperator currentOperator = (AbstractLogicalOperator)currentOpRef.getValue();
            if (currentOperator.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans opWithNestedPlan = (AbstractOperatorWithNestedPlans)currentOperator;
                for (ILogicalPlan plan : opWithNestedPlan.getNestedPlans()) {
                    for (Mutable rootRef : plan.getRoots()) {
                        HashSet<Mutable<ILogicalOperator>> nestedOpRefSet = new HashSet<Mutable<ILogicalOperator>>();
                        this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)rootRef, nestedOpRefSet);
                    }
                }
            }
            int childIndex = 0;
            LinkedHashMap<LogicalVariable, LogicalVariable> varMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
            for (Mutable childRef : currentOperator.getInputs()) {
                if (opRefSet.contains(childRef)) {
                    LogicalOperatorDeepCopyWithNewVariablesVisitor visitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)this.context, null);
                    ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)childRef.getValue()).accept((ILogicalOperatorVisitor)visitor, null);
                    LinkedHashMap cloneVarMap = visitor.getInputToOutputVariableMapping();
                    VariableUtilities.substituteVariables((ILogicalOperator)currentOperator, (LinkedHashMap)cloneVarMap, null);
                    varMap.putAll(cloneVarMap);
                    childRef = new MutableObject((Object)newChild);
                    currentOperator.getInputs().set(childIndex, childRef);
                }
                LinkedHashMap<LogicalVariable, LogicalVariable> childVarMap = this.eliminateSharedOperatorReference((Mutable<ILogicalOperator>)childRef, opRefSet);
                VariableUtilities.substituteVariables((ILogicalOperator)currentOperator, childVarMap, null);
                for (Map.Entry<LogicalVariable, LogicalVariable> entry : varMap.entrySet()) {
                    LogicalVariable newVar = childVarMap.get(entry.getValue());
                    if (newVar == null) continue;
                    entry.setValue(newVar);
                }
                varMap.putAll(childVarMap);
                ++childIndex;
            }
            HashSet liveVars = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)currentOperator, liveVars);
            varMap.values().retainAll(liveVars);
            return varMap;
        }
        catch (AlgebricksException e) {
            throw new CompilationException((Throwable)e);
        }
    }

    protected Pair<ILogicalOperator, LogicalVariable> constructSubplanOperatorForBranch(ILogicalOperator inputOp, Mutable<ILogicalExpression> selectExpr, Expression branchExpression) throws CompilationException {
        this.context.enterSubplan();
        SubplanOperator subplanOp = new SubplanOperator();
        subplanOp.getInputs().add(new MutableObject((Object)inputOp));
        MutableObject nestedSource = new MutableObject((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp)));
        SelectOperator select = new SelectOperator(selectExpr, false, null);
        OperatorPropertiesUtil.markMovable((ILogicalOperator)select, (boolean)false);
        select.getInputs().add(nestedSource);
        Pair pBranch = (Pair)branchExpression.accept((ILangVisitor)this, (Object)new MutableObject((Object)select));
        LogicalVariable branchVar = this.context.newVar();
        AggregateOperator aggOp = new AggregateOperator(Collections.singletonList(branchVar), Collections.singletonList(new MutableObject((Object)new AggregateFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.LISTIFY), false, Collections.singletonList(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)pBranch.second)))))));
        aggOp.getInputs().add(new MutableObject(pBranch.first));
        ALogicalPlanImpl planForBranch = new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
        subplanOp.getNestedPlans().add(planForBranch);
        this.context.exitSubplan();
        return new Pair((Object)subplanOp, (Object)branchVar);
    }

    private AssignOperator processExists(ILogicalExpression inputExpr, LogicalVariable v1, boolean not) {
        ScalarFunctionCallExpression count = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCALAR_COUNT));
        count.getArguments().add(new MutableObject((Object)inputExpr));
        ScalarFunctionCallExpression comparison = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)(not ? BuiltinFunctions.EQ : BuiltinFunctions.NEQ)));
        comparison.getArguments().add(new MutableObject((Object)count));
        comparison.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64(0L)))));
        return new AssignOperator(v1, (Mutable)new MutableObject((Object)comparison));
    }

    protected Mutable<ILogicalExpression> generateNoMatchedPrecedingWhenBranchesFilter(List<ILogicalExpression> inputBooleanExprs) {
        ArrayList<Mutable<ILogicalExpression>> arguments = new ArrayList<Mutable<ILogicalExpression>>();
        for (ILogicalExpression inputBooleanExpr : inputBooleanExprs) {
            arguments.add(this.generateAndNotIsUnknownWrap(inputBooleanExpr));
        }
        MutableObject hasBeenExecutedExprRef = new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OR), arguments));
        return new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new ArrayList<MutableObject>(Collections.singletonList(hasBeenExecutedExprRef))));
    }

    protected Mutable<ILogicalExpression> generateAndNotIsUnknownWrap(ILogicalExpression logicalExpr) {
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)logicalExpr));
        MutableObject expr = new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_UNKOWN), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)logicalExpr)))));
        arguments.add(new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new ArrayList<MutableObject>(Collections.singletonList(expr)))));
        return new MutableObject((Object)new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), arguments));
    }

    protected Pair<ILogicalOperator, LogicalVariable> translateUnionAllFromInputExprs(List<ILangExpression> inputExprs, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ArrayList<MutableObject> inputOpRefsToUnion = new ArrayList<MutableObject>();
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        for (ILangExpression expr : inputExprs) {
            Pair opAndVar = (Pair)expr.accept((ILangVisitor)this, tupSource);
            LogicalVariable unnestVar = this.context.newVar();
            ArrayList<MutableObject> args = new ArrayList<MutableObject>();
            args.add(new MutableObject((Object)new VariableReferenceExpression((LogicalVariable)opAndVar.second)));
            UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), args)));
            unnestOp.getInputs().add(new MutableObject(opAndVar.first));
            inputOpRefsToUnion.add(new MutableObject((Object)unnestOp));
            vars.add(unnestVar);
        }
        UnionAllOperator topUnionAllOp = null;
        LogicalVariable topUnionVar = null;
        Iterator inputOpRefIterator = inputOpRefsToUnion.iterator();
        Mutable leftInputBranch = (Mutable)inputOpRefIterator.next();
        Iterator inputVarIterator = vars.iterator();
        LogicalVariable leftInputVar = (LogicalVariable)inputVarIterator.next();
        while (inputOpRefIterator.hasNext()) {
            topUnionVar = this.context.newVar();
            Triple varTriple = new Triple((Object)leftInputVar, inputVarIterator.next(), (Object)topUnionVar);
            ArrayList<Triple> varTriples = new ArrayList<Triple>();
            varTriples.add(varTriple);
            topUnionAllOp = new UnionAllOperator(varTriples);
            topUnionAllOp.getInputs().add(leftInputBranch);
            topUnionAllOp.getInputs().add(inputOpRefIterator.next());
            leftInputBranch = new MutableObject((Object)topUnionAllOp);
            leftInputVar = topUnionVar;
        }
        return new Pair(topUnionAllOp, (Object)topUnionVar);
    }
}

