/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.formats.nontagged.BinaryTokenizerFactoryProvider;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.InvertedIndexJobGenParams;
import org.apache.asterix.optimizer.rules.am.OptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.ConjunctiveEditDistanceSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.ConjunctiveListEditDistanceSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.ConjunctiveSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.DisjunctiveSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.EditDistanceSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.JaccardSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.ListEditDistanceSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;

public class InvertedIndexAccessMethod
implements IAccessMethod {
    private static List<FunctionIdentifier> funcIdents = new ArrayList<FunctionIdentifier>();
    private static HashSet<FunctionIdentifier> secondLevelFuncIdents;
    public static InvertedIndexAccessMethod INSTANCE;

    @Override
    public List<FunctionIdentifier> getOptimizableFunctions() {
        return funcIdents;
    }

    @Override
    public boolean analyzeFuncExprArgsAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.STRING_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
            boolean matches = AccessMethodUtils.analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(funcExpr, analysisCtx, context, typeEnvironment);
            if (!matches) {
                matches = AccessMethodUtils.analyzeFuncExprArgsForTwoVarsAndUpdateAnalysisCtx(funcExpr, analysisCtx);
            }
            return matches;
        }
        return this.analyzeGetItemFuncExpr(funcExpr, assignsAndUnnests, analysisCtx);
    }

    public boolean analyzeGetItemFuncExpr(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() != BuiltinFunctions.GET_ITEM) {
            return false;
        }
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg2.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        if (arg1.getExpressionTag() != LogicalExpressionTag.VARIABLE && arg1.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression matchedFuncExpr = null;
        if (arg1.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            matchedFuncExpr = (AbstractFunctionCallExpression)arg1;
        }
        int matchedAssignOrUnnestIndex = -1;
        if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            VariableReferenceExpression varRefExpr = (VariableReferenceExpression)arg1;
            for (int i = 0; i < assignsAndUnnests.size(); ++i) {
                AbstractLogicalOperator op = assignsAndUnnests.get(i);
                if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    AssignOperator assign = (AssignOperator)op;
                    List assignVars = assign.getVariables();
                    List assignExprs = assign.getExpressions();
                    for (int j = 0; j < assignVars.size(); ++j) {
                        LogicalVariable var = (LogicalVariable)assignVars.get(j);
                        if (var != varRefExpr.getVariableReference()) continue;
                        ILogicalExpression matchedExpr = (ILogicalExpression)((Mutable)assignExprs.get(j)).getValue();
                        if (matchedExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                            return false;
                        }
                        matchedFuncExpr = (AbstractFunctionCallExpression)matchedExpr;
                        break;
                    }
                } else {
                    UnnestOperator unnest = (UnnestOperator)op;
                    LogicalVariable var = unnest.getVariable();
                    if (var == varRefExpr.getVariableReference()) {
                        ILogicalExpression matchedExpr = (ILogicalExpression)unnest.getExpressionRef().getValue();
                        if (matchedExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                            return false;
                        }
                        AbstractFunctionCallExpression unnestFuncExpr = (AbstractFunctionCallExpression)matchedExpr;
                        if (unnestFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
                            return false;
                        }
                        matchedFuncExpr = (AbstractFunctionCallExpression)((Mutable)unnestFuncExpr.getArguments().get(0)).getValue();
                    }
                }
                if (matchedFuncExpr == null) continue;
                matchedAssignOrUnnestIndex = i;
                break;
            }
        }
        if (!secondLevelFuncIdents.contains(matchedFuncExpr.getFunctionIdentifier())) {
            return false;
        }
        boolean selectMatchFound = this.analyzeSelectSimilarityCheckFuncExprArgs(matchedFuncExpr, assignsAndUnnests, matchedAssignOrUnnestIndex, analysisCtx);
        boolean joinMatchFound = this.analyzeJoinSimilarityCheckFuncExprArgs(matchedFuncExpr, assignsAndUnnests, matchedAssignOrUnnestIndex, analysisCtx);
        return selectMatchFound || joinMatchFound;
    }

    private boolean analyzeJoinSimilarityCheckFuncExprArgs(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, int matchedAssignOrUnnestIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        ILogicalExpression arg3 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(2)).getValue();
        if (arg3.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() == LogicalExpressionTag.CONSTANT || arg2.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return false;
        }
        LogicalVariable fieldVarExpr1 = this.getNonConstArgFieldExprPair(arg1, funcExpr, assignsAndUnnests, matchedAssignOrUnnestIndex);
        if (fieldVarExpr1 == null) {
            return false;
        }
        LogicalVariable fieldVarExpr2 = this.getNonConstArgFieldExprPair(arg2, funcExpr, assignsAndUnnests, matchedAssignOrUnnestIndex);
        if (fieldVarExpr2 == null) {
            return false;
        }
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, new LogicalVariable[]{fieldVarExpr1, fieldVarExpr2}, new ILogicalExpression[]{arg3}, new IAType[]{(IAType)ExpressionTypeComputer.INSTANCE.getType(arg3, null, null)});
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            if (!optFuncExpr.getFuncExpr().equals((Object)funcExpr)) continue;
            return true;
        }
        analysisCtx.addMatchedFuncExpr(newOptFuncExpr);
        return true;
    }

    private boolean analyzeSelectSimilarityCheckFuncExprArgs(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, int matchedAssignOrUnnestIndex, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        ILogicalExpression nonConstArg;
        ILogicalExpression constArg;
        ILogicalExpression arg3 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(2)).getValue();
        if (arg3.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() == LogicalExpressionTag.CONSTANT && arg2.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS) {
                return false;
            }
            constArg = arg1;
            nonConstArg = arg2;
        } else if (arg2.getExpressionTag() == LogicalExpressionTag.CONSTANT && arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            constArg = arg2;
            nonConstArg = arg1;
        } else {
            return false;
        }
        LogicalVariable fieldVarExpr = this.getNonConstArgFieldExprPair(nonConstArg, funcExpr, assignsAndUnnests, matchedAssignOrUnnestIndex);
        if (fieldVarExpr == null) {
            return false;
        }
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, new LogicalVariable[]{fieldVarExpr}, new ILogicalExpression[]{constArg, arg3}, new IAType[]{(IAType)ExpressionTypeComputer.INSTANCE.getType(constArg, null, null), (IAType)ExpressionTypeComputer.INSTANCE.getType(arg3, null, null)});
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            if (!optFuncExpr.getFuncExpr().equals((Object)funcExpr)) continue;
            return true;
        }
        analysisCtx.addMatchedFuncExpr(newOptFuncExpr);
        return true;
    }

    private LogicalVariable getNonConstArgFieldExprPair(ILogicalExpression nonConstArg, AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, int matchedAssignOrUnnestIndex) {
        AbstractFunctionCallExpression nonConstFuncExpr;
        LogicalVariable fieldVar = null;
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.SIMILARITY_JACCARD_CHECK) {
            nonConstFuncExpr = funcExpr;
            if (nonConstArg.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                nonConstFuncExpr = (AbstractFunctionCallExpression)nonConstArg;
                if (nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.WORD_TOKENS && nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.GRAM_TOKENS) {
                    return null;
                }
                nonConstArg = (ILogicalExpression)((Mutable)nonConstFuncExpr.getArguments().get(0)).getValue();
            }
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK || funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS) {
            while (nonConstArg.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                nonConstFuncExpr = (AbstractFunctionCallExpression)nonConstArg;
                if (nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.WORD_TOKENS && nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SUBSTRING && nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SUBSTRING_BEFORE && nonConstFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SUBSTRING_AFTER) {
                    return null;
                }
                nonConstArg = (ILogicalExpression)((Mutable)nonConstFuncExpr.getArguments().get(0)).getValue();
            }
        }
        if (nonConstArg.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            fieldVar = ((VariableReferenceExpression)nonConstArg).getVariableReference();
        }
        return fieldVar;
    }

    @Override
    public boolean matchAllIndexExprs() {
        return true;
    }

    @Override
    public boolean matchPrefixIndexExprs() {
        return false;
    }

    @Override
    public ILogicalOperator createSecondaryToPrimaryPlan(Mutable<ILogicalExpression> conditionRef, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, boolean retainInput, boolean retainNull, boolean requiresBroadcast, IOptimizationContext context) throws AlgebricksException {
        IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(chosenIndex, analysisCtx);
        Dataset dataset = indexSubTree.getDataset();
        ARecordType recordType = indexSubTree.getRecordType();
        ARecordType metaRecordType = indexSubTree.getMetaRecordType();
        DataSourceScanOperator dataSourceScan = (DataSourceScanOperator)indexSubTree.getDataSourceRef().getValue();
        InvertedIndexJobGenParams jobGenParams = new InvertedIndexJobGenParams(chosenIndex.getIndexName(), chosenIndex.getIndexType(), dataset.getDataverseName(), dataset.getDatasetName(), retainInput, requiresBroadcast);
        this.addFunctionSpecificArgs(optFuncExpr, jobGenParams);
        this.addSearchKeyType(optFuncExpr, indexSubTree, context, jobGenParams);
        AbstractLogicalOperator inputOp = null;
        ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
        if (probeSubTree == null) {
            ArrayList<Mutable<ILogicalExpression>> keyExprList = new ArrayList<Mutable<ILogicalExpression>>();
            this.addKeyVarsAndExprs(optFuncExpr, keyVarList, keyExprList, context);
            inputOp = new AssignOperator(keyVarList, keyExprList);
            inputOp.getInputs().add(new MutableObject((Object)OperatorManipulationUtil.deepCopy((ILogicalOperator)((ILogicalOperator)((Mutable)dataSourceScan.getInputs().get(0)).getValue()))));
            inputOp.setExecutionMode(dataSourceScan.getExecutionMode());
        } else {
            LogicalVariable inputSearchVariable = this.getInputSearchVar(optFuncExpr, indexSubTree);
            keyVarList.add(inputSearchVariable);
            inputOp = (AbstractLogicalOperator)probeSubTree.getRoot();
        }
        jobGenParams.setKeyVarList(keyVarList);
        ILogicalOperator secondaryIndexUnnestOp = AccessMethodUtils.createSecondaryIndexUnnestMap(dataset, recordType, metaRecordType, chosenIndex, (ILogicalOperator)inputOp, jobGenParams, context, true, retainInput, retainNull);
        AbstractUnnestMapOperator primaryIndexUnnestOp = AccessMethodUtils.createPrimaryIndexUnnestMap((AbstractDataSourceOperator)dataSourceScan, dataset, recordType, metaRecordType, secondaryIndexUnnestOp, context, true, retainInput, retainNull, false);
        return primaryIndexUnnestOp;
    }

    private LogicalVariable getInputSearchVar(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree indexSubTree) {
        if (optFuncExpr.getOperatorSubTree(0) == indexSubTree) {
            return optFuncExpr.getLogicalVar(1);
        }
        return optFuncExpr.getLogicalVar(0);
    }

    @Override
    public boolean applySelectPlanTransformation(List<Mutable<ILogicalOperator>> afterSelectRefs, Mutable<ILogicalOperator> selectRef, OptimizableOperatorSubTree subTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator indexPlanRootOp = this.createSecondaryToPrimaryPlan(null, subTree, null, chosenIndex, analysisCtx, AccessMethodUtils.retainInputs(subTree.getDataSourceVariables(), (ILogicalOperator)subTree.getDataSourceRef().getValue(), afterSelectRefs), false, ((ILogicalOperator)((Mutable)((ILogicalOperator)subTree.getDataSourceRef().getValue()).getInputs().get(0)).getValue()).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED, context);
        subTree.getDataSourceRef().setValue((Object)indexPlanRootOp);
        return true;
    }

    @Override
    public boolean applyJoinPlanTransformation(Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree leftSubTree, OptimizableOperatorSubTree rightSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean isLeftOuterJoin, boolean hasGroupBy) throws AlgebricksException {
        Dataset dataset = analysisCtx.getDatasetFromIndexDatasetMap(chosenIndex);
        if (!rightSubTree.hasDataSourceScan() || !dataset.getDatasetName().equals(rightSubTree.getDataset().getDatasetName())) {
            return false;
        }
        OptimizableOperatorSubTree indexSubTree = rightSubTree;
        OptimizableOperatorSubTree probeSubTree = leftSubTree;
        IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(chosenIndex, analysisCtx);
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS && optFuncExpr.getOperatorSubTree(0).getDataset() != null && !optFuncExpr.getOperatorSubTree(0).getDataset().getDatasetName().equals(indexSubTree.getDataset().getDatasetName())) {
            return false;
        }
        LogicalVariable newNullPlaceHolderVar = null;
        if (isLeftOuterJoin && hasGroupBy) {
            newNullPlaceHolderVar = indexSubTree.getDataSourceVariables().get(0);
            AccessMethodUtils.resetLOJNullPlaceholderVariableInGroupByOp(analysisCtx, newNullPlaceHolderVar, context);
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)joinRef.getValue();
        ArrayList<LogicalVariable> originalSubTreePKs = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> surrogateSubTreePKs = new ArrayList<LogicalVariable>();
        Mutable<ILogicalOperator> originalProbeSubTreeRootRef = this.copyAndReinitProbeSubTree(probeSubTree, (ILogicalExpression)join.getCondition().getValue(), optFuncExpr, originalSubTreePKs, surrogateSubTreePKs, context);
        ArrayList<LogicalVariable> indexSubTreeLiveVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)indexSubTree.getRoot(), indexSubTreeLiveVars);
        ILogicalExpression joinCond = ((ILogicalExpression)join.getCondition().getValue()).cloneExpression();
        MutableObject panicJoinRef = null;
        HashMap<LogicalVariable, LogicalVariable> panicVarMap = null;
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS) {
            panicJoinRef = new MutableObject(joinRef.getValue());
            panicVarMap = new HashMap<LogicalVariable, LogicalVariable>();
            Mutable<ILogicalOperator> newProbeRootRef = this.createPanicNestedLoopJoinPlan((Mutable<ILogicalOperator>)panicJoinRef, indexSubTree, probeSubTree, optFuncExpr, chosenIndex, panicVarMap, context);
            probeSubTree.getRootRef().setValue(newProbeRootRef.getValue());
            probeSubTree.setRoot((ILogicalOperator)newProbeRootRef.getValue());
        }
        ILogicalOperator indexPlanRootOp = this.createSecondaryToPrimaryPlan(null, indexSubTree, probeSubTree, chosenIndex, analysisCtx, true, isLeftOuterJoin, true, context);
        indexSubTree.getDataSourceRef().setValue((Object)indexPlanRootOp);
        SelectOperator topSelect = new SelectOperator((Mutable)new MutableObject((Object)joinCond), isLeftOuterJoin, newNullPlaceHolderVar);
        topSelect.getInputs().add(indexSubTree.getRootRef());
        topSelect.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topSelect);
        SelectOperator topOp = topSelect;
        if (panicJoinRef != null) {
            LogicalVariable inputSearchVar = this.getInputSearchVar(optFuncExpr, indexSubTree);
            indexSubTreeLiveVars.addAll(originalSubTreePKs);
            indexSubTreeLiveVars.add(inputSearchVar);
            ArrayList panicPlanLiveVars = new ArrayList();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)panicJoinRef.getValue()), panicPlanLiveVars);
            ArrayList<Triple> varMap = new ArrayList<Triple>();
            for (int i = 0; i < indexSubTreeLiveVars.size(); ++i) {
                LogicalVariable indexSubTreeVar = (LogicalVariable)indexSubTreeLiveVars.get(i);
                LogicalVariable panicPlanVar = (LogicalVariable)panicVarMap.get(indexSubTreeVar);
                if (panicPlanVar == null) {
                    panicPlanVar = indexSubTreeVar;
                }
                varMap.add(new Triple((Object)indexSubTreeVar, (Object)panicPlanVar, (Object)indexSubTreeVar));
            }
            UnionAllOperator unionAllOp = new UnionAllOperator(varMap);
            unionAllOp.getInputs().add(new MutableObject((Object)topOp));
            unionAllOp.getInputs().add(panicJoinRef);
            unionAllOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionAllOp);
            topOp = unionAllOp;
        }
        Mutable<ILogicalExpression> eqJoinConditionRef = this.createPrimaryKeysEqJoinCondition(originalSubTreePKs, surrogateSubTreePKs);
        InnerJoinOperator topEqJoin = new InnerJoinOperator(eqJoinConditionRef, originalProbeSubTreeRootRef, (Mutable)new MutableObject((Object)topOp));
        topEqJoin.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        joinRef.setValue((Object)topEqJoin);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topEqJoin);
        return true;
    }

    private Mutable<ILogicalOperator> copyAndReinitProbeSubTree(OptimizableOperatorSubTree probeSubTree, ILogicalExpression joinCond, IOptimizableFuncExpr optFuncExpr, List<LogicalVariable> originalSubTreePKs, List<LogicalVariable> surrogateSubTreePKs, IOptimizationContext context) throws AlgebricksException {
        int i;
        probeSubTree.getPrimaryKeyVars(null, originalSubTreePKs);
        LinkedHashMap<LogicalVariable, LogicalVariable> newProbeSubTreeVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        LinkedHashMap<LogicalVariable, LogicalVariable> joinInputSubTreeVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)probeSubTree.getRoot(), liveVars);
        for (LogicalVariable var : liveVars) {
            joinInputSubTreeVarMap.put(var, var);
        }
        for (i = 0; i < optFuncExpr.getNumLogicalVars(); ++i) {
            joinInputSubTreeVarMap.put(optFuncExpr.getLogicalVar(i), context.newVar());
            newProbeSubTreeVarMap.put(optFuncExpr.getLogicalVar(i), optFuncExpr.getLogicalVar(i));
        }
        for (i = 0; i < originalSubTreePKs.size(); ++i) {
            LogicalVariable newPKVar = context.newVar();
            surrogateSubTreePKs.add(newPKVar);
            joinInputSubTreeVarMap.put(originalSubTreePKs.get(i), newPKVar);
            newProbeSubTreeVarMap.put(originalSubTreePKs.get(i), originalSubTreePKs.get(i));
        }
        LogicalOperatorDeepCopyWithNewVariablesVisitor firstDeepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, (ITypingContext)context, newProbeSubTreeVarMap);
        ILogicalOperator newProbeSubTree = firstDeepCopyVisitor.deepCopy(probeSubTree.getRoot());
        this.inferTypes(newProbeSubTree, context);
        MutableObject newProbeSubTreeRootRef = new MutableObject((Object)newProbeSubTree);
        LogicalOperatorDeepCopyWithNewVariablesVisitor secondDeepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, (ITypingContext)context, joinInputSubTreeVarMap);
        ILogicalOperator joinInputSubTree = secondDeepCopyVisitor.deepCopy(probeSubTree.getRoot());
        this.inferTypes(joinInputSubTree, context);
        probeSubTree.getRootRef().setValue((Object)joinInputSubTree);
        Mutable<ILogicalOperator> originalProbeSubTreeRootRef = probeSubTree.getRootRef();
        Dataset origDataset = probeSubTree.getDataset();
        ARecordType origRecordType = probeSubTree.getRecordType();
        probeSubTree.initFromSubTree((Mutable<ILogicalOperator>)newProbeSubTreeRootRef);
        probeSubTree.setDataset(origDataset);
        probeSubTree.setRecordType(origRecordType);
        LinkedHashMap varMapping = firstDeepCopyVisitor.getInputToOutputVariableMapping();
        for (Map.Entry varMapEntry : varMapping.entrySet()) {
            if (varMapEntry.getKey() == varMapEntry.getValue()) continue;
            joinCond.substituteVar((LogicalVariable)varMapEntry.getKey(), (LogicalVariable)varMapEntry.getValue());
        }
        return originalProbeSubTreeRootRef;
    }

    private Mutable<ILogicalExpression> createPrimaryKeysEqJoinCondition(List<LogicalVariable> originalSubTreePKs, List<LogicalVariable> surrogateSubTreePKs) {
        ArrayList<MutableObject> eqExprs = new ArrayList<MutableObject>();
        int numPKVars = originalSubTreePKs.size();
        for (int i = 0; i < numPKVars; ++i) {
            ArrayList<MutableObject> args = new ArrayList<MutableObject>();
            args.add(new MutableObject((Object)new VariableReferenceExpression(surrogateSubTreePKs.get(i))));
            args.add(new MutableObject((Object)new VariableReferenceExpression(originalSubTreePKs.get(i))));
            ScalarFunctionCallExpression eqFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.EQ), args);
            eqExprs.add(new MutableObject((Object)eqFunc));
        }
        if (eqExprs.size() == 1) {
            return (Mutable)eqExprs.get(0);
        }
        ScalarFunctionCallExpression andFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND), eqExprs);
        return new MutableObject((Object)andFunc);
    }

    private Mutable<ILogicalOperator> createPanicNestedLoopJoinPlan(Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, IOptimizableFuncExpr optFuncExpr, Index chosenIndex, Map<LogicalVariable, LogicalVariable> panicVarMap, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable inputSearchVar = this.getInputSearchVar(optFuncExpr, indexSubTree);
        ReplicateOperator replicateOp = new ReplicateOperator(2);
        replicateOp.getInputs().add(new MutableObject((Object)probeSubTree.getRoot()));
        replicateOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
        IVariableTypeEnvironment probeTypeEnv = context.getOutputTypeEnvironment(probeSubTree.getRoot());
        IAType inputSearchVarType = chosenIndex.isEnforced() ? optFuncExpr.getFieldType(optFuncExpr.findLogicalVar(inputSearchVar)) : (IAType)probeTypeEnv.getVarType(inputSearchVar);
        MutableObject isFilterableSelectOpRef = new MutableObject();
        MutableObject isNotFilterableSelectOpRef = new MutableObject();
        this.createIsFilterableSelectOps((ILogicalOperator)replicateOp, inputSearchVar, inputSearchVarType, optFuncExpr, chosenIndex, context, (Mutable<ILogicalOperator>)isFilterableSelectOpRef, (Mutable<ILogicalOperator>)isNotFilterableSelectOpRef);
        ArrayList originalLiveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)indexSubTree.getRoot(), originalLiveVars);
        LogicalOperatorDeepCopyWithNewVariablesVisitor deepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, (ITypingContext)context);
        ILogicalOperator scanSubTree = deepCopyVisitor.deepCopy(indexSubTree.getRoot());
        LinkedHashMap copyVarMap = deepCopyVisitor.getInputToOutputVariableMapping();
        panicVarMap.putAll(copyVarMap);
        ArrayList copyLiveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)scanSubTree, copyLiveVars);
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)joinRef.getValue();
        for (Map.Entry entry : copyVarMap.entrySet()) {
            ((ILogicalExpression)joinOp.getCondition().getValue()).substituteVar((LogicalVariable)entry.getKey(), (LogicalVariable)entry.getValue());
        }
        joinOp.getInputs().clear();
        joinOp.getInputs().add(new MutableObject((Object)scanSubTree));
        joinOp.getInputs().add(isNotFilterableSelectOpRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
        return isFilterableSelectOpRef;
    }

    private void createIsFilterableSelectOps(ILogicalOperator inputOp, LogicalVariable inputSearchVar, IAType inputSearchVarType, IOptimizableFuncExpr optFuncExpr, Index chosenIndex, IOptimizationContext context, Mutable<ILogicalOperator> isFilterableSelectOpRef, Mutable<ILogicalOperator> isNotFilterableSelectOpRef) throws AlgebricksException {
        ScalarFunctionCallExpression isFilterableExpr = null;
        switch (inputSearchVarType.getTypeTag()) {
            case STRING: {
                ArrayList<MutableObject> isFilterableArgs = new ArrayList<MutableObject>(4);
                isFilterableArgs.add(new MutableObject((Object)new VariableReferenceExpression(inputSearchVar)));
                isFilterableArgs.add(new MutableObject((Object)optFuncExpr.getConstantExpr(0)));
                isFilterableArgs.add(new MutableObject((Object)AccessMethodUtils.createInt32Constant(chosenIndex.getGramLength())));
                boolean usePrePost = !optFuncExpr.containsPartialField();
                isFilterableArgs.add(new MutableObject((Object)AccessMethodUtils.createBooleanConstant(usePrePost)));
                isFilterableExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.EDIT_DISTANCE_STRING_IS_FILTERABLE), isFilterableArgs);
                break;
            }
            case MULTISET: 
            case ARRAY: {
                ArrayList<MutableObject> isFilterableArgs = new ArrayList(2);
                isFilterableArgs.add(new MutableObject((Object)new VariableReferenceExpression(inputSearchVar)));
                isFilterableArgs.add(new MutableObject((Object)optFuncExpr.getConstantExpr(0)));
                isFilterableExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE), isFilterableArgs);
                break;
            }
            default: {
                throw CompilationException.create((int)1033, (Serializable[])new Serializable[0]);
            }
        }
        SelectOperator isFilterableSelectOp = new SelectOperator((Mutable)new MutableObject((Object)isFilterableExpr), false, null);
        isFilterableSelectOp.getInputs().add(new MutableObject((Object)inputOp));
        isFilterableSelectOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)isFilterableSelectOp);
        ArrayList<MutableObject> isNotFilterableArgs = new ArrayList<MutableObject>();
        isNotFilterableArgs.add(new MutableObject((Object)isFilterableExpr));
        ScalarFunctionCallExpression isNotFilterableExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), isNotFilterableArgs);
        SelectOperator isNotFilterableSelectOp = new SelectOperator((Mutable)new MutableObject((Object)isNotFilterableExpr), false, null);
        isNotFilterableSelectOp.getInputs().add(new MutableObject((Object)inputOp));
        isNotFilterableSelectOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)isNotFilterableSelectOp);
        isFilterableSelectOpRef.setValue((Object)isFilterableSelectOp);
        isNotFilterableSelectOpRef.setValue((Object)isNotFilterableSelectOp);
    }

    private void addSearchKeyType(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree indexSubTree, IOptimizationContext context, InvertedIndexJobGenParams jobGenParams) throws AlgebricksException {
        IAType type = null;
        ATypeTag typeTag = null;
        if (optFuncExpr.getNumLogicalVars() == 2) {
            type = optFuncExpr.getOperatorSubTree(0) == indexSubTree ? optFuncExpr.getFieldType(1) : optFuncExpr.getFieldType(0);
            typeTag = type.getTypeTag();
            if (type.getTypeTag() == ATypeTag.UNION) {
                typeTag = ((AUnionType)type).getActualType().getTypeTag();
            }
        } else {
            type = optFuncExpr.getConstantType(0);
            typeTag = type.getTypeTag();
            if (typeTag == ATypeTag.UNION) {
                typeTag = ((AUnionType)type).getActualType().getTypeTag();
            }
            if (typeTag != ATypeTag.ARRAY && typeTag != ATypeTag.STRING && typeTag != ATypeTag.MULTISET) {
                throw CompilationException.create((int)1033, (Serializable[])new Serializable[0]);
            }
        }
        jobGenParams.setSearchKeyType(typeTag);
    }

    private void addFunctionSpecificArgs(IOptimizableFuncExpr optFuncExpr, InvertedIndexJobGenParams jobGenParams) {
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.STRING_CONTAINS) {
            jobGenParams.setSearchModifierType(SearchModifierType.CONJUNCTIVE);
            jobGenParams.setSimilarityThreshold((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)AMissing.MISSING));
            return;
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.SIMILARITY_JACCARD_CHECK) {
            jobGenParams.setSearchModifierType(SearchModifierType.JACCARD);
            jobGenParams.setSimilarityThreshold(((ConstantExpression)optFuncExpr.getConstantExpr(optFuncExpr.getNumConstantExpr() - 1)).getValue());
            return;
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS) {
            if (optFuncExpr.containsPartialField()) {
                jobGenParams.setSearchModifierType(SearchModifierType.CONJUNCTIVE_EDIT_DISTANCE);
            } else {
                jobGenParams.setSearchModifierType(SearchModifierType.EDIT_DISTANCE);
            }
            jobGenParams.setSimilarityThreshold(((ConstantExpression)optFuncExpr.getConstantExpr(optFuncExpr.getNumConstantExpr() - 1)).getValue());
            return;
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
            jobGenParams.setIsFullTextSearch(true);
            AbstractFunctionCallExpression funcExpr = optFuncExpr.getFuncExpr();
            jobGenParams.setSearchModifierType(InvertedIndexAccessMethod.getFullTextOption(funcExpr));
            jobGenParams.setSimilarityThreshold((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ANull.NULL));
        }
    }

    private static SearchModifierType getFullTextOption(AbstractFunctionCallExpression funcExpr) {
        if (funcExpr.getArguments().size() < 3 || funcExpr.getArguments().size() % 2 != 0) {
            return SearchModifierType.DISJUNCTIVE;
        }
        for (int i = 2; i < funcExpr.getArguments().size(); i += 2) {
            String optionName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)i);
            if (!optionName.equals("mode")) continue;
            String searchType = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)(i + 1));
            if (searchType.equals("all")) {
                return SearchModifierType.CONJUNCTIVE;
            }
            return SearchModifierType.DISJUNCTIVE;
        }
        return null;
    }

    private void addKeyVarsAndExprs(IOptimizableFuncExpr optFuncExpr, ArrayList<LogicalVariable> keyVarList, ArrayList<Mutable<ILogicalExpression>> keyExprList, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable keyVar = context.newVar();
        keyVarList.add(keyVar);
        keyExprList.add((Mutable<ILogicalExpression>)new MutableObject((Object)optFuncExpr.getConstantExpr(0)));
    }

    @Override
    public boolean exprIsOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) throws AlgebricksException {
        if (optFuncExpr.getFuncExpr().getAnnotations().containsKey(SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE)) {
            return false;
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CONTAINS) {
            return this.isEditDistanceFuncOptimizable(index, optFuncExpr);
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.SIMILARITY_JACCARD_CHECK) {
            return this.isJaccardFuncOptimizable(index, optFuncExpr);
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.STRING_CONTAINS) {
            return this.isContainsFuncOptimizable(index, optFuncExpr);
        }
        if (optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
            return this.isFullTextContainsFuncOptimizable(index, optFuncExpr);
        }
        return false;
    }

    private boolean isEditDistanceFuncOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) throws AlgebricksException {
        if (optFuncExpr.getNumConstantExpr() == 1) {
            return this.isEditDistanceFuncJoinOptimizable(index, optFuncExpr);
        }
        return this.isEditDistanceFuncSelectOptimizable(index, optFuncExpr);
    }

    private boolean isEditDistanceFuncJoinOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        if (index.isEnforced()) {
            return this.isEditDistanceFuncCompatible(((IAType)index.getKeyFieldTypes().get(0)).getTypeTag(), index.getIndexType());
        }
        return this.isEditDistanceFuncCompatible(optFuncExpr.getFieldType(0).getTypeTag(), index.getIndexType());
    }

    private boolean isEditDistanceFuncCompatible(ATypeTag typeTag, DatasetConfig.IndexType indexType) {
        if (typeTag == ATypeTag.STRING && (indexType == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX)) {
            return true;
        }
        return typeTag == ATypeTag.ARRAY && (indexType == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX);
    }

    private boolean isEditDistanceFuncSelectOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) throws AlgebricksException {
        AsterixConstantValue listOrStrConstVal = (AsterixConstantValue)((ConstantExpression)optFuncExpr.getConstantExpr(0)).getValue();
        IAObject listOrStrObj = listOrStrConstVal.getObject();
        ATypeTag typeTag = listOrStrObj.getType().getTypeTag();
        if (!this.isEditDistanceFuncCompatible(typeTag, index.getIndexType())) {
            return false;
        }
        AsterixConstantValue intConstVal = (AsterixConstantValue)((ConstantExpression)optFuncExpr.getConstantExpr(1)).getValue();
        IAObject intObj = intConstVal.getObject();
        AInt32 edThresh = null;
        try {
            edThresh = (AInt32)ATypeHierarchy.convertNumericTypeObject((IAObject)intObj, (ATypeTag)ATypeTag.INTEGER);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        int mergeThreshold = 0;
        if (typeTag == ATypeTag.STRING) {
            AString astr = (AString)listOrStrObj;
            mergeThreshold = optFuncExpr.containsPartialField() ? astr.getStringValue().length() - index.getGramLength() + 1 - edThresh.getIntegerValue() * index.getGramLength() : astr.getStringValue().length() + index.getGramLength() - 1 - edThresh.getIntegerValue() * index.getGramLength();
        }
        if (typeTag == ATypeTag.ARRAY && (index.getIndexType() == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX)) {
            IACollection alist = (IACollection)listOrStrObj;
            mergeThreshold = alist.size() - edThresh.getIntegerValue();
        }
        return mergeThreshold > 0;
    }

    private boolean isJaccardFuncOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        int i;
        int variableCount = optFuncExpr.getNumLogicalVars();
        ScalarFunctionCallExpression funcExpr = null;
        for (i = 0; i < variableCount; ++i) {
            funcExpr = this.findTokensFunc(BuiltinFunctions.GRAM_TOKENS, optFuncExpr, i);
            if (funcExpr == null) continue;
            return this.isJaccardFuncCompatible((ILogicalExpression)funcExpr, optFuncExpr.getFieldType(i).getTypeTag(), index.getIndexType());
        }
        for (i = 0; i < variableCount; ++i) {
            funcExpr = this.findTokensFunc(BuiltinFunctions.WORD_TOKENS, optFuncExpr, i);
            if (funcExpr == null) continue;
            return this.isJaccardFuncCompatible((ILogicalExpression)funcExpr, optFuncExpr.getFieldType(i).getTypeTag(), index.getIndexType());
        }
        OptimizableOperatorSubTree subTree = null;
        LogicalVariable targetVar = null;
        for (int i2 = 0; i2 < variableCount; ++i2) {
            subTree = optFuncExpr.getOperatorSubTree(i2);
            if (subTree == null || (targetVar = optFuncExpr.getLogicalVar(i2)) == null) continue;
            return this.isJaccardFuncCompatible((ILogicalExpression)((Mutable)optFuncExpr.getFuncExpr().getArguments().get(i2)).getValue(), optFuncExpr.getFieldType(i2).getTypeTag(), index.getIndexType());
        }
        return false;
    }

    private boolean isFullTextContainsFuncCompatible(ATypeTag typeTag, DatasetConfig.IndexType indexType) {
        return (typeTag == ATypeTag.STRING || typeTag == ATypeTag.ARRAY || typeTag == ATypeTag.MULTISET) && indexType == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
    }

    private boolean isFullTextContainsFuncOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        if (optFuncExpr.getNumLogicalVars() == 2) {
            return this.isFullTextContainsFuncJoinOptimizable(index, optFuncExpr);
        }
        return this.isFullTextContainsFuncSelectOptimizable(index, optFuncExpr);
    }

    private boolean isFullTextContainsFuncSelectOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        AsterixConstantValue strConstVal = (AsterixConstantValue)((ConstantExpression)optFuncExpr.getConstantExpr(0)).getValue();
        IAObject strObj = strConstVal.getObject();
        ATypeTag typeTag = strObj.getType().getTypeTag();
        return this.isFullTextContainsFuncCompatible(typeTag, index.getIndexType());
    }

    private boolean isFullTextContainsFuncJoinOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        if (index.isEnforced()) {
            return this.isFullTextContainsFuncCompatible(((IAType)index.getKeyFieldTypes().get(0)).getTypeTag(), index.getIndexType());
        }
        return this.isFullTextContainsFuncCompatible(optFuncExpr.getFieldType(0).getTypeTag(), index.getIndexType());
    }

    private ScalarFunctionCallExpression findTokensFunc(FunctionIdentifier funcId, IOptimizableFuncExpr optFuncExpr, int subTreeIndex) {
        OptimizableOperatorSubTree subTree = null;
        LogicalVariable targetVar = null;
        subTree = optFuncExpr.getOperatorSubTree(subTreeIndex);
        if (subTree == null) {
            return null;
        }
        targetVar = optFuncExpr.getLogicalVar(subTreeIndex);
        if (targetVar == null) {
            return null;
        }
        for (AbstractLogicalOperator op : subTree.getAssignsAndUnnests()) {
            if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) continue;
            List exprList = ((AssignOperator)op).getExpressions();
            for (Mutable expr : exprList) {
                ILogicalExpression varExpr;
                AbstractFunctionCallExpression funcExpr;
                if (((ILogicalExpression)expr.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (funcExpr = (AbstractFunctionCallExpression)expr.getValue()).getFunctionIdentifier() != funcId || (varExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE || ((VariableReferenceExpression)varExpr).getVariableReference() == targetVar) continue;
                return (ScalarFunctionCallExpression)funcExpr;
            }
        }
        return null;
    }

    private boolean isJaccardFuncCompatible(ILogicalExpression nonConstArg, ATypeTag typeTag, DatasetConfig.IndexType indexType) {
        if (nonConstArg.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression nonConstfuncExpr = (AbstractFunctionCallExpression)nonConstArg;
            if (nonConstfuncExpr.getFunctionIdentifier() == BuiltinFunctions.WORD_TOKENS && (indexType == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX)) {
                return true;
            }
            if (nonConstfuncExpr.getFunctionIdentifier() == BuiltinFunctions.GRAM_TOKENS && (indexType == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX)) {
                return true;
            }
        }
        boolean isVar = nonConstArg.getExpressionTag() == LogicalExpressionTag.VARIABLE;
        return !(!isVar || typeTag != ATypeTag.ARRAY && typeTag != ATypeTag.MULTISET || indexType != DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX && indexType != DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX);
    }

    private boolean isContainsFuncOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        if (optFuncExpr.getNumLogicalVars() == 2) {
            return this.isContainsFuncJoinOptimizable(index, optFuncExpr);
        }
        return this.isContainsFuncSelectOptimizable(index, optFuncExpr);
    }

    private boolean isContainsFuncSelectOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        AString astr;
        AsterixConstantValue strConstVal = (AsterixConstantValue)((ConstantExpression)optFuncExpr.getConstantExpr(0)).getValue();
        IAObject strObj = strConstVal.getObject();
        ATypeTag typeTag = strObj.getType().getTypeTag();
        if (!this.isContainsFuncCompatible(typeTag, index.getIndexType())) {
            return false;
        }
        return strObj.getType().getTypeTag() == ATypeTag.STRING && (astr = (AString)strObj).getStringValue().length() >= index.getGramLength();
    }

    private boolean isContainsFuncJoinOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        if (index.isEnforced()) {
            return this.isContainsFuncCompatible(((IAType)index.getKeyFieldTypes().get(0)).getTypeTag(), index.getIndexType());
        }
        return this.isContainsFuncCompatible(optFuncExpr.getFieldType(0).getTypeTag(), index.getIndexType());
    }

    private boolean isContainsFuncCompatible(ATypeTag typeTag, DatasetConfig.IndexType indexType) {
        return typeTag == ATypeTag.STRING && (indexType == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX);
    }

    public static IBinaryTokenizerFactory getBinaryTokenizerFactory(SearchModifierType searchModifierType, ATypeTag searchKeyType, Index index) throws AlgebricksException {
        switch (index.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: {
                return BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(searchKeyType, false, false);
            }
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                boolean prePost = searchModifierType != SearchModifierType.CONJUNCTIVE && searchModifierType != SearchModifierType.CONJUNCTIVE_EDIT_DISTANCE;
                return BinaryTokenizerFactoryProvider.INSTANCE.getNGramTokenizerFactory(searchKeyType, index.getGramLength(), prePost, false);
            }
        }
        throw CompilationException.create((int)1034, (Serializable[])new Serializable[]{index.getIndexType()});
    }

    public static IInvertedIndexSearchModifierFactory getSearchModifierFactory(SearchModifierType searchModifierType, IAObject simThresh, Index index) throws AlgebricksException {
        switch (searchModifierType) {
            case CONJUNCTIVE: {
                return new ConjunctiveSearchModifierFactory();
            }
            case DISJUNCTIVE: {
                return new DisjunctiveSearchModifierFactory();
            }
            case JACCARD: {
                float jaccThresh = ((AFloat)simThresh).getFloatValue();
                return new JaccardSearchModifierFactory(jaccThresh);
            }
            case EDIT_DISTANCE: 
            case CONJUNCTIVE_EDIT_DISTANCE: {
                int edThresh = 0;
                try {
                    edThresh = ((AInt32)ATypeHierarchy.convertNumericTypeObject((IAObject)simThresh, (ATypeTag)ATypeTag.INTEGER)).getIntegerValue();
                }
                catch (HyracksDataException e) {
                    throw new AlgebricksException((Throwable)e);
                }
                switch (index.getIndexType()) {
                    case SINGLE_PARTITION_NGRAM_INVIX: 
                    case LENGTH_PARTITIONED_NGRAM_INVIX: {
                        if (searchModifierType == SearchModifierType.EDIT_DISTANCE) {
                            return new EditDistanceSearchModifierFactory(index.getGramLength(), edThresh);
                        }
                        return new ConjunctiveEditDistanceSearchModifierFactory(index.getGramLength(), edThresh);
                    }
                    case SINGLE_PARTITION_WORD_INVIX: 
                    case LENGTH_PARTITIONED_WORD_INVIX: {
                        if (searchModifierType == SearchModifierType.EDIT_DISTANCE) {
                            return new ListEditDistanceSearchModifierFactory(edThresh);
                        }
                        return new ConjunctiveListEditDistanceSearchModifierFactory(edThresh);
                    }
                }
                throw CompilationException.create((int)1035, (Serializable[])new Serializable[]{searchModifierType, index.getIndexType()});
            }
        }
        throw CompilationException.create((int)1036, (Serializable[])new Serializable[]{searchModifierType});
    }

    private void inferTypes(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        for (Mutable childOpRef : op.getInputs()) {
            this.inferTypes((ILogicalOperator)childOpRef.getValue(), context);
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
    }

    @Override
    public String getName() {
        return "INVERTED_INDEX_ACCESS_METHOD";
    }

    @Override
    public int compareTo(IAccessMethod o) {
        return this.getName().compareTo(o.getName());
    }

    static {
        funcIdents.add(BuiltinFunctions.STRING_CONTAINS);
        funcIdents.add(BuiltinFunctions.GET_ITEM);
        funcIdents.add(BuiltinFunctions.FULLTEXT_CONTAINS);
        funcIdents.add(BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION);
        secondLevelFuncIdents = new HashSet();
        secondLevelFuncIdents.add(BuiltinFunctions.SIMILARITY_JACCARD_CHECK);
        secondLevelFuncIdents.add(BuiltinFunctions.EDIT_DISTANCE_CHECK);
        secondLevelFuncIdents.add(BuiltinFunctions.EDIT_DISTANCE_CONTAINS);
        INSTANCE = new InvertedIndexAccessMethod();
    }

    public static enum SearchModifierType {
        CONJUNCTIVE,
        JACCARD,
        EDIT_DISTANCE,
        CONJUNCTIVE_EDIT_DISTANCE,
        INVALID,
        DISJUNCTIVE;

    }
}

