/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ResolveVariableRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getInputs().isEmpty()) {
            return false;
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
        if (op.acceptExpressionTransform(exprRef -> this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)exprRef, (Triple<Boolean, String, String>)new Triple((Object)false, null, null), null, context))) {
            context.computeAndSetTypeEnvironmentForOperator(op);
            return true;
        }
        return false;
    }

    private boolean rewriteExpressionReference(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, Triple<Boolean, String, String> fullyQualifiedDatasetPathCandidateFromParent, Mutable<ILogicalExpression> parentFuncRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean changed = false;
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        Triple<Boolean, String, String> fullyQualifiedDatasetPathCandidate = this.resolveFullyQualifiedPath(funcExpr, context);
        for (Mutable funcArgRef : funcExpr.getArguments()) {
            if (!this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)funcArgRef, fullyQualifiedDatasetPathCandidate, exprRef, context)) continue;
            changed = true;
        }
        if (changed) {
            this.cleanupScanCollectionForDataset(funcExpr);
        }
        return changed || this.resolve(op, context, exprRef, fullyQualifiedDatasetPathCandidateFromParent, parentFuncRef);
    }

    private boolean resolve(ILogicalOperator op, IOptimizationContext context, Mutable<ILogicalExpression> exprRef, Triple<Boolean, String, String> fullyQualifiedDatasetPathCandidateFromParent, Mutable<ILogicalExpression> parentFuncRef) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)exprRef.getValue();
        if (funcExpr.getFunctionIdentifier() != BuiltinFunctions.RESOLVE) {
            return false;
        }
        ILogicalExpression arg = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        String unresolvedVarName = this.extractConstantString(arg);
        return this.resolveInternal(exprRef, this.hasMatchedDatasetForVariableName(unresolvedVarName, context), this.findCandidatePaths(op, this.extractExprs(funcExpr.getArguments()), unresolvedVarName, context), unresolvedVarName, fullyQualifiedDatasetPathCandidateFromParent, parentFuncRef, context);
    }

    private List<ILogicalExpression> extractExprs(List<Mutable<ILogicalExpression>> args) throws AlgebricksException {
        ArrayList<ILogicalExpression> exprs = new ArrayList<ILogicalExpression>();
        for (int index = 1; index < args.size(); ++index) {
            ILogicalExpression argExpr = (ILogicalExpression)args.get(index).getValue();
            exprs.add(argExpr);
        }
        return exprs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean resolveInternal(Mutable<ILogicalExpression> funcRef, boolean hasMatchedDataset, Collection<Pair<ILogicalExpression, List<String>>> varAccessCandidates, String unresolvedVarName, Triple<Boolean, String, String> fullyQualifiedDatasetPathCandidateFromParent, Mutable<ILogicalExpression> parentFuncRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression func = (AbstractFunctionCallExpression)funcRef.getValue();
        int numVarCandidates = varAccessCandidates.size();
        if (numVarCandidates > 0) {
            if (numVarCandidates != 1) throw new AlgebricksException("Cannot resolve ambiguous alias reference for undefined identifier " + unresolvedVarName);
            this.resolveAsFieldAccess(funcRef, varAccessCandidates.iterator().next());
            return true;
        } else if (hasMatchedDataset) {
            func.setFunctionInfo(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.DATASET));
            Mutable datasetNameExpression = (Mutable)func.getArguments().get(0);
            func.getArguments().clear();
            func.getArguments().add(datasetNameExpression);
            return true;
        } else if (((Boolean)fullyQualifiedDatasetPathCandidateFromParent.first).booleanValue()) {
            AbstractFunctionCallExpression parentFunc = (AbstractFunctionCallExpression)parentFuncRef.getValue();
            parentFunc.setFunctionInfo(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.DATASET));
            parentFunc.getArguments().clear();
            parentFunc.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString((String)fullyQualifiedDatasetPathCandidateFromParent.second + "." + (String)fullyQualifiedDatasetPathCandidateFromParent.third)))));
            return true;
        } else {
            MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
            throw new AlgebricksException("Cannot find dataset " + unresolvedVarName + " in dataverse " + metadataProvider.getDefaultDataverseName() + " nor an alias with name " + unresolvedVarName);
        }
    }

    private void resolveAsFieldAccess(Mutable<ILogicalExpression> funcRef, Pair<ILogicalExpression, List<String>> varAndPath) {
        ILogicalExpression expr = (ILogicalExpression)varAndPath.first;
        List path = (List)varAndPath.second;
        MutableObject firstArgRef = new MutableObject((Object)expr);
        ScalarFunctionCallExpression newFunc = null;
        for (String fieldName : path) {
            ArrayList<MutableObject> args = new ArrayList<MutableObject>();
            args.add(firstArgRef);
            args.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(fieldName)))));
            newFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME), args);
            firstArgRef = new MutableObject((Object)newFunc);
        }
        funcRef.setValue(newFunc);
    }

    private Set<Pair<ILogicalExpression, List<String>>> findCandidatePaths(ILogicalOperator op, Collection<ILogicalExpression> referenceExprs, String unresolvedVarName, IOptimizationContext context) throws AlgebricksException {
        HashSet<Pair<ILogicalExpression, List<String>>> candidates = new HashSet<Pair<ILogicalExpression, List<String>>>();
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
        for (ILogicalExpression referenceExpr : referenceExprs) {
            IAType type = (IAType)env.getType(referenceExpr);
            candidates.addAll(this.findCandidatePathsForExpr(unresolvedVarName, type, referenceExpr, new ArrayList<String>()));
        }
        return candidates;
    }

    private Set<Pair<ILogicalExpression, List<String>>> findCandidatePathsForExpr(String unresolvedVarName, IAType pathType, ILogicalExpression expr, List<String> parentPath) throws AlgebricksException {
        ATypeTag tag;
        HashSet<Pair<ILogicalExpression, List<String>>> varAccessCandidates = new HashSet<Pair<ILogicalExpression, List<String>>>();
        IAType type = pathType;
        if (type.getTypeTag() == ATypeTag.UNION) {
            type = ((AUnionType)type).getActualType();
        }
        if ((tag = type.getTypeTag()) == ATypeTag.ANY) {
            ArrayList<String> path = new ArrayList<String>(parentPath);
            path.add(unresolvedVarName);
            varAccessCandidates.add((Pair<ILogicalExpression, List<String>>)new Pair((Object)expr, path));
        }
        if (tag == ATypeTag.OBJECT) {
            ARecordType recordType = (ARecordType)type;
            if (recordType.canContainField(unresolvedVarName)) {
                ArrayList<String> path = new ArrayList<String>(parentPath);
                path.add(unresolvedVarName);
                varAccessCandidates.add((Pair<ILogicalExpression, List<String>>)new Pair((Object)expr, path));
            } else {
                String[] fieldNames = recordType.getFieldNames();
                IAType[] fieldTypes = recordType.getFieldTypes();
                for (int index = 0; index < fieldNames.length; ++index) {
                    ArrayList<String> path = new ArrayList<String>(parentPath);
                    path.add(fieldNames[index]);
                    varAccessCandidates.addAll(this.findCandidatePathsForExpr(unresolvedVarName, fieldTypes[index], expr, path));
                }
            }
        }
        return varAccessCandidates;
    }

    private Triple<Boolean, String, String> resolveFullyQualifiedPath(AbstractFunctionCallExpression funcExpr, IOptimizationContext context) throws AlgebricksException {
        if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME)) {
            return new Triple((Object)false, null, null);
        }
        List args = funcExpr.getArguments();
        ILogicalExpression firstExpr = (ILogicalExpression)((Mutable)args.get(0)).getValue();
        ILogicalExpression secondExpr = (ILogicalExpression)((Mutable)args.get(1)).getValue();
        if (firstExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return new Triple((Object)false, null, null);
        }
        if (secondExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return new Triple((Object)false, null, null);
        }
        AbstractFunctionCallExpression firstFuncExpr = (AbstractFunctionCallExpression)firstExpr;
        if (!firstFuncExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.RESOLVE)) {
            return new Triple((Object)false, null, null);
        }
        ILogicalExpression dataverseNameExpr = (ILogicalExpression)((Mutable)firstFuncExpr.getArguments().get(0)).getValue();
        String dataverseName = this.extractConstantString(dataverseNameExpr);
        String datasetName = this.extractConstantString(secondExpr);
        return new Triple((Object)this.hasMatchedDataverseDataset(dataverseName, datasetName, context), (Object)dataverseName, (Object)datasetName);
    }

    private boolean hasMatchedDataverseDataset(String dataverseName, String datasetName, IOptimizationContext context) throws AlgebricksException {
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        return mdp.findDataset(dataverseName, datasetName) != null;
    }

    private boolean hasMatchedDatasetForVariableName(String varName, IOptimizationContext context) throws AlgebricksException {
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        if (mdp.findDataset(mdp.getDefaultDataverseName(), varName) != null) {
            return true;
        }
        if (varName.contains(".")) {
            String[] path = varName.split("\\.");
            if (path.length != 2) {
                return false;
            }
            if (mdp.findDataset(path[0], path[1]) != null) {
                return true;
            }
        }
        return false;
    }

    private void cleanupScanCollectionForDataset(AbstractFunctionCallExpression funcExpr) {
        if (funcExpr.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return;
        }
        ILogicalExpression arg = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return;
        }
        AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)arg;
        if (argFuncExpr.getFunctionIdentifier() != BuiltinFunctions.DATASET) {
            return;
        }
        funcExpr.setFunctionInfo(argFuncExpr.getFunctionInfo());
        funcExpr.getArguments().clear();
        funcExpr.getArguments().addAll(argFuncExpr.getArguments());
    }

    private String extractConstantString(ILogicalExpression arg) throws AlgebricksException {
        String str = ConstantExpressionUtil.getStringConstant((ILogicalExpression)arg);
        if (str == null) {
            throw new AlgebricksException("The argument is expected to be a string constant value.");
        }
        return str;
    }
}

