/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveLeftOuterUnnestForLeftOuterJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable conditionTestVar;
        ILogicalOperator op1 = (ILogicalOperator)opRef.getValue();
        if (!this.checkOperatorPattern(op1)) {
            return false;
        }
        LeftOuterUnnestOperator outerUnnest = (LeftOuterUnnestOperator)op1;
        GroupByOperator gbyOperator = (GroupByOperator)((Mutable)outerUnnest.getInputs().get(0)).getValue();
        LeftOuterJoinOperator lojOperator = (LeftOuterJoinOperator)((Mutable)gbyOperator.getInputs().get(0)).getValue();
        Triple<Boolean, ILogicalExpression, ILogicalExpression> checkGbyResult = this.checkUnnestAndGby(outerUnnest, gbyOperator);
        if (!this.isVariableReference((ILogicalExpression)checkGbyResult.second) || !this.isVariableReference((ILogicalExpression)checkGbyResult.third)) {
            return false;
        }
        LogicalVariable listifyVar = ((VariableReferenceExpression)checkGbyResult.second).getVariableReference();
        if (!this.checkListifyAndConditionVar(lojOperator, listifyVar, conditionTestVar = ((VariableReferenceExpression)checkGbyResult.third).getVariableReference())) {
            return false;
        }
        this.removeGroupByAndOuterUnnest(opRef, context, outerUnnest, gbyOperator, lojOperator, listifyVar);
        return true;
    }

    private boolean checkOperatorPattern(ILogicalOperator op1) {
        if (op1.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST) {
            return false;
        }
        ILogicalOperator op2 = (ILogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        ILogicalOperator op3 = (ILogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
        return op3.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN;
    }

    private Triple<Boolean, ILogicalExpression, ILogicalExpression> checkUnnestAndGby(LeftOuterUnnestOperator outerUnnest, GroupByOperator gbyOperator) {
        Pair<Boolean, LogicalVariable> checkUnnestResult = this.checkUnnest(outerUnnest);
        if (!((Boolean)checkUnnestResult.first).booleanValue()) {
            return new Triple((Object)false, null, null);
        }
        LogicalVariable varToUnnest = (LogicalVariable)checkUnnestResult.second;
        Triple<Boolean, ILogicalExpression, ILogicalExpression> checkGbyResult = this.checkGroupBy(gbyOperator, varToUnnest);
        if (!((Boolean)checkGbyResult.first).booleanValue()) {
            return new Triple((Object)false, null, null);
        }
        return checkGbyResult;
    }

    private Pair<Boolean, LogicalVariable> checkUnnest(LeftOuterUnnestOperator outerUnnest) {
        if (outerUnnest.getPositionalVariable() != null) {
            return new Pair((Object)false, null);
        }
        HashSet varsToUnnest = new HashSet();
        ((ILogicalExpression)outerUnnest.getExpressionRef().getValue()).getUsedVariables(varsToUnnest);
        if (varsToUnnest.size() > 1) {
            return new Pair((Object)false, null);
        }
        return new Pair((Object)true, varsToUnnest.iterator().next());
    }

    private Triple<Boolean, ILogicalExpression, ILogicalExpression> checkGroupBy(GroupByOperator gbyOperator, LogicalVariable varToUnnest) {
        Pair<Boolean, ILogicalOperator> checkNestedPlanResult = this.checkNestedPlan(gbyOperator);
        if (!((Boolean)checkNestedPlanResult.first).booleanValue()) {
            return new Triple((Object)false, null, null);
        }
        ILogicalOperator root = (ILogicalOperator)checkNestedPlanResult.second;
        if (root.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return new Triple((Object)false, null, null);
        }
        AggregateOperator agg = (AggregateOperator)root;
        Pair<Boolean, ILogicalExpression> listifyArgPair = this.checksAggregate(agg, varToUnnest);
        if (!((Boolean)listifyArgPair.first).booleanValue()) {
            return new Triple((Object)false, null, null);
        }
        ILogicalOperator rootInputOp = (ILogicalOperator)((Mutable)root.getInputs().get(0)).getValue();
        if (rootInputOp.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return new Triple((Object)false, null, null);
        }
        SelectOperator select = (SelectOperator)rootInputOp;
        Pair<Boolean, ILogicalExpression> conditionArgPair = this.checkSelect(select);
        return new Triple((Object)true, listifyArgPair.second, conditionArgPair.second);
    }

    private Pair<Boolean, ILogicalOperator> checkNestedPlan(GroupByOperator gbyOperator) {
        List nestedPlans = gbyOperator.getNestedPlans();
        if (nestedPlans.size() > 1) {
            return new Pair((Object)false, null);
        }
        ILogicalPlan plan = (ILogicalPlan)nestedPlans.get(0);
        List roots = plan.getRoots();
        if (roots.size() > 1) {
            return new Pair((Object)false, null);
        }
        ILogicalOperator root = (ILogicalOperator)((Mutable)roots.get(0)).getValue();
        return new Pair((Object)true, (Object)root);
    }

    private Pair<Boolean, ILogicalExpression> checksAggregate(AggregateOperator agg, LogicalVariable varToUnnest) {
        if (!agg.getVariables().contains(varToUnnest)) {
            return new Pair((Object)false, null);
        }
        List exprRefs = agg.getExpressions();
        if (exprRefs.size() > 1) {
            return new Pair((Object)false, null);
        }
        ILogicalExpression expr = (ILogicalExpression)((Mutable)exprRefs.get(0)).getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return new Pair((Object)false, null);
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.LISTIFY)) {
            return new Pair((Object)false, null);
        }
        return new Pair((Object)true, ((Mutable)funcExpr.getArguments().get(0)).getValue());
    }

    private Pair<Boolean, ILogicalExpression> checkSelect(SelectOperator select) {
        ILogicalExpression condition = (ILogicalExpression)select.getCondition().getValue();
        if (condition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return new Pair((Object)false, null);
        }
        AbstractFunctionCallExpression conditionFunc = (AbstractFunctionCallExpression)condition;
        if (!conditionFunc.getFunctionIdentifier().equals((Object)BuiltinFunctions.NOT)) {
            return new Pair((Object)false, null);
        }
        condition = (ILogicalExpression)((Mutable)conditionFunc.getArguments().get(0)).getValue();
        if (condition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return new Pair((Object)false, null);
        }
        conditionFunc = (AbstractFunctionCallExpression)condition;
        if (!conditionFunc.getFunctionIdentifier().equals((Object)BuiltinFunctions.IS_MISSING)) {
            return new Pair((Object)false, null);
        }
        ILogicalExpression conditionArg = (ILogicalExpression)((Mutable)conditionFunc.getArguments().get(0)).getValue();
        return new Pair((Object)true, (Object)conditionArg);
    }

    private boolean checkListifyAndConditionVar(LeftOuterJoinOperator lojOperator, LogicalVariable listifyVar, LogicalVariable conditionTestVar) throws AlgebricksException {
        ILogicalOperator rightJoinInputOp = (ILogicalOperator)((Mutable)lojOperator.getInputs().get(1)).getValue();
        HashSet rightProducedVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)rightJoinInputOp, rightProducedVars);
        return rightProducedVars.contains(conditionTestVar) && rightProducedVars.contains(listifyVar);
    }

    private void removeGroupByAndOuterUnnest(Mutable<ILogicalOperator> opRef, IOptimizationContext context, LeftOuterUnnestOperator outerUnnest, GroupByOperator gbyOperator, LeftOuterJoinOperator lojOperator, LogicalVariable listifyVar) throws AlgebricksException {
        ArrayList<Object> lhs = new ArrayList<Object>();
        ArrayList<Object> rhs = new ArrayList<Object>();
        lhs.add(outerUnnest.getVariable());
        rhs.add(new MutableObject((Object)new VariableReferenceExpression(listifyVar)));
        List gbyList = gbyOperator.getGroupByList();
        for (Pair gbyPair : gbyList) {
            lhs.add(gbyPair.first);
            rhs.add(gbyPair.second);
        }
        AssignOperator assignOp = new AssignOperator(lhs, rhs);
        assignOp.getInputs().add(new MutableObject((Object)lojOperator));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        opRef.setValue((Object)assignOp);
    }

    private boolean isVariableReference(ILogicalExpression expr) {
        return expr.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

