/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;

public class LSMBTreeTupleWriter
extends TypeAwareTupleWriter
implements ILSMTreeTupleWriter {
    private boolean isAntimatter;
    private final int numKeyFields;

    public LSMBTreeTupleWriter(ITypeTraits[] typeTraits, int numKeyFields, boolean isAntimatter) {
        super(typeTraits);
        this.numKeyFields = numKeyFields;
        this.isAntimatter = isAntimatter;
    }

    public int bytesRequired(ITupleReference tuple) {
        if (this.isAntimatter) {
            return super.bytesRequired(tuple, 0, this.numKeyFields);
        }
        return super.bytesRequired(tuple);
    }

    public int getCopySpaceRequired(ITupleReference tuple) {
        return super.bytesRequired(tuple);
    }

    public ITreeIndexTupleReference createTupleReference() {
        return new LSMBTreeTupleReference(this.typeTraits, this.numKeyFields);
    }

    protected int getNullFlagsBytes(int numFields) {
        return (int)Math.ceil(((double)numFields + 1.0) / 8.0);
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return (int)Math.ceil(((double)tuple.getFieldCount() + 1.0) / 8.0);
    }

    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int bytesWritten = -1;
        if (this.isAntimatter) {
            bytesWritten = super.writeTupleFields(tuple, 0, this.numKeyFields, targetBuf, targetOff);
            this.setAntimatterBit(targetBuf, targetOff);
        } else {
            bytesWritten = super.writeTuple(tuple, targetBuf, targetOff);
        }
        return bytesWritten;
    }

    private void setAntimatterBit(byte[] targetBuf, int targetOff) {
        targetBuf[targetOff] = (byte)(targetBuf[targetOff] | 0x80);
    }

    public void setAntimatter(boolean isDelete) {
        this.isAntimatter = isDelete;
    }
}

