/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMBuddyBTreeMergeCursor
extends LSMIndexSearchCursor {
    public LSMBuddyBTreeMergeCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, true);
    }

    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        return false;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeWithBuddyCursorInitialState lsmInitialState = (LSMBTreeWithBuddyCursorInitialState)initialState;
        this.cmp = lsmInitialState.getBuddyBTreeCmp();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = null;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        RangePredicate btreePredicate = new RangePredicate(null, null, true, true, this.cmp, this.cmp);
        ITreeIndexAccessor[] btreeAccessors = new ITreeIndexAccessor[numBTrees];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)lsmInitialState.getBuddyBTreeLeafFrameFactory().createFrame();
            this.rangeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
            BTree buddyBtree = ((LSMBTreeWithBuddyDiskComponent)component).getBuddyBTree();
            btreeAccessors[i] = buddyBtree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            btreeAccessors[i].search(this.rangeCursors[i], (ISearchPredicate)btreePredicate);
        }
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
    }
}

