/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeWithBuddyFileManager
extends AbstractLSMIndexFileManager {
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory;
    private static FilenameFilter btreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private static FilenameFilter buddyBtreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("d");

    public LSMBTreeWithBuddyFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory) {
        super(ioManager, file, null);
        this.buddyBtreeFactory = buddyBtreeFactory;
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        String baseName = ts + "_" + ts;
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split("_");
        String[] lastTimestampRange = lastFileName.split("_");
        String baseName = firstTimestampRange[0] + "_" + lastTimestampRange[1];
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBuddyBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilefilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(btreeFilter, transactionFilefilter), this.btreeFactory, allBTreeFiles);
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (AbstractLSMIndexFileManager.ComparableFileName cmpFileName : allBTreeFiles) {
            int index = cmpFileName.fileName.lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.fileName.substring(0, index));
        }
        this.validateFiles(btreeFilesSet, allBuddyBTreeFiles, this.getCompoundFilter(buddyBtreeFilter, transactionFilefilter), this.buddyBtreeFactory);
        this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(bloomFilterFilter, transactionFilefilter), null);
        if (allBTreeFiles.size() != allBuddyBTreeFiles.size() || allBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
        }
        if (allBTreeFiles.isEmpty() || allBuddyBTreeFiles.isEmpty() || allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (allBTreeFiles.size() == 1 && allBuddyBTreeFiles.size() == 1 && allBloomFilterFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get((int)0)).fileRef));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        Collections.sort(allBuddyBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBuddyBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBuddyBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get(0);
        validComparableBuddyBTreeFiles.add(lastBuddyBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBloomFilterFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            AbstractLSMIndexFileManager.ComparableFileName currentBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName currentBuddyBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName currentBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(i);
            if (currentBTree.interval[0].compareTo(lastBTree.interval[1]) > 0 && currentBuddyBTree.interval[0].compareTo(lastBuddyBTree.interval[1]) > 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[1]) > 0) {
                validComparableBTreeFiles.add(currentBTree);
                validComparableBuddyBTreeFiles.add(currentBuddyBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBTree = currentBTree;
                lastBuddyBTree = currentBuddyBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.interval[0].compareTo(lastBTree.interval[0]) >= 0 && currentBTree.interval[1].compareTo(lastBTree.interval[1]) <= 0 && currentBuddyBTree.interval[0].compareTo(lastBuddyBTree.interval[0]) >= 0 && currentBuddyBTree.interval[1].compareTo(lastBuddyBTree.interval[1]) <= 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[0]) >= 0 && currentBloomFilter.interval[1].compareTo(lastBloomFilter.interval[1]) <= 0) {
                IoUtil.delete((File)new File(currentBTree.fullPath));
                IoUtil.delete((File)new File(currentBuddyBTree.fullPath));
                IoUtil.delete((File)new File(currentBloomFilter.fullPath));
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        Collections.sort(validComparableBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableBuddyBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator buddyBtreeFileIter = validComparableBuddyBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (btreeFileIter.hasNext() && buddyBtreeFileIter.hasNext()) {
            AbstractLSMIndexFileManager.ComparableFileName cmpBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)btreeFileIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpBuddyBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)buddyBtreeFileIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpBloomFilterFileName = (AbstractLSMIndexFileManager.ComparableFileName)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.fileRef, cmpBuddyBTreeFileName.fileRef, cmpBloomFilterFileName.fileRef));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String ts = this.getCurrentTimestamp();
        Files.createFile(Paths.get(this.baseDir + ".T" + ts, new String[0]), new FileAttribute[0]);
        String baseName = ts + "_" + ts;
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), this.baseDir.getChild(baseName + "_" + "d"), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        String[] files = this.baseDir.getFile().list(txnFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        files = this.baseDir.getFile().list(transactionFilter);
        if (files.length < 3) {
            throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
        }
        IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        FileReference bTreeFileRef = null;
        FileReference buddyBTreeFileRef = null;
        FileReference bloomFilterFileRef = null;
        for (String fileName : files) {
            if (fileName.endsWith("b")) {
                bTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("d")) {
                buddyBTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            throw HyracksDataException.create((int)86, (Serializable[])new Serializable[]{fileName});
        }
        return new LSMComponentFileReferences(bTreeFileRef, buddyBTreeFileRef, bloomFilterFileRef);
    }
}

