/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentScanCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMBTreeSearchCursor
implements ITreeIndexCursor {
    private final LSMBTreePointSearchCursor pointCursor;
    private final LSMBTreeRangeSearchCursor rangeCursor;
    private final LSMBTreeDiskComponentScanCursor scanCursor;
    private ITreeIndexCursor currentCursor;

    public LSMBTreeSearchCursor(ILSMIndexOperationContext opCtx) {
        this.pointCursor = new LSMBTreePointSearchCursor(opCtx);
        this.rangeCursor = new LSMBTreeRangeSearchCursor(opCtx);
        this.scanCursor = new LSMBTreeDiskComponentScanCursor(opCtx);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        RangePredicate btreePred = (RangePredicate)searchPred;
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.currentCursor = btreePred.isPointPredicate(lsmInitialState.getOriginalKeyComparator()) ? this.pointCursor : this.rangeCursor;
        this.currentCursor.open((ICursorInitialState)lsmInitialState, searchPred);
    }

    public void scan(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        this.currentCursor = this.scanCursor;
        this.currentCursor.open(initialState, searchPred);
    }

    public boolean hasNext() throws HyracksDataException {
        return this.currentCursor.hasNext();
    }

    public void next() throws HyracksDataException {
        this.currentCursor.next();
    }

    public void close() throws HyracksDataException {
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = null;
    }

    public void reset() throws HyracksDataException {
        if (this.currentCursor != null) {
            this.currentCursor.reset();
        }
        this.currentCursor = null;
    }

    public ITupleReference getTuple() {
        return this.currentCursor.getTuple();
    }

    public ITupleReference getFilterMinTuple() {
        return this.currentCursor.getFilterMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        return this.currentCursor.getFilterMaxTuple();
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.currentCursor.setBufferCache(bufferCache);
    }

    public void setFileId(int fileId) {
        this.currentCursor.setFileId(fileId);
    }

    public boolean isExclusiveLatchNodes() {
        return this.currentCursor.isExclusiveLatchNodes();
    }

    public static enum LSMBTreeSearchType {
        POINT,
        RANGE;

    }
}

