/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMBTreeDiskComponentScanCursor
extends LSMIndexSearchCursor {
    private static final IValueReference MATTER_TUPLE_FLAG = BooleanPointable.FACTORY.createPointable(false);
    private static final IValueReference ANTIMATTER_TUPLE_FLAG = BooleanPointable.FACTORY.createPointable(true);
    private BTree.BTreeAccessor[] btreeAccessors;
    private ArrayTupleBuilder tupleBuilder;
    private ArrayTupleBuilder antiMatterTupleBuilder;
    private final ArrayTupleReference outputTuple = new ArrayTupleReference();
    private PermutingTupleReference originalTuple;
    private boolean foundNext;
    private IntegerPointable cursorIndexPointable;

    public LSMBTreeDiskComponentScanCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, true);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getOriginalKeyComparator();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.includeMutableComponent = false;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        this.btreeAccessors = new BTree.BTreeAccessor[numBTrees];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)lsmInitialState.getLeafFrameFactory().createFrame();
            this.rangeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
            BTree btree = ((LSMBTreeDiskComponent)component).getBTree();
            this.btreeAccessors[i] = (BTree.BTreeAccessor)btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.btreeAccessors[i].search(this.rangeCursors[i], searchPred);
        }
        this.cursorIndexPointable = new IntegerPointable();
        int length = IntegerPointable.TYPE_TRAITS.getFixedLength();
        this.cursorIndexPointable.set(new byte[length], 0, length);
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.foundNext) {
            return true;
        }
        while (super.hasNext()) {
            super.next();
            LSMBTreeTupleReference diskTuple = (LSMBTreeTupleReference)super.getTuple();
            if (diskTuple.isAntimatter()) {
                if (!this.setAntiMatterTuple((ITupleReference)diskTuple, this.outputElement.getCursorIndex())) continue;
                this.foundNext = true;
                return true;
            }
            this.setMatterTuple((ITupleReference)diskTuple, this.outputElement.getCursorIndex());
            this.foundNext = true;
            return true;
        }
        return false;
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return -1;
    }

    private void setMatterTuple(ITupleReference diskTuple, int cursorIndex) throws HyracksDataException {
        if (this.tupleBuilder == null) {
            this.tupleBuilder = new ArrayTupleBuilder(diskTuple.getFieldCount() + 2);
            this.antiMatterTupleBuilder = new ArrayTupleBuilder(diskTuple.getFieldCount() + 2);
            int[] permutation = new int[diskTuple.getFieldCount()];
            for (int i = 0; i < permutation.length; ++i) {
                permutation[i] = i + 2;
            }
            this.originalTuple = new PermutingTupleReference(permutation);
        }
        this.buildTuple(this.tupleBuilder, diskTuple, cursorIndex, MATTER_TUPLE_FLAG);
        this.outputTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        this.originalTuple.reset((ITupleReference)this.outputTuple);
    }

    private boolean setAntiMatterTuple(ITupleReference diskTuple, int cursorIndex) throws HyracksDataException {
        if (this.originalTuple == null || this.cmp.compare(diskTuple, (ITupleReference)this.originalTuple) != 0) {
            return false;
        }
        this.buildTuple(this.antiMatterTupleBuilder, (ITupleReference)this.originalTuple, cursorIndex, ANTIMATTER_TUPLE_FLAG);
        this.outputTuple.reset(this.antiMatterTupleBuilder.getFieldEndOffsets(), this.antiMatterTupleBuilder.getByteArray());
        return true;
    }

    private void buildTuple(ArrayTupleBuilder builder, ITupleReference diskTuple, int cursorIndex, IValueReference tupleFlag) throws HyracksDataException {
        builder.reset();
        this.cursorIndexPointable.setInteger(cursorIndex);
        builder.addField((IValueReference)this.cursorIndexPointable);
        builder.addField(tupleFlag);
        for (int i = 0; i < diskTuple.getFieldCount(); ++i) {
            builder.addField(diskTuple.getFieldData(i), diskTuple.getFieldStart(i), diskTuple.getFieldLength(i));
        }
    }

    public ITupleReference getTuple() {
        return this.outputTuple;
    }

    public void close() throws HyracksDataException {
        if (this.lsmHarness != null) {
            try {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].close();
                }
                this.rangeCursors = null;
            }
            finally {
                this.lsmHarness.endScanDiskComponents(this.opCtx);
            }
        }
        this.foundNext = false;
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueScanComparator(this.cmp);
        }
    }

    private class PriorityQueueScanComparator
    extends LSMIndexSearchCursor.PriorityQueueComparator {
        public PriorityQueueScanComparator(MultiComparator cmp) {
            super((LSMIndexSearchCursor)LSMBTreeDiskComponentScanCursor.this, cmp);
        }

        public int compare(LSMIndexSearchCursor.PriorityQueueElement elementA, LSMIndexSearchCursor.PriorityQueueElement elementB) {
            try {
                int result = this.cmp.compare(elementA.getTuple(), elementB.getTuple());
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            return elementA.getCursorIndex() > elementB.getCursorIndex() ? -1 : 1;
        }
    }
}

