/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeDiskComponentFactory
implements ILSMDiskComponentFactory {
    private final TreeIndexFactory<BTree> btreeFactory;
    private final BloomFilterFactory bloomFilterFactory;
    private final IComponentFilterHelper filterHelper;

    public LSMBTreeDiskComponentFactory(TreeIndexFactory<BTree> btreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper) {
        this.btreeFactory = btreeFactory;
        this.bloomFilterFactory = bloomFilterFactory;
        this.filterHelper = filterHelper;
    }

    public LSMBTreeDiskComponent createComponent(LSMComponentFileReferences cfr) throws HyracksDataException {
        return new LSMBTreeDiskComponent((BTree)this.btreeFactory.createIndexInstance(cfr.getInsertIndexFileReference()), this.bloomFilterFactory == null ? null : this.bloomFilterFactory.createBloomFiltertInstance(cfr.getBloomFilterFileReference()), this.filterHelper == null ? null : this.filterHelper.createFilter());
    }

    public int[] getBloomFilterKeyFields() {
        return this.bloomFilterFactory == null ? null : this.bloomFilterFactory.getBloomFilterKeyFields();
    }
}

