/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.api.ITupleAcceptor;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.AntimatterAwareTupleAcceptor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeBulkLoader;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMBTree
extends AbstractLSMIndex
implements ITreeIndex {
    private static final LSMTreeIndexAccessor.ICursorFactory cursorFactory = opCtx -> new LSMBTreeSearchCursor(opCtx);
    protected final LSMBTreeDiskComponentFactory componentFactory;
    protected final LSMBTreeDiskComponentFactory bulkLoadComponentFactory;
    protected final ITreeIndexFrameFactory insertLeafFrameFactory;
    protected final ITreeIndexFrameFactory deleteLeafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    private final boolean needKeyDupCheck;
    private final boolean hasBloomFilter;

    public LSMBTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean needKeyDupCheck, int[] btreeFields, int[] filterFields, boolean durable) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBTreeFactory.getBufferCache(), fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable, filterHelper, btreeFields);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            LSMBTreeMemoryComponent mutableComponent = new LSMBTreeMemoryComponent(new BTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), interiorFrameFactory, insertLeafFrameFactory, cmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_" + i)), virtualBufferCache, i == 0, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.componentFactory = new LSMBTreeDiskComponentFactory(diskBTreeFactory, bloomFilterFactory, filterHelper);
        this.bulkLoadComponentFactory = new LSMBTreeDiskComponentFactory(bulkLoadBTreeFactory, bloomFilterFactory, filterHelper);
        this.needKeyDupCheck = needKeyDupCheck;
        this.hasBloomFilter = needKeyDupCheck;
    }

    public LSMBTree(IIOManager ioManager, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean needKeyDupCheck, boolean durable) {
        super(ioManager, diskBTreeFactory.getBufferCache(), fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.needKeyDupCheck = needKeyDupCheck;
        this.hasBloomFilter = true;
        this.componentFactory = new LSMBTreeDiskComponentFactory(diskBTreeFactory, bloomFilterFactory, null);
        this.bulkLoadComponentFactory = new LSMBTreeDiskComponentFactory(bulkLoadBTreeFactory, bloomFilterFactory, null);
    }

    public boolean hasBloomFilter() {
        return this.hasBloomFilter;
    }

    public boolean isPrimaryIndex() {
        return this.needKeyDupCheck;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    protected ILSMDiskComponent loadComponent(LSMComponentFileReferences lsmComonentFileReferences) throws HyracksDataException {
        return this.createDiskComponent(this.componentFactory, lsmComonentFileReferences.getInsertIndexFileReference(), lsmComonentFileReferences.getBloomFilterFileReference(), false);
    }

    protected void destroyDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
        component.getBTree().destroy();
        if (this.hasBloomFilter) {
            component.getBloomFilter().destroy();
        }
    }

    protected void clearDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
        if (this.hasBloomFilter) {
            component.getBloomFilter().deactivate();
        }
        component.getBTree().deactivate();
        if (this.hasBloomFilter) {
            component.getBloomFilter().destroy();
        }
        component.getBTree().destroy();
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        ITupleReference indexTuple;
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        if (ctx.getIndexTuple() != null) {
            ctx.getIndexTuple().reset(tuple);
            indexTuple = ctx.getIndexTuple();
            ctx.getCurrentMutableBTreeAccessor().getOpContext().resetNonIndexFieldsTuple(tuple);
        } else {
            indexTuple = tuple;
        }
        switch (ctx.getOperation()) {
            case PHYSICALDELETE: {
                ctx.getCurrentMutableBTreeAccessor().delete(indexTuple);
                break;
            }
            case INSERT: {
                this.insert(indexTuple, ctx);
                break;
            }
            default: {
                ctx.getCurrentMutableBTreeAccessor().upsert(indexTuple);
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(ITupleReference tuple, LSMBTreeOpContext ctx) throws HyracksDataException {
        LSMBTreePointSearchCursor searchCursor = ctx.getInsertSearchCursor();
        BTreeRangeSearchCursor memCursor = ctx.getMemCursor();
        RangePredicate predicate = (RangePredicate)ctx.getSearchPredicate();
        predicate.setHighKey(tuple);
        predicate.setLowKey(tuple);
        if (this.needKeyDupCheck) {
            ctx.getCurrentMutableBTreeAccessor().search((IIndexCursor)memCursor, (ISearchPredicate)predicate);
            try {
                if (memCursor.hasNext()) {
                    memCursor.next();
                    LSMBTreeTupleReference lsmbtreeTuple = (LSMBTreeTupleReference)memCursor.getTuple();
                    if (!lsmbtreeTuple.isAntimatter()) {
                        throw HyracksDataException.create((int)33, (Serializable[])new Serializable[0]);
                    }
                    memCursor.close();
                    ctx.getCurrentMutableBTreeAccessor().upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                memCursor.close();
            }
            ILSMComponent firstComponent = (ILSMComponent)ctx.getComponentHolder().remove(0);
            this.search((ILSMIndexOperationContext)ctx, (IIndexCursor)searchCursor, (ISearchPredicate)predicate);
            try {
                if (searchCursor.hasNext()) {
                    throw HyracksDataException.create((int)33, (Serializable[])new Serializable[0]);
                }
            }
            finally {
                searchCursor.close();
                ctx.getComponentHolder().add(0, firstComponent);
            }
        }
        ctx.getCurrentMutableBTreeAccessor().upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
        return true;
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        List operationalComponents = ctx.getComponentHolder();
        ctx.getSearchInitialState().reset(pred, operationalComponents);
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public void scanDiskComponents(ILSMIndexOperationContext ictx, IIndexCursor cursor) throws HyracksDataException {
        if (!this.isPrimaryIndex()) {
            throw HyracksDataException.create((int)56, (Serializable[])new Serializable[0]);
        }
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        List operationalComponents = ctx.getComponentHolder();
        MultiComparator comp = MultiComparator.create((IBinaryComparatorFactory[])this.getComparatorFactories());
        RangePredicate pred = new RangePredicate(null, null, true, true, comp, comp);
        ctx.getSearchInitialState().reset((ISearchPredicate)pred, operationalComponents);
        ((LSMBTreeSearchCursor)cursor).scan(ctx.getSearchInitialState(), (ISearchPredicate)pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        LSMBTreeFlushOperation flushOp = (LSMBTreeFlushOperation)operation;
        LSMBTreeMemoryComponent flushingComponent = (LSMBTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor accessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        long numElements = 0L;
        if (this.hasBloomFilter) {
            accessor.search((IIndexCursor)countingCursor, (ISearchPredicate)nullPred);
            try (ITreeIndexCursor countingCursor = ((BTree.BTreeAccessor)accessor).createCountingSearchCursor();){
                while (countingCursor.hasNext()) {
                    countingCursor.next();
                    ITupleReference countTuple = countingCursor.getTuple();
                    numElements = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                }
            }
        }
        LSMBTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), flushOp.getBloomFilterTarget(), true);
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, numElements, false, false, false);
        accessor.search(scanCursor, (ISearchPredicate)nullPred);
        try (IIndexCursor scanCursor = accessor.createSearchCursor(false);){
            while (scanCursor.hasNext()) {
                scanCursor.next();
                componentBulkLoader.add(scanCursor.getTuple());
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getBTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        LSMBTreeMergeOperation mergeOp = (LSMBTreeMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)rangePred);
        List mergedComponents = mergeOp.getMergingComponents();
        long numElements = 0L;
        if (this.hasBloomFilter) {
            for (int i = 0; i < mergedComponents.size(); ++i) {
                numElements += ((LSMBTreeDiskComponent)((Object)mergedComponents.get(i))).getBloomFilter().getNumElements();
            }
        }
        LSMBTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBloomFilterTarget(), true);
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)mergedComponent, 1.0f, false, numElements, false, false, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        if (mergedComponent.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple());
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple());
            }
            this.getFilterManager().updateFilter(mergedComponent.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(mergedComponent.getLSMComponentFilter(), (ITreeIndex)mergedComponent.getBTree());
        }
        componentBulkLoader.end();
        return mergedComponent;
    }

    protected LSMBTreeDiskComponent createDiskComponent(LSMBTreeDiskComponentFactory factory, FileReference btreeFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException {
        LSMBTreeDiskComponent component = factory.createComponent(new LSMComponentFileReferences(btreeFileRef, null, bloomFilterFileRef));
        if (createComponent) {
            component.getBTree().create();
        }
        component.getBTree().activate();
        if (this.hasBloomFilter) {
            if (createComponent) {
                component.getBloomFilter().create();
            }
            component.getBloomFilter().activate();
        }
        if (component.getLSMComponentFilter() != null && !createComponent) {
            this.getFilterManager().readFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getBTree());
        }
        return component;
    }

    public ILSMDiskComponentBulkLoader createComponentBulkLoader(ILSMDiskComponent component, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        BloomFilterSpecification bloomFilterSpec = null;
        if (this.hasBloomFilter) {
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        if (withFilter && this.filterFields != null) {
            return new LSMBTreeDiskComponentBulkLoader((LSMBTreeDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, (ILSMComponentFilterManager)this.filterManager, this.treeFields, this.filterFields, MultiComparator.create((IBinaryComparatorFactory[])component.getLSMComponentFilter().getFilterCmpFactories()));
        }
        return new LSMBTreeDiskComponentBulkLoader((LSMBTreeDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMBTreeBulkLoader(this, fillLevel, verifyInput, numElementsHint);
    }

    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)lsmComponent;
        if (this.hasBloomFilter) {
            this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        }
        this.markAsValidInternal((ITreeIndex)component.getBTree());
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, ILSMMemoryComponent flushingComponent, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) {
        ILSMIndexAccessor accessor = this.createAccessor(opCtx);
        return new LSMBTreeFlushOperation(accessor, flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }

    public LSMBTreeOpContext createOpContext(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        int numBloomFilterKeyFields = this.hasBloomFilter ? this.componentFactory.getBloomFilterKeyFields().length : 0;
        return new LSMBTreeOpContext(this.memoryComponents, this.insertLeafFrameFactory, this.deleteLeafFrameFactory, modificationCallback, searchCallback, numBloomFilterKeyFields, this.getTreeFields(), this.getFilterFields(), this.getLsmHarness(), this.getFilterCmpFactories());
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return this.createAccessor(this.createOpContext(modificationCallback, searchCallback));
    }

    public ILSMIndexAccessor createAccessor(AbstractLSMIndexOperationContext opCtx) {
        return new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getInteriorFrameFactory();
    }

    public int getFieldCount() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getFieldCount();
    }

    public int getFileId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getFileId();
    }

    public IPageManager getPageManager() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getPageManager();
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getLeafFrameFactory();
    }

    public int getRootPageId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getRootPageId();
    }

    protected long getMemoryComponentSize(ILSMMemoryComponent c) {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
        IBufferCache virtualBufferCache = mutableComponent.getBTree().getBufferCache();
        return (long)virtualBufferCache.getNumPages() * (long)virtualBufferCache.getPageSize();
    }

    public String toString() {
        return "LSMBTree [" + this.fileManager.getBaseDir() + "]";
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        if (this.hasBloomFilter) {
            files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        }
        return files;
    }

    protected void clearMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
        mutableComponent.getBTree().clear();
        mutableComponent.reset();
    }

    protected void validateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
        mutableComponent.getBTree().validate();
    }

    protected void validateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        BTree btree = ((LSMBTreeDiskComponent)c).getBTree();
        btree.validate();
    }

    protected void deactivateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
        component.getBTree().deactivate();
        component.getBTree().purge();
        if (this.hasBloomFilter) {
            component.getBloomFilter().deactivate();
            component.getBloomFilter().purge();
        }
    }

    protected void deactivateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
        mutableComponent.getBTree().deactivate();
        mutableComponent.getBTree().destroy();
        ((IVirtualBufferCache)mutableComponent.getBTree().getBufferCache()).close();
    }

    protected void allocateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
        ((IVirtualBufferCache)mutableComponent.getBTree().getBufferCache()).open();
        mutableComponent.getBTree().create();
        mutableComponent.getBTree().activate();
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        BTree firstBTree = ((LSMBTreeDiskComponent)firstComponent).getBTree();
        BTree lastBTree = ((LSMBTreeDiskComponent)lastComponent).getBTree();
        FileReference firstFile = firstBTree.getFileReference();
        FileReference lastFile = lastBTree.getFileReference();
        return this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, List<ILSMComponent> mergingComponents, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) {
        boolean returnDeletedTuples = false;
        ILSMIndexAccessor accessor = this.createAccessor(opCtx);
        if (mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMBTreeRangeSearchCursor cursor = new LSMBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        return new LSMBTreeMergeOperation(accessor, mergingComponents, (ITreeIndexCursor)cursor, mergeFileRefs.getInsertIndexFileReference(), mergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }
}

