/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeWithBuddyOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySortedCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBuddyBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class ExternalBTreeWithBuddy
extends AbstractLSMIndex
implements ITreeIndex,
ITwoPCIndex {
    private final LSMBTreeWithBuddyDiskComponentFactory componentFactory;
    private final LSMBTreeWithBuddyDiskComponentFactory bulkComponentFactory;
    private final IBinaryComparatorFactory[] btreeCmpFactories;
    private final IBinaryComparatorFactory[] buddyBtreeCmpFactories;
    private final int[] buddyBTreeFields;
    private final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    private final ITreeIndexFrameFactory btreeLeafFrameFactory;
    private final ITreeIndexFrameFactory buddyBtreeLeafFrameFactory;
    private final List<ILSMDiskComponent> secondDiskComponents;
    private int version = 0;

    public ExternalBTreeWithBuddy(IIOManager ioManager, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ITreeIndexFrameFactory buddyBtreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> bulkLoadBTreeFactory, TreeIndexFactory<BTree> copyBtreeFactory, TreeIndexFactory<BTree> buddyBtreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, IBinaryComparatorFactory[] btreeCmpFactories, IBinaryComparatorFactory[] buddyBtreeCmpFactories, int[] buddyBTreeFields, boolean durable) {
        super(ioManager, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.btreeCmpFactories = btreeCmpFactories;
        this.buddyBtreeCmpFactories = buddyBtreeCmpFactories;
        this.buddyBTreeFields = buddyBTreeFields;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.buddyBtreeLeafFrameFactory = buddyBtreeLeafFrameFactory;
        this.componentFactory = new LSMBTreeWithBuddyDiskComponentFactory(copyBtreeFactory, buddyBtreeFactory, bloomFilterFactory);
        this.bulkComponentFactory = new LSMBTreeWithBuddyDiskComponentFactory(bulkLoadBTreeFactory, buddyBtreeFactory, bloomFilterFactory);
        this.secondDiskComponents = new LinkedList<ILSMDiskComponent>();
    }

    public void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    protected ILSMDiskComponent loadComponent(LSMComponentFileReferences refs) throws HyracksDataException {
        return null;
    }

    public void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMBTreeWithBuddyDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            ((ExternalIndexHarness)this.getLsmHarness()).indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree buddyBtree;
            BTree btree;
            LSMBTreeWithBuddyDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
                btree = component.getBTree();
                buddyBtree = component.getBuddyBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                buddyBtree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
                btree = component.getBTree();
                buddyBtree = component.getBuddyBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                buddyBtree.activate();
                bloomFilter.activate();
            }
        }
        this.isActive = true;
    }

    public void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        ((ExternalIndexHarness)this.getLsmHarness()).indexClear();
        for (ILSMDiskComponent c : this.diskComponents) {
            this.clearDiskComponent(c);
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            this.clearDiskComponent(c);
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = 0;
    }

    protected void clearDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)c;
        component.getBTree().deactivate();
        component.getBuddyBTree().deactivate();
        component.getBloomFilter().deactivate();
        component.getBTree().destroy();
        component.getBloomFilter().destroy();
        component.getBuddyBTree().destroy();
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.destroyDiskComponent(c);
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            this.destroyDiskComponent(c);
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = 0;
    }

    protected void destroyDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)c;
        component.getBTree().destroy();
        component.getBuddyBTree().destroy();
        component.getBloomFilter().destroy();
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, this.version), ctx -> new LSMBTreeWithBuddySearchCursor(ctx, this.buddyBTreeFields));
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public ILSMDiskComponentBulkLoader createComponentBulkLoader(ILSMDiskComponent component, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        BloomFilterSpecification bloomFilterSpec = null;
        if (numElementsHint > 0L) {
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        if (withFilter && this.filterFields != null) {
            return new LSMBTreeWithBuddyDiskComponentBulkLoader((LSMBTreeWithBuddyDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, (ILSMComponentFilterManager)this.filterManager, this.treeFields, this.filterFields, MultiComparator.create((IBinaryComparatorFactory[])component.getLSMComponentFilter().getFilterCmpFactories()));
        }
        return new LSMBTreeWithBuddyDiskComponentBulkLoader((LSMBTreeWithBuddyDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, 0L, false);
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, numElementsHint, true);
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-BTree");
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        ExternalBTreeWithBuddyOpContext ctx = (ExternalBTreeWithBuddyOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.getSearchInitialState().setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw HyracksDataException.create((int)36, (Serializable[])new Serializable[0]);
    }

    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        throw HyracksDataException.create((int)36, (Serializable[])new Serializable[0]);
    }

    protected LSMComponentFileReferences getMergeTargetFileName(List<ILSMComponent> mergingDiskComponents) throws HyracksDataException {
        BTree firstTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(0)).getBTree();
        BTree lastTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(mergingDiskComponents.size() - 1)).getBTree();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        LSMComponentFileReferences fileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        return fileRefs;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ExternalBTreeWithBuddyOpContext bctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, 0);
        bctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMBTreeWithBuddySortedCursor cursor = new LSMBTreeWithBuddySortedCursor((ILSMIndexOperationContext)bctx, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)bctx, opCtx -> new LSMBTreeWithBuddySearchCursor(opCtx, this.buddyBTreeFields));
        boolean keepDeleteTuples = false;
        keepDeleteTuples = this.version == 0 ? mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1) : mergingComponents.get(mergingComponents.size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeWithBuddyMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath(), keepDeleteTuples));
    }

    public ExternalBTreeWithBuddyOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalBTreeWithBuddyOpContext(this.btreeCmpFactories, this.buddyBtreeCmpFactories, searchCallback, targetVersion, this.getLsmHarness(), this.btreeInteriorFrameFactory, this.btreeLeafFrameFactory, this.buddyBtreeLeafFrameFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMDiskComponentBulkLoader componentBulkLoader;
        LSMBTreeWithBuddyMergeOperation mergeOp = (LSMBTreeWithBuddyMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        RangePredicate btreeSearchPred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMBTreeWithBuddySortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)btreeSearchPred);
        LSMBTreeWithBuddyDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBuddyBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        if (mergeOp.isKeepDeletedTuples()) {
            LSMBuddyBTreeMergeCursor buddyBtreeCursor = new LSMBuddyBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)buddyBtreeCursor, (ISearchPredicate)btreeSearchPred);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMBTreeWithBuddyDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
            }
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)mergedComponent, 1.0f, false, numElements, false, false, false);
            try {
                while (buddyBtreeCursor.hasNext()) {
                    buddyBtreeCursor.next();
                    ITupleReference tuple = buddyBtreeCursor.getTuple();
                    ((LSMBTreeWithBuddyDiskComponentBulkLoader)componentBulkLoader).delete(tuple);
                }
            }
            finally {
                buddyBtreeCursor.close();
            }
        } else {
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)mergedComponent, 1.0f, false, 0L, false, false, false);
        }
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        componentBulkLoader.end();
        return mergedComponent;
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalBTreeWithBuddyOpContext opCtx = (ExternalBTreeWithBuddyOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)lsmComponent;
        this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        this.markAsValidInternal((ITreeIndex)component.getBTree());
        this.markAsValidInternal((ITreeIndex)component.getBuddyBTree());
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            this.ioOpCallback.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.deactivateDiskComponent(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            if (this.diskComponents.contains(c)) continue;
            this.deactivateDiskComponent(c);
        }
        this.isActive = false;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.btreeLeafFrameFactory;
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.btreeInteriorFrameFactory;
    }

    public IMetadataPageManager getPageManager() {
        return null;
    }

    public int getFieldCount() {
        return this.btreeCmpFactories.length;
    }

    public int getRootPageId() {
        return 0;
    }

    public int getFileId() {
        return 0;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.btreeCmpFactories;
    }

    private LSMBTreeWithBuddyDiskComponent createDiskComponent(ILSMDiskComponentFactory factory, FileReference insertFileRef, FileReference deleteFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)factory.createComponent(new LSMComponentFileReferences(insertFileRef, deleteFileRef, bloomFilterFileRef));
        if (createComponent) {
            component.getBTree().create();
            component.getBuddyBTree().create();
            component.getBloomFilter().create();
        }
        component.getBTree().activate();
        component.getBuddyBTree().activate();
        component.getBloomFilter().activate();
        return component;
    }

    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion), ctx -> new LSMBTreeWithBuddySearchCursor(ctx, this.buddyBTreeFields));
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public void setCurrentVersion(int version) {
        this.version = version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMBTreeWithBuddyDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        ((ExternalIndexHarness)this.getLsmHarness()).addTransactionComponents(component);
    }

    public void abortTransaction() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void recoverTransaction() throws HyracksDataException {
        this.fileManager.recoverTransaction();
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBuddyBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    protected void deactivateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
    }

    protected void deactivateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)c;
        BTree btree = component.getBTree();
        BTree buddyBtree = component.getBuddyBTree();
        BloomFilter bloomFilter = component.getBloomFilter();
        btree.deactivate();
        buddyBtree.deactivate();
        bloomFilter.deactivate();
        btree.purge();
        buddyBtree.purge();
        bloomFilter.purge();
    }

    protected void clearMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
    }

    protected long getMemoryComponentSize(ILSMMemoryComponent c) {
        return 0L;
    }

    protected void validateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM B-Trees with Buddy B-Tree.");
    }

    protected void validateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM B-Trees with Buddy B-Tree.");
    }

    protected void allocateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        return null;
    }

    protected AbstractLSMIndexOperationContext createOpContext(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return null;
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, ILSMMemoryComponent flushingComponent, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return null;
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, List<ILSMComponent> mergingComponents, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return null;
    }

    public class LSMTwoPCBTreeWithBuddyBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader componentBulkLoader;
        private final boolean isTransaction;

        public LSMTwoPCBTreeWithBuddyBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean isTransaction) throws HyracksDataException {
            this.isTransaction = isTransaction;
            this.component = isTransaction ? this.createTransactionTarget() : ExternalBTreeWithBuddy.this.createBulkLoadTarget();
            this.componentBulkLoader = ExternalBTreeWithBuddy.this.createComponentBulkLoader(this.component, fillFactor, verifyInput, numElementsHint, false, true, false);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            this.componentBulkLoader.end();
            if (this.component.getComponentSize() > 0L) {
                if (this.isTransaction) {
                    ExternalBTreeWithBuddy.this.markAsValid(this.component);
                    BTree btree = ((LSMBTreeWithBuddyDiskComponent)this.component).getBTree();
                    BTree buddyBtree = ((LSMBTreeWithBuddyDiskComponent)this.component).getBuddyBTree();
                    BloomFilter bloomFilter = ((LSMBTreeWithBuddyDiskComponent)this.component).getBloomFilter();
                    btree.deactivate();
                    buddyBtree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalBTreeWithBuddy.this.getLsmHarness().addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            ((LSMBTreeWithBuddyDiskComponentBulkLoader)this.componentBulkLoader).delete(tuple);
        }

        public void abort() {
            try {
                this.componentBulkLoader.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalBTreeWithBuddy.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            return ExternalBTreeWithBuddy.this.createDiskComponent(ExternalBTreeWithBuddy.this.bulkComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

