/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class ExternalBTree
extends LSMBTree
implements ITwoPCIndex {
    private static final LSMTreeIndexAccessor.ICursorFactory cursorFactory = opCtx -> new LSMBTreeSearchCursor(opCtx);
    private final LSMBTreeDiskComponentFactory transactionComponentFactory;
    private final List<ILSMDiskComponent> secondDiskComponents;
    private int version = 0;
    private final ITreeIndexFrameFactory interiorFrameFactory;

    public ExternalBTree(IIOManager ioManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, TreeIndexFactory<BTree> transactionBTreeFactory, boolean durable) {
        super(ioManager, insertLeafFrameFactory, deleteLeafFrameFactory, fileManager, diskBTreeFactory, bulkLoadBTreeFactory, bloomFilterFactory, bloomFilterFalsePositiveRate, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallback, false, durable);
        this.transactionComponentFactory = new LSMBTreeDiskComponentFactory(transactionBTreeFactory, bloomFilterFactory, null);
        this.secondDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.interiorFrameFactory = interiorFrameFactory;
    }

    public ExternalIndexHarness getLsmHarness() {
        return (ExternalIndexHarness)super.getLsmHarness();
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public List<ILSMDiskComponent> getImmutableComponents() {
        if (this.version == 0) {
            return this.diskComponents;
        }
        if (this.version == 1) {
            return this.secondDiskComponents;
        }
        return Collections.emptyList();
    }

    @Override
    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        ExternalBTreeOpContext ctx = (ExternalBTreeOpContext)ictx;
        List operationalComponents = ctx.getComponentHolder();
        ctx.getSearchInitialState().reset(pred, operationalComponents);
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public ExternalBTreeOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalBTreeOpContext(this.insertLeafFrameFactory, this.deleteLeafFrameFactory, searchCallback, this.componentFactory.getBloomFilterKeyFields().length, this.cmpFactories, targetVersion, (ILSMHarness)this.getLsmHarness());
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ExternalBTreeOpContext opCtx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, -1);
        opCtx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        boolean returnDeletedTuples = false;
        if (this.version == 0) {
            if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
                returnDeletedTuples = true;
            }
        } else if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMBTreeRangeSearchCursor cursor = new LSMBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        BTree firstBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(0))).getBTree();
        BTree lastBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(mergingComponents.size() - 1))).getBTree();
        FileReference firstFile = firstBTree.getFileReference();
        FileReference lastFile = lastBTree.getFileReference();
        LSMComponentFileReferences relMergeFileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, (ITreeIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath()));
    }

    public void deleteTransactionComponent() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMBTreeDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            this.getLsmHarness().indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree btree;
            LSMBTreeDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMBTreeDiskComponent)iLSMComponent;
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMBTreeDiskComponent)iLSMComponent;
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                bloomFilter.activate();
            }
        }
        this.isActive = true;
    }

    public synchronized void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            cb.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.deactivateDiskComponent(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            if (this.diskComponents.contains(c)) continue;
            this.deactivateDiskComponent(c);
        }
        this.isActive = false;
    }

    public void clear() throws HyracksDataException {
        LSMBTreeDiskComponent component;
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.getLsmHarness().indexClear();
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = 0;
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.destroyDiskComponent(c);
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            this.destroyDiskComponent(c);
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = 0;
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-BTree");
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    @Override
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalBTreeOpContext opCtx = (ExternalBTreeOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeBulkLoader(fillLevel, verifyInput, numElementsHint, false);
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeBulkLoader(fillLevel, verifyInput, numElementsHint, true);
    }

    @Override
    public String toString() {
        return "LSMTwoPCBTree [" + this.fileManager.getBaseDir() + "]";
    }

    @Override
    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        ExternalBTreeOpContext opCtx = this.createOpContext(searchCallback, this.version);
        return new LSMTreeIndexAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        ExternalBTreeOpContext opCtx = this.createOpContext(searchCallback, targetIndexVersion);
        return new LSMTreeIndexAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public int getFieldCount() {
        return this.cmpFactories.length;
    }

    @Override
    public int getFileId() {
        return -1;
    }

    public IMetadataPageManager getPageManager() {
        return null;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.insertLeafFrameFactory;
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public void setCurrentVersion(int version) {
        this.version = version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMBTreeDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        this.getLsmHarness().addTransactionComponents(component);
    }

    public void abortTransaction() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void recoverTransaction() throws HyracksDataException {
        this.fileManager.recoverTransaction();
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    public class LSMTwoPCBTreeBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final ILSMDiskComponentBulkLoader componentBulkLoader;
        private final boolean isTransaction;

        public LSMTwoPCBTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean isTransaction) throws HyracksDataException {
            this.isTransaction = isTransaction;
            this.component = isTransaction ? this.createTransactionTarget() : ExternalBTree.this.createBulkLoadTarget();
            this.componentBulkLoader = ExternalBTree.this.createComponentBulkLoader(this.component, fillFactor, verifyInput, numElementsHint, false, true, true);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            this.componentBulkLoader.end();
            if (this.component.getComponentSize() > 0L) {
                if (this.isTransaction) {
                    ExternalBTree.this.markAsValid(this.component);
                    BTree btree = ((LSMBTreeDiskComponent)this.component).getBTree();
                    BloomFilter bloomFilter = ((LSMBTreeDiskComponent)this.component).getBloomFilter();
                    btree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalBTree.this.getLsmHarness().addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.delete(tuple);
        }

        public void abort() {
            try {
                this.componentBulkLoader.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalBTree.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            return ExternalBTree.this.createDiskComponent(ExternalBTree.this.transactionComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

