/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.sort.IFrameSorter;
import org.apache.hyracks.util.IntSerDeUtils;

public abstract class AbstractFrameSorter
implements IFrameSorter {
    protected Logger LOGGER = Logger.getLogger(AbstractFrameSorter.class.getName());
    static final int PTR_SIZE = 4;
    static final int ID_FRAMEID = 0;
    static final int ID_TUPLE_START = 1;
    static final int ID_TUPLE_END = 2;
    static final int ID_NORMAL_KEY = 3;
    protected final int[] sortFields;
    protected final IBinaryComparator[] comparators;
    protected final INormalizedKeyComputer nkc;
    protected final IFrameBufferManager bufferManager;
    protected final FrameTupleAccessor inputTupleAccessor;
    protected final IFrameTupleAppender outputAppender;
    protected final IFrame outputFrame;
    protected final int outputLimit;
    protected int[] tPointers;
    protected int tupleCount;
    private FrameTupleAccessor fta2;
    private BufferInfo info = new BufferInfo(null, -1, -1);

    public AbstractFrameSorter(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this(ctx, bufferManager, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDescriptor, Integer.MAX_VALUE);
    }

    public AbstractFrameSorter(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int outputLimit) throws HyracksDataException {
        this.bufferManager = bufferManager;
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.inputTupleAccessor = new FrameTupleAccessor(recordDescriptor);
        this.outputAppender = new FrameTupleAppender();
        this.outputFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.outputLimit = outputLimit;
        this.fta2 = new FrameTupleAccessor(recordDescriptor);
    }

    @Override
    public void reset() throws HyracksDataException {
        this.tupleCount = 0;
        this.bufferManager.reset();
    }

    @Override
    public boolean insertFrame(ByteBuffer inputBuffer) throws HyracksDataException {
        if (this.bufferManager.insertFrame(inputBuffer) >= 0) {
            return true;
        }
        if (this.getFrameCount() == 0) {
            throw new HyracksDataException("The input frame is too big for the sorting buffer, please allocate bigger buffer size");
        }
        return false;
    }

    @Override
    public void sort() throws HyracksDataException {
        this.tupleCount = 0;
        for (int i = 0; i < this.bufferManager.getNumFrames(); ++i) {
            this.bufferManager.getFrame(i, this.info);
            this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
            this.tupleCount += this.inputTupleAccessor.getTupleCount();
        }
        if (this.tPointers == null || this.tPointers.length < this.tupleCount * 4) {
            this.tPointers = new int[this.tupleCount * 4];
        }
        int ptr = 0;
        int sfIdx = this.sortFields[0];
        for (int i = 0; i < this.bufferManager.getNumFrames(); ++i) {
            this.bufferManager.getFrame(i, this.info);
            this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
            int tCount = this.inputTupleAccessor.getTupleCount();
            byte[] array = this.inputTupleAccessor.getBuffer().array();
            for (int j = 0; j < tCount; ++j) {
                int tStart = this.inputTupleAccessor.getTupleStartOffset(j);
                int tEnd = this.inputTupleAccessor.getTupleEndOffset(j);
                this.tPointers[ptr * 4 + 0] = i;
                this.tPointers[ptr * 4 + 1] = tStart;
                this.tPointers[ptr * 4 + 2] = tEnd;
                int f0StartRel = this.inputTupleAccessor.getFieldStartOffset(j, sfIdx);
                int f0EndRel = this.inputTupleAccessor.getFieldEndOffset(j, sfIdx);
                int f0Start = f0StartRel + tStart + this.inputTupleAccessor.getFieldSlotsLength();
                this.tPointers[ptr * 4 + 3] = this.nkc == null ? 0 : this.nkc.normalize(array, f0Start, f0EndRel - f0StartRel);
                ++ptr;
            }
        }
        if (this.tupleCount > 0) {
            this.sortTupleReferences();
        }
    }

    abstract void sortTupleReferences() throws HyracksDataException;

    @Override
    public int getFrameCount() {
        return this.bufferManager.getNumFrames();
    }

    @Override
    public boolean hasRemaining() {
        return this.getFrameCount() > 0;
    }

    @Override
    public int flush(IFrameWriter writer) throws HyracksDataException {
        this.outputAppender.reset(this.outputFrame, true);
        int maxFrameSize = this.outputFrame.getFrameSize();
        int limit = Math.min(this.tupleCount, this.outputLimit);
        int io = 0;
        for (int ptr = 0; ptr < limit; ++ptr) {
            int i = this.tPointers[ptr * 4 + 0];
            int tStart = this.tPointers[ptr * 4 + 1];
            int tEnd = this.tPointers[ptr * 4 + 2];
            this.bufferManager.getFrame(i, this.info);
            this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
            int flushed = FrameUtils.appendToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.outputAppender, (IFrameTupleAccessor)this.inputTupleAccessor, (int)tStart, (int)tEnd);
            if (flushed <= 0) continue;
            maxFrameSize = Math.max(maxFrameSize, flushed);
            ++io;
        }
        maxFrameSize = Math.max(maxFrameSize, this.outputFrame.getFrameSize());
        this.outputAppender.write(writer, true);
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.fine("Flushed records:" + limit + " out of " + this.tupleCount + "; Flushed through " + (io + 1) + " frames");
        }
        return maxFrameSize;
    }

    protected final int compare(int tp1, int tp2) throws HyracksDataException {
        int i1 = this.tPointers[tp1 * 4 + 0];
        int j1 = this.tPointers[tp1 * 4 + 1];
        int v1 = this.tPointers[tp1 * 4 + 3];
        int tp2i = this.tPointers[tp2 * 4 + 0];
        int tp2j = this.tPointers[tp2 * 4 + 1];
        int tp2v = this.tPointers[tp2 * 4 + 3];
        if (v1 != tp2v) {
            return ((long)v1 & 0xFFFFFFFFL) < ((long)tp2v & 0xFFFFFFFFL) ? -1 : 1;
        }
        int i2 = tp2i;
        int j2 = tp2j;
        this.bufferManager.getFrame(i1, this.info);
        byte[] b1 = this.info.getBuffer().array();
        this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
        this.bufferManager.getFrame(i2, this.info);
        byte[] b2 = this.info.getBuffer().array();
        this.fta2.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])b1, (int)(j1 + (fIdx - 1) * 4));
            int f1End = IntSerDeUtils.getInt((byte[])b1, (int)(j1 + fIdx * 4));
            int s1 = j1 + this.inputTupleAccessor.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])b2, (int)(j2 + (fIdx - 1) * 4));
            int f2End = IntSerDeUtils.getInt((byte[])b2, (int)(j2 + fIdx * 4));
            int s2 = j2 + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public void close() {
        this.tupleCount = 0;
        this.bufferManager.close();
        this.tPointers = null;
    }
}

