/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class FrameFileWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private IFileSplitProvider fileSplitProvider;

    public FrameFileWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider) {
        super(spec, 1, 0);
        this.fileSplitProvider = fileSplitProvider;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
        final FileSplit[] splits = this.fileSplitProvider.getFileSplits();
        final IIOManager ioManager = ctx.getIoManager();
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private OutputStream out;

            public void open() throws HyracksDataException {
                try {
                    this.out = new FileOutputStream(splits[partition].getFile(ioManager));
                }
                catch (FileNotFoundException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    this.out.write(buffer.array());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void fail() throws HyracksDataException {
            }

            public void close() throws HyracksDataException {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

