/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class TreeTupleSorter
implements ITreeIndexCursor {
    private static final int INITIAL_SIZE = 1000000;
    private int numTuples;
    private int currentTupleIndex;
    private int[] tPointers;
    private IBufferCache bufferCache;
    private final ITreeIndexFrame leafFrame1;
    private final ITreeIndexFrame leafFrame2;
    private ITreeIndexTupleReference frameTuple1;
    private ITreeIndexTupleReference frameTuple2;
    private final int fileId;
    private static final int ARRAY_GROWTH = 1000000;
    private final int[] comparatorFields;
    private final MultiComparator cmp;

    public TreeTupleSorter(int fileId, IBinaryComparatorFactory[] comparatorFactories, ITreeIndexFrame leafFrame1, ITreeIndexFrame leafFrame2, IBufferCache bufferCache, int[] comparatorFields) {
        this.fileId = fileId;
        this.leafFrame1 = leafFrame1;
        this.leafFrame2 = leafFrame2;
        this.bufferCache = bufferCache;
        this.comparatorFields = comparatorFields;
        this.tPointers = new int[2000000];
        this.frameTuple1 = leafFrame1.createTupleReference();
        this.frameTuple2 = leafFrame2.createTupleReference();
        this.currentTupleIndex = 0;
        this.cmp = MultiComparator.create((IBinaryComparatorFactory[])comparatorFactories);
    }

    public void reset() {
        this.numTuples = 0;
        this.currentTupleIndex = 0;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.numTuples <= this.currentTupleIndex) {
            return false;
        }
        ICachedPage node1 = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.tPointers[this.currentTupleIndex * 2]), false);
        try {
            this.leafFrame1.setPage(node1);
            this.frameTuple1.resetByTupleOffset(this.leafFrame1.getBuffer().array(), this.tPointers[this.currentTupleIndex * 2 + 1]);
        }
        finally {
            this.bufferCache.unpin(node1);
        }
        return true;
    }

    public void next() {
        ++this.currentTupleIndex;
    }

    public ITupleReference getTuple() {
        return this.frameTuple1;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public void insertTupleEntry(int pageId, int tupleOffset) {
        if (this.numTuples * 2 == this.tPointers.length) {
            int[] newData = new int[this.tPointers.length + 1000000];
            System.arraycopy(this.tPointers, 0, newData, 0, this.tPointers.length);
            this.tPointers = newData;
        }
        this.tPointers[this.numTuples * 2] = pageId;
        this.tPointers[this.numTuples * 2 + 1] = tupleOffset;
        ++this.numTuples;
    }

    public void sort() throws HyracksDataException {
        this.sort(this.tPointers, 0, this.numTuples);
    }

    private void sort(int[] tPointers, int offset, int length) throws HyracksDataException {
        int c;
        int a;
        int m = offset + (length >> 1);
        int mi = tPointers[m * 2];
        int mj = tPointers[m * 2 + 1];
        int b = a = offset;
        int d = c = offset + length - 1;
        while (true) {
            int cmp;
            if (b <= c && (cmp = this.compare(tPointers, b, mi, mj)) <= 0) {
                if (cmp == 0) {
                    this.swap(tPointers, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (cmp = this.compare(tPointers, c, mi, mj)) >= 0) {
                if (cmp == 0) {
                    this.swap(tPointers, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(tPointers, b++, c--);
        }
        int n = offset + length;
        int s = Math.min(a - offset, b - a);
        this.vecswap(tPointers, offset, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(tPointers, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(tPointers, offset, s);
        }
        if ((s = d - c) > 1) {
            this.sort(tPointers, n - s, s);
        }
    }

    private void swap(int[] x, int a, int b) {
        for (int i = 0; i < 2; ++i) {
            int t = x[a * 2 + i];
            x[a * 2 + i] = x[b * 2 + i];
            x[b * 2 + i] = t;
        }
    }

    private void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compare(int[] tPointers, int tp1, int tp2i, int tp2j) throws HyracksDataException {
        int i1 = tPointers[tp1 * 2];
        int j1 = tPointers[tp1 * 2 + 1];
        int i2 = tp2i;
        int j2 = tp2j;
        ICachedPage node1 = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)i1), false);
        this.leafFrame1.setPage(node1);
        ICachedPage node2 = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)i2), false);
        this.leafFrame2.setPage(node2);
        try {
            this.frameTuple1.resetByTupleOffset(this.leafFrame1.getBuffer().array(), j1);
            this.frameTuple2.resetByTupleOffset(this.leafFrame2.getBuffer().array(), j2);
            int n = this.cmp.selectiveFieldCompare((ITupleReference)this.frameTuple1, (ITupleReference)this.frameTuple2, this.comparatorFields);
            return n;
        }
        finally {
            this.bufferCache.unpin(node1);
            this.bufferCache.unpin(node2);
        }
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
    }

    public void close() throws HyracksDataException {
    }

    public void setBufferCache(IBufferCache bufferCache) {
    }

    public void setFileId(int fileId) {
    }

    public boolean isExclusiveLatchNodes() {
        return false;
    }
}

