/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.MergeOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.AbstractLSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesFlushCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMRTreeWithAntiMatterTuples
extends AbstractLSMRTree {
    private static final LSMTreeIndexAccessor.ICursorFactory cursorFactory = opCtx -> new LSMRTreeWithAntiMatterTuplesSearchCursor(opCtx);
    private final ILSMDiskComponentFactory bulkLoaComponentFactory;

    public LSMRTreeWithAntiMatterTuples(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<RTree> bulkLoadRTreeFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeComparatorFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileManager, new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(diskRTreeFactory, filterHelper), fieldCount, rtreeCmpFactories, btreeComparatorFactories, linearizer, comparatorFields, linearizerArray, 0.0, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterHelper, filterFrameFactory, filterManager, rtreeFields, filterFields, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.bulkLoaComponentFactory = new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(bulkLoadRTreeFactory, filterHelper);
    }

    protected ILSMDiskComponent loadComponent(LSMComponentFileReferences refs) throws HyracksDataException {
        return this.createDiskComponent(this.componentFactory, refs.getInsertIndexFileReference(), null, null, false);
    }

    protected void deactivateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        RTree rtree = ((LSMRTreeDiskComponent)c).getRTree();
        rtree.deactivate();
        rtree.purge();
    }

    protected void destroyDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        ((LSMRTreeDiskComponent)c).getRTree().destroy();
    }

    protected void clearDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        RTree rtree = ((LSMRTreeDiskComponent)c).getRTree();
        rtree.deactivate();
        rtree.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        LSMRTreeFlushOperation flushOp = (LSMRTreeFlushOperation)operation;
        LSMRTreeMemoryComponent flushingComponent = (LSMRTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor memRTreeAccessor = flushingComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RTreeSearchCursor rtreeScanCursor = (RTreeSearchCursor)memRTreeAccessor.createSearchCursor(false);
        SearchPredicate rtreeNullPredicate = new SearchPredicate(null, null);
        memRTreeAccessor.search((IIndexCursor)rtreeScanCursor, (ISearchPredicate)rtreeNullPredicate);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), null, null, true);
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, 0L, false, false, false);
        TreeTupleSorter rTreeTupleSorter = new TreeTupleSorter(flushingComponent.getRTree().getFileId(), this.linearizerArray, this.rtreeLeafFrameFactory.createFrame(), this.rtreeLeafFrameFactory.createFrame(), flushingComponent.getRTree().getBufferCache(), this.comparatorFields);
        boolean isEmpty = true;
        try {
            while (rtreeScanCursor.hasNext()) {
                isEmpty = false;
                rtreeScanCursor.next();
                rTreeTupleSorter.insertTupleEntry(rtreeScanCursor.getPageId(), rtreeScanCursor.getTupleOffset());
            }
        }
        finally {
            rtreeScanCursor.close();
        }
        if (!isEmpty) {
            rTreeTupleSorter.sort();
        }
        ITreeIndexAccessor memBTreeAccessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        BTreeRangeSearchCursor btreeScanCursor = (BTreeRangeSearchCursor)memBTreeAccessor.createSearchCursor(false);
        RangePredicate btreeNullPredicate = new RangePredicate(null, null, true, true, null, null);
        memBTreeAccessor.search((IIndexCursor)btreeScanCursor, (ISearchPredicate)btreeNullPredicate);
        TreeTupleSorter bTreeTupleSorter = new TreeTupleSorter(flushingComponent.getBTree().getFileId(), this.linearizerArray, this.btreeLeafFrameFactory.createFrame(), this.btreeLeafFrameFactory.createFrame(), flushingComponent.getBTree().getBufferCache(), this.comparatorFields);
        isEmpty = true;
        try {
            while (btreeScanCursor.hasNext()) {
                isEmpty = false;
                btreeScanCursor.next();
                bTreeTupleSorter.insertTupleEntry(btreeScanCursor.getPageId(), btreeScanCursor.getTupleOffset());
            }
        }
        finally {
            btreeScanCursor.close();
        }
        if (!isEmpty) {
            bTreeTupleSorter.sort();
        }
        cursor.open(null, null);
        try (LSMRTreeWithAntiMatterTuplesFlushCursor cursor = new LSMRTreeWithAntiMatterTuplesFlushCursor(rTreeTupleSorter, bTreeTupleSorter, this.comparatorFields, this.linearizerArray);){
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        MergeOperation mergeOp = (MergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), null, null, true);
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, 0L, false, false, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple());
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple());
            }
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        componentBulkLoader.end();
        return component;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        LSMRTreeOpContext opCtx = this.createOpContext(modificationCallback, searchCallback);
        return new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    public ILSMDiskComponentBulkLoader createComponentBulkLoader(ILSMDiskComponent component, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        if (withFilter && this.filterFields != null) {
            return new LSMRTreeWithAntiMatterTuplesDiskComponentBulkLoader((LSMRTreeDiskComponent)component, null, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, (ILSMComponentFilterManager)this.filterManager, this.treeFields, this.filterFields, MultiComparator.create((IBinaryComparatorFactory[])component.getLSMComponentFilter().getFilterCmpFactories()));
        }
        return new LSMRTreeWithAntiMatterTuplesDiskComponentBulkLoader((LSMRTreeDiskComponent)component, null, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMRTreeWithAntiMatterTuplesBulkLoader(fillLevel, verifyInput, numElementsHint);
    }

    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences relFlushFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkLoaComponentFactory, relFlushFileRefs.getInsertIndexFileReference(), null, null, true);
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        RTree rtree = ((LSMRTreeDiskComponent)lsmComponent).getRTree();
        this.markAsValidInternal((ITreeIndex)rtree);
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        RTree rtree = ((LSMRTreeDiskComponent)lsmComponent).getRTree();
        files.add(rtree.getFileReference().getFile().getAbsolutePath());
        return files;
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, ILSMMemoryComponent flushingComponent, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
        return new LSMRTreeFlushOperation((ILSMIndexAccessor)accessor, flushingComponent, componentFileRefs.getInsertIndexFileReference(), null, null, callback, this.fileManager.getBaseDir().getAbsolutePath());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, List<ILSMComponent> mergingComponents, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        boolean returnDeletedTuples = false;
        if (mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMRTreeWithAntiMatterTuplesSearchCursor cursor = new LSMRTreeWithAntiMatterTuplesSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
        return new MergeOperation((ILSMIndexAccessor)accessor, mergeFileRefs.getInsertIndexFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath(), mergingComponents, (IIndexCursor)cursor);
    }

    public class LSMRTreeWithAntiMatterTuplesBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader componentBulkLoader;

        public LSMRTreeWithAntiMatterTuplesBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
            this.component = LSMRTreeWithAntiMatterTuples.this.createBulkLoadTarget();
            this.componentBulkLoader = LSMRTreeWithAntiMatterTuples.this.createComponentBulkLoader(this.component, fillFactor, verifyInput, numElementsHint, false, true, true);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            this.componentBulkLoader.end();
            if (this.component.getComponentSize() > 0L) {
                LSMRTreeWithAntiMatterTuples.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                LSMRTreeWithAntiMatterTuples.this.lsmHarness.addBulkLoadedComponent(this.component);
            }
        }

        public void abort() throws HyracksDataException {
            if (this.componentBulkLoader != null) {
                this.componentBulkLoader.abort();
            }
        }
    }
}

