/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeOpContext;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public final class LSMRTreeOpContext
extends AbstractLSMIndexOperationContext {
    private RTree.RTreeAccessor[] mutableRTreeAccessors;
    private RTree.RTreeAccessor currentMutableRTreeAccessor;
    private BTree.BTreeAccessor[] mutableBTreeAccessors;
    private BTree.BTreeAccessor currentMutableBTreeAccessor;
    private RTreeOpContext[] rtreeOpContexts;
    private BTreeOpContext[] btreeOpContexts;
    private RTreeOpContext currentRTreeOpContext;
    private BTreeOpContext currentBTreeOpContext;
    private LSMRTreeCursorInitialState searchInitialState;

    public LSMRTreeOpContext(List<ILSMMemoryComponent> mutableComponents, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int[] rtreeFields, int[] filterFields, ILSMHarness lsmHarness, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, IBinaryComparatorFactory[] filterComparatorFactories) {
        super(rtreeFields, filterFields, filterComparatorFactories, searchCallback, modificationCallback);
        this.mutableRTreeAccessors = new RTree.RTreeAccessor[mutableComponents.size()];
        this.mutableBTreeAccessors = new BTree.BTreeAccessor[mutableComponents.size()];
        this.rtreeOpContexts = new RTreeOpContext[mutableComponents.size()];
        this.btreeOpContexts = new BTreeOpContext[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)mutableComponents.get(i);
            this.mutableRTreeAccessors[i] = this.allFields != null ? (RTree.RTreeAccessor)mutableComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE, this.allFields) : (RTree.RTreeAccessor)mutableComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.mutableBTreeAccessors[i] = (BTree.BTreeAccessor)mutableComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.rtreeOpContexts[i] = this.mutableRTreeAccessors[i].getOpContext();
            this.btreeOpContexts[i] = this.mutableBTreeAccessors[i].getOpContext();
        }
        this.currentRTreeOpContext = this.rtreeOpContexts[0];
        this.currentBTreeOpContext = this.btreeOpContexts[0];
        this.searchInitialState = new LSMRTreeCursorInitialState(rtreeLeafFrameFactory, rtreeInteriorFrameFactory, btreeLeafFrameFactory, this.getBTreeMultiComparator(), lsmHarness, comparatorFields, linearizerArray, searchCallback, this.componentHolder);
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableRTreeAccessor = this.mutableRTreeAccessors[currentMutableComponentId];
        this.currentMutableBTreeAccessor = this.mutableBTreeAccessors[currentMutableComponentId];
        this.currentRTreeOpContext = this.rtreeOpContexts[currentMutableComponentId];
        this.currentBTreeOpContext = this.btreeOpContexts[currentMutableComponentId];
        if (this.op == IndexOperation.INSERT) {
            this.currentRTreeOpContext.setOperation(this.op);
        } else if (this.op == IndexOperation.DELETE) {
            this.currentBTreeOpContext.setOperation(IndexOperation.INSERT);
        }
    }

    public MultiComparator getBTreeMultiComparator() {
        return this.currentBTreeOpContext.getCmp();
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public LSMRTreeCursorInitialState getSearchInitialState() {
        return this.searchInitialState;
    }

    public RTree.RTreeAccessor getCurrentMutableRTreeAccessor() {
        return this.currentMutableRTreeAccessor;
    }

    public BTree.BTreeAccessor getCurrentMutableBTreeAccessor() {
        return this.currentMutableBTreeAccessor;
    }

    public RTreeOpContext getCurrentRTreeOpContext() {
        return this.currentRTreeOpContext;
    }
}

