/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.DualTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.AbstractLSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAccessor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeBulkLoader;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSortedCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMRTree
extends AbstractLSMRTree {
    protected final int[] buddyBTreeFields;

    public LSMRTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] rtreeFields, int[] buddyBTreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, new LSMRTreeDiskComponentFactory(diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, filterHelper), fieldCount, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterHelper, filterFrameFactory, filterManager, rtreeFields, filterFields, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.buddyBTreeFields = buddyBTreeFields;
    }

    public LSMRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] buddyBTreeFields, boolean durable, boolean isPointMBR) {
        super(ioManager, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, new LSMRTreeDiskComponentFactory(diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, null), rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.buddyBTreeFields = buddyBTreeFields;
    }

    protected ILSMDiskComponent loadComponent(LSMComponentFileReferences lsmComonentFileReferences) throws HyracksDataException {
        return this.createDiskComponent(this.componentFactory, lsmComonentFileReferences.getInsertIndexFileReference(), lsmComonentFileReferences.getDeleteIndexFileReference(), lsmComonentFileReferences.getBloomFilterFileReference(), false);
    }

    protected void deactivateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
        RTree rtree = component.getRTree();
        BTree btree = component.getBTree();
        BloomFilter bloomFilter = component.getBloomFilter();
        rtree.deactivate();
        btree.deactivate();
        bloomFilter.deactivate();
        rtree.purge();
        btree.purge();
        bloomFilter.purge();
    }

    protected void destroyDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
        component.getBTree().destroy();
        component.getBloomFilter().destroy();
        component.getRTree().destroy();
    }

    protected void clearDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
        component.getBTree().deactivate();
        component.getBloomFilter().deactivate();
        component.getRTree().deactivate();
        component.getBTree().destroy();
        component.getBloomFilter().destroy();
        component.getRTree().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        LSMRTreeFlushOperation flushOp = (LSMRTreeFlushOperation)operation;
        LSMRTreeMemoryComponent flushingComponent = (LSMRTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor memRTreeAccessor = flushingComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RTreeSearchCursor rtreeScanCursor = (RTreeSearchCursor)memRTreeAccessor.createSearchCursor(false);
        SearchPredicate rtreeNullPredicate = new SearchPredicate(null, null);
        memRTreeAccessor.search((IIndexCursor)rtreeScanCursor, (ISearchPredicate)rtreeNullPredicate);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), flushOp.getBTreeTarget(), flushOp.getBloomFilterTarget(), true);
        ITreeIndexAccessor memBTreeAccessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RangePredicate btreeNullPredicate = new RangePredicate(null, null, true, true, null, null);
        ITreeIndexCursor btreeCountingCursor = ((BTree.BTreeAccessor)memBTreeAccessor).createCountingSearchCursor();
        memBTreeAccessor.search((IIndexCursor)btreeCountingCursor, (ISearchPredicate)btreeNullPredicate);
        long numBTreeTuples = 0L;
        try {
            while (btreeCountingCursor.hasNext()) {
                btreeCountingCursor.next();
                ITupleReference countTuple = btreeCountingCursor.getTuple();
                numBTreeTuples = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
            }
        }
        finally {
            btreeCountingCursor.close();
        }
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, numBTreeTuples, false, false, false);
        IBinaryComparatorFactory[] linearizerArray = new IBinaryComparatorFactory[]{this.linearizer};
        TreeTupleSorter rTreeTupleSorter = new TreeTupleSorter(flushingComponent.getRTree().getFileId(), linearizerArray, this.rtreeLeafFrameFactory.createFrame(), this.rtreeLeafFrameFactory.createFrame(), flushingComponent.getRTree().getBufferCache(), this.comparatorFields);
        boolean isEmpty = true;
        try {
            while (rtreeScanCursor.hasNext()) {
                isEmpty = false;
                rtreeScanCursor.next();
                rTreeTupleSorter.insertTupleEntry(rtreeScanCursor.getPageId(), rtreeScanCursor.getTupleOffset());
            }
        }
        finally {
            rtreeScanCursor.close();
        }
        rTreeTupleSorter.sort();
        TreeTupleSorter cursor = rTreeTupleSorter;
        if (!isEmpty) {
            try {
                while (cursor.hasNext()) {
                    cursor.next();
                    ITupleReference frameTuple = cursor.getTuple();
                    componentBulkLoader.add(frameTuple);
                }
            }
            finally {
                cursor.close();
            }
        }
        memBTreeAccessor.search(btreeScanCursor, (ISearchPredicate)btreeNullPredicate);
        try (IIndexCursor btreeScanCursor = memBTreeAccessor.createSearchCursor(false);){
            while (btreeScanCursor.hasNext()) {
                btreeScanCursor.next();
                ITupleReference frameTuple = btreeScanCursor.getTuple();
                componentBulkLoader.delete(frameTuple);
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMDiskComponentBulkLoader componentBulkLoader;
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMRTreeSortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        if (mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMRTreeDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
            }
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)mergedComponent, 1.0f, false, numElements, false, false, false);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)rtreeSearchPred);
            try (LSMRTreeDeletedKeysBTreeMergeCursor btreeCursor = new LSMRTreeDeletedKeysBTreeMergeCursor(opCtx);){
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    componentBulkLoader.delete(tuple);
                }
            }
        } else {
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)mergedComponent, 1.0f, false, 0L, false, false, false);
        }
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        if (mergedComponent.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple());
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple());
            }
            this.getFilterManager().updateFilter(mergedComponent.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(mergedComponent.getLSMComponentFilter(), (ITreeIndex)mergedComponent.getRTree());
        }
        componentBulkLoader.end();
        return mergedComponent;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback), this.buddyBTreeFields);
    }

    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public ILSMDiskComponentBulkLoader createComponentBulkLoader(ILSMDiskComponent component, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        BloomFilterSpecification bloomFilterSpec = null;
        if (numElementsHint > 0L) {
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        if (withFilter && this.filterFields != null) {
            return new LSMRTreeDiskComponentBulkLoader((LSMRTreeDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, (ILSMComponentFilterManager)this.filterManager, this.treeFields, this.filterFields, MultiComparator.create((IBinaryComparatorFactory[])component.getLSMComponentFilter().getFilterCmpFactories()));
        }
        return new LSMRTreeDiskComponentBulkLoader((LSMRTreeDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMRTreeBulkLoader(this, fillLevel, verifyInput, numElementsHint);
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        LSMRTreeOpContext ctx;
        block7: {
            ITupleReference indexTuple;
            ctx = (LSMRTreeOpContext)ictx;
            if (ctx.getOperation() == IndexOperation.PHYSICALDELETE) {
                throw new UnsupportedOperationException("Physical delete not supported in the LSM-RTree");
            }
            if (ctx.getIndexTuple() != null) {
                ctx.getIndexTuple().reset(tuple);
                indexTuple = ctx.getIndexTuple();
                ctx.getCurrentMutableRTreeAccessor().getOpContext().resetNonIndexFieldsTuple(tuple);
            } else {
                indexTuple = tuple;
            }
            ctx.getModificationCallback().before(indexTuple);
            ctx.getModificationCallback().found(null, indexTuple);
            if (ctx.getOperation() == IndexOperation.INSERT) {
                ctx.getCurrentMutableRTreeAccessor().insert(indexTuple);
            } else {
                ctx.getCurrentMutableRTreeAccessor().delete(indexTuple);
                try {
                    ctx.getCurrentMutableBTreeAccessor().insert((ITupleReference)((DualTupleReference)tuple).getPermutingTuple());
                }
                catch (HyracksDataException e) {
                    if (e.getErrorCode() == 33) break block7;
                    throw e;
                }
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)lsmComponent;
        this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        this.markAsValidInternal((ITreeIndex)component.getBTree());
        this.markAsValidInternal((ITreeIndex)component.getRTree());
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getRTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, ILSMMemoryComponent flushingComponent, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMRTreeAccessor accessor = new LSMRTreeAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, this.buddyBTreeFields);
        return new LSMRTreeFlushOperation((ILSMIndexAccessor)accessor, flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, List<ILSMComponent> mergingComponents, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMRTreeSortedCursor cursor = new LSMRTreeSortedCursor((ILSMIndexOperationContext)opCtx, this.linearizer, this.buddyBTreeFields);
        LSMRTreeAccessor accessor = new LSMRTreeAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx, this.buddyBTreeFields);
        return new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, mergeFileRefs.getInsertIndexFileReference(), mergeFileRefs.getDeleteIndexFileReference(), mergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }
}

