/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.ExternalRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAccessor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSortedCursor;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class ExternalRTree
extends LSMRTree
implements ITwoPCIndex {
    private final List<ILSMDiskComponent> secondDiskComponents = new LinkedList<ILSMDiskComponent>();
    private int version = 0;
    private final int fieldCount;

    public ExternalRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] buddyBTreeFields, boolean durable, boolean isPointMBR) {
        super(ioManager, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, bloomFilterFalsePositiveRate, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallback, buddyBTreeFields, durable, isPointMBR);
        this.fieldCount = fieldCount;
    }

    public ExternalIndexHarness getLsmHarness() {
        return (ExternalIndexHarness)super.getLsmHarness();
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public List<ILSMDiskComponent> getImmutableComponents() {
        if (this.version == 0) {
            return this.diskComponents;
        }
        return this.secondDiskComponents;
    }

    public void deleteTransactionComponent() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            this.getLsmHarness().indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree btree;
            RTree rtree;
            LSMRTreeDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMRTreeDiskComponent)iLSMComponent;
                rtree = component.getRTree();
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                rtree.activate();
                btree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMRTreeDiskComponent)iLSMComponent;
                rtree = component.getRTree();
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                rtree.activate();
                btree.activate();
                bloomFilter.activate();
            }
        }
        this.isActive = true;
    }

    public synchronized void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    @Override
    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        ExternalRTreeOpContext ctx = (ExternalRTreeOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.getInitialState().setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.getInitialState(), pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMRTreeSortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        boolean keepDeleteTuples = false;
        if (this.version == 0) {
            keepDeleteTuples = mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1);
        } else {
            boolean bl = keepDeleteTuples = mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        }
        if (keepDeleteTuples) {
            LSMRTreeDeletedKeysBTreeMergeCursor btreeCursor = new LSMRTreeDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)rtreeSearchPred);
            BTree btree = mergedComponent.getBTree();
            IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMRTreeDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    btreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                btreeCursor.close();
                builder.end();
            }
            btreeBulkLoader.end();
        }
        IIndexBulkLoader bulkLoader = mergedComponent.getRTree().createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        bulkLoader.end();
        return mergedComponent;
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            cb.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.deactivateDiskComponent(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            if (this.diskComponents.contains(c)) continue;
            this.deactivateDiskComponent(c);
        }
        this.isActive = false;
    }

    public void clear() throws HyracksDataException {
        LSMRTreeDiskComponent component;
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.getLsmHarness().indexClear();
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getRTree().destroy();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getRTree().destroy();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = 0;
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            this.destroyDiskComponent(c);
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            this.destroyDiskComponent(c);
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = 0;
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-RTree");
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    @Override
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalRTreeOpContext opCtx = (ExternalRTreeOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, 0L, false);
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, numElementsHint, true);
    }

    @Override
    public String toString() {
        return "LSMTwoPCRTree [" + this.fileManager.getBaseDir() + "]";
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ExternalRTreeOpContext rctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, -1);
        rctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMRTreeSortedCursor cursor = new LSMRTreeSortedCursor((ILSMIndexOperationContext)rctx, this.linearizer, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeFileReferences((ILSMDiskComponent)mergingComponents.get(0), (ILSMDiskComponent)mergingComponents.get(mergingComponents.size() - 1));
        LSMRTreeAccessor accessor = new LSMRTreeAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)rctx, this.buddyBTreeFields);
        LSMRTreeMergeOperation mergeOp = new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
        this.ioScheduler.scheduleOperation((ILSMIOOperation)mergeOp);
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMRTreeAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion), this.buddyBTreeFields);
    }

    public ExternalRTreeOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalRTreeOpContext(this.rtreeCmpFactories, this.btreeCmpFactories, searchCallback, targetVersion, (ILSMHarness)this.getLsmHarness(), this.comparatorFields, this.linearizerArray, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory);
    }

    @Override
    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeAccessor((ILSMHarness)this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, this.version), this.buddyBTreeFields);
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public void setCurrentVersion(int version) {
        this.version = version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMRTreeDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        this.getLsmHarness().addTransactionComponents(component);
    }

    public void abortTransaction() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void recoverTransaction() throws HyracksDataException {
        this.fileManager.recoverTransaction();
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    public class LSMTwoPCRTreeBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader rtreeBulkLoader;
        private final BTree.BTreeBulkLoader btreeBulkLoader;
        private final IIndexBulkLoader builder;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        private boolean endedBloomFilterLoad = false;
        private final boolean isTransaction;

        public LSMTwoPCRTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean isTransaction) throws HyracksDataException {
            this.isTransaction = isTransaction;
            this.component = isTransaction ? this.createTransactionTarget() : ExternalRTree.this.createBulkLoadTarget();
            this.rtreeBulkLoader = ((LSMRTreeDiskComponent)this.component).getRTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            this.btreeBulkLoader = (BTree.BTreeBulkLoader)((LSMRTreeDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)ExternalRTree.this.bloomFilterFalsePositiveRate);
            this.builder = ((LSMRTreeDiskComponent)this.component).getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            try {
                this.rtreeBulkLoader.add(tuple);
            }
            catch (Exception e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                try {
                    ((LSMRTreeDiskComponent)this.component).getRTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getRTree().destroy();
                try {
                    ((LSMRTreeDiskComponent)this.component).getBTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getBTree().destroy();
                try {
                    ((LSMRTreeDiskComponent)this.component).getBloomFilter().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getBloomFilter().destroy();
            }
        }

        public void end() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                if (!this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                this.rtreeBulkLoader.end();
                this.btreeBulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else if (this.isTransaction) {
                    ExternalRTree.this.markAsValid(this.component);
                    RTree rtree = ((LSMRTreeDiskComponent)this.component).getRTree();
                    BTree btree = ((LSMRTreeDiskComponent)this.component).getBTree();
                    BloomFilter bloomFilter = ((LSMRTreeDiskComponent)this.component).getBloomFilter();
                    rtree.deactivate();
                    btree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalRTree.this.getLsmHarness().addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            try {
                this.btreeBulkLoader.add(tuple);
                this.builder.add(tuple);
            }
            catch (Exception e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void abort() {
            try {
                this.cleanupArtifacts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalRTree.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            return ExternalRTree.this.createDiskComponent(ExternalRTree.this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

