/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public abstract class AbstractLSMRTree
extends AbstractLSMIndex
implements ITreeIndex {
    protected final ILinearizeComparatorFactory linearizer;
    protected final int[] comparatorFields;
    protected final IBinaryComparatorFactory[] linearizerArray;
    protected final boolean isPointMBR;
    protected final ILSMDiskComponentFactory componentFactory;
    protected IBinaryComparatorFactory[] btreeCmpFactories;
    protected IBinaryComparatorFactory[] rtreeCmpFactories;
    protected final ITreeIndexFrameFactory rtreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory rtreeLeafFrameFactory;
    protected final ITreeIndexFrameFactory btreeLeafFrameFactory;

    public AbstractLSMRTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR, IBufferCache diskBufferCache) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable, filterHelper, rtreeFields);
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            RTree memRTree = new RTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), rtreeInteriorFrameFactory, rtreeLeafFrameFactory, rtreeCmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_r_" + i), isPointMBR);
            BTree memBTree = new BTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), btreeInteriorFrameFactory, btreeLeafFrameFactory, btreeCmpFactories, btreeCmpFactories.length, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_b_" + i));
            LSMRTreeMemoryComponent mutableComponent = new LSMRTreeMemoryComponent(memRTree, memBTree, virtualBufferCache, i == 0, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.rtreeInteriorFrameFactory = rtreeInteriorFrameFactory;
        this.rtreeLeafFrameFactory = rtreeLeafFrameFactory;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.componentFactory = componentFactory;
        this.btreeCmpFactories = btreeCmpFactories;
        this.rtreeCmpFactories = rtreeCmpFactories;
        this.linearizer = linearizer;
        this.comparatorFields = comparatorFields;
        this.linearizerArray = linearizerArray;
        this.isPointMBR = isPointMBR;
    }

    public AbstractLSMRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean durable, boolean isPointMBR, IBufferCache diskBufferCache) {
        super(ioManager, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.rtreeInteriorFrameFactory = rtreeInteriorFrameFactory;
        this.rtreeLeafFrameFactory = rtreeLeafFrameFactory;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.componentFactory = componentFactory;
        this.btreeCmpFactories = btreeCmpFactories;
        this.rtreeCmpFactories = rtreeCmpFactories;
        this.linearizer = linearizer;
        this.comparatorFields = comparatorFields;
        this.linearizerArray = linearizerArray;
        this.isPointMBR = isPointMBR;
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMRTreeOpContext ctx = (LSMRTreeOpContext)ictx;
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    protected LSMRTreeDiskComponent createDiskComponent(ILSMDiskComponentFactory factory, FileReference insertFileRef, FileReference deleteFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)factory.createComponent(new LSMComponentFileReferences(insertFileRef, deleteFileRef, bloomFilterFileRef));
        if (createComponent) {
            component.getRTree().create();
        }
        component.getRTree().activate();
        if (component.getBTree() != null) {
            if (createComponent) {
                component.getBTree().create();
                component.getBloomFilter().create();
            }
            component.getBTree().activate();
            component.getBloomFilter().activate();
        }
        if (component.getLSMComponentFilter() != null && !createComponent) {
            this.getFilterManager().readFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        return component;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getLeafFrameFactory();
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getInteriorFrameFactory();
    }

    public IPageManager getPageManager() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getPageManager();
    }

    public int getFieldCount() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getFieldCount();
    }

    public int getRootPageId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getRootPageId();
    }

    public int getFileId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getFileId();
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        LSMRTreeOpContext ctx;
        block7: {
            ITupleReference indexTuple;
            ctx = (LSMRTreeOpContext)ictx;
            if (ctx.getOperation() == IndexOperation.PHYSICALDELETE) {
                throw new UnsupportedOperationException("Physical delete not supported in the LSM-RTree");
            }
            if (ctx.getIndexTuple() != null) {
                ctx.getIndexTuple().reset(tuple);
                indexTuple = ctx.getIndexTuple();
                ctx.getCurrentMutableRTreeAccessor().getOpContext().resetNonIndexFieldsTuple(tuple);
            } else {
                indexTuple = tuple;
            }
            ctx.getModificationCallback().before(indexTuple);
            ctx.getModificationCallback().found(null, tuple);
            if (ctx.getOperation() == IndexOperation.INSERT) {
                ctx.getCurrentMutableRTreeAccessor().insert(indexTuple);
            } else {
                ctx.getCurrentMutableRTreeAccessor().delete(indexTuple);
                try {
                    ctx.getCurrentMutableBTreeAccessor().insert(indexTuple);
                }
                catch (HyracksDataException e) {
                    if (e.getErrorCode() == 33) break block7;
                    throw e;
                }
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    protected LSMRTreeOpContext createOpContext(IModificationOperationCallback modCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeOpContext(this.memoryComponents, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory, modCallback, searchCallback, this.getTreeFields(), this.getFilterFields(), this.getLsmHarness(), this.comparatorFields, this.linearizerArray, this.getFilterCmpFactories());
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.rtreeCmpFactories;
    }

    protected void validateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM R-Trees.");
    }

    protected void validateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM R-Trees.");
    }

    protected long getMemoryComponentSize(ILSMMemoryComponent c) {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
        IBufferCache virtualBufferCache = mutableComponent.getRTree().getBufferCache();
        return (long)virtualBufferCache.getNumPages() * (long)virtualBufferCache.getPageSize();
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public String toString() {
        return "LSMRTree [" + this.fileManager.getBaseDir() + "]";
    }

    protected void allocateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
        ((IVirtualBufferCache)mutableComponent.getRTree().getBufferCache()).open();
        mutableComponent.getRTree().create();
        mutableComponent.getBTree().create();
        mutableComponent.getRTree().activate();
        mutableComponent.getBTree().activate();
    }

    protected void deactivateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
        mutableComponent.getRTree().deactivate();
        mutableComponent.getBTree().deactivate();
        mutableComponent.getRTree().destroy();
        mutableComponent.getBTree().destroy();
        ((IVirtualBufferCache)mutableComponent.getRTree().getBufferCache()).close();
    }

    protected void clearMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
        mutableComponent.getRTree().clear();
        mutableComponent.getBTree().clear();
        mutableComponent.reset();
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        RTree firstTree = ((LSMRTreeDiskComponent)firstComponent).getRTree();
        RTree lastTree = ((LSMRTreeDiskComponent)lastComponent).getRTree();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        return this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
    }
}

