/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class BTreeCountingSearchCursor
implements ITreeIndexCursor {
    private int fileId = -1;
    private ICachedPage page = null;
    private IBufferCache bufferCache = null;
    private int tupleIndex = 0;
    private int stopTupleIndex;
    private int count = -1;
    private FindTupleMode lowKeyFtm;
    private FindTupleMode highKeyFtm;
    private FindTupleNoExactMatchPolicy lowKeyFtp;
    private FindTupleNoExactMatchPolicy highKeyFtp;
    private final IBTreeLeafFrame frame;
    private final ITreeIndexTupleReference frameTuple;
    private final boolean exclusiveLatchNodes;
    private boolean isPageDirty;
    private RangePredicate pred;
    private MultiComparator lowKeyCmp;
    private MultiComparator highKeyCmp;
    private ITupleReference lowKey;
    private ITupleReference highKey;
    private byte[] countBuf = new byte[4];
    private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(1);
    private ArrayTupleReference countTuple = new ArrayTupleReference();

    public BTreeCountingSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
        this.exclusiveLatchNodes = exclusiveLatchNodes;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.releasePage();
        }
        this.page = ((BTreeCursorInitialState)initialState).getPage();
        this.isPageDirty = false;
        this.frame.setPage(this.page);
        this.pred = (RangePredicate)searchPred;
        this.lowKeyCmp = this.pred.getLowKeyComparator();
        this.highKeyCmp = this.pred.getHighKeyComparator();
        this.lowKey = this.pred.getLowKey();
        this.highKey = this.pred.getHighKey();
        this.lowKeyFtm = FindTupleMode.EXCLUSIVE;
        this.lowKeyFtp = this.pred.lowKeyInclusive ? FindTupleNoExactMatchPolicy.LOWER_KEY : FindTupleNoExactMatchPolicy.HIGHER_KEY;
        this.highKeyFtm = FindTupleMode.EXCLUSIVE;
        this.highKeyFtp = this.pred.highKeyInclusive ? FindTupleNoExactMatchPolicy.HIGHER_KEY : FindTupleNoExactMatchPolicy.LOWER_KEY;
        this.tupleIndex = this.getLowKeyIndex();
        this.stopTupleIndex = this.getHighKeyIndex();
    }

    private void releasePage() throws HyracksDataException {
        if (this.exclusiveLatchNodes) {
            this.page.releaseWriteLatch(this.isPageDirty);
        } else {
            this.page.releaseReadLatch();
        }
        this.bufferCache.unpin(this.page);
    }

    private void fetchNextLeafPage(int nextLeafPage) throws HyracksDataException {
        do {
            ICachedPage nextLeaf = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextLeafPage), false);
            if (this.exclusiveLatchNodes) {
                nextLeaf.acquireWriteLatch();
                this.page.releaseWriteLatch(this.isPageDirty);
            } else {
                nextLeaf.acquireReadLatch();
                this.page.releaseReadLatch();
            }
            this.bufferCache.unpin(this.page);
            this.page = nextLeaf;
            this.isPageDirty = false;
            this.frame.setPage(this.page);
            nextLeafPage = this.frame.getNextLeaf();
        } while (this.frame.getTupleCount() == 0 && nextLeafPage > 0);
    }

    private int getLowKeyIndex() throws HyracksDataException {
        if (this.lowKey == null) {
            return 0;
        }
        int index = this.frame.findTupleIndex(this.lowKey, this.frameTuple, this.lowKeyCmp, this.lowKeyFtm, this.lowKeyFtp);
        if (this.pred.lowKeyInclusive) {
            ++index;
        } else if (index < 0) {
            index = this.frame.getTupleCount();
        }
        return index;
    }

    private int getHighKeyIndex() throws HyracksDataException {
        if (this.highKey == null) {
            return this.frame.getTupleCount() - 1;
        }
        int index = this.frame.findTupleIndex(this.highKey, this.frameTuple, this.highKeyCmp, this.highKeyFtm, this.highKeyFtp);
        if (this.pred.highKeyInclusive) {
            index = index < 0 ? this.frame.getTupleCount() - 1 : --index;
        }
        return index;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.count < 0) {
            this.count = 0;
            while (this.stopTupleIndex >= 0 || this.frame.getTupleCount() == 0) {
                this.count += this.stopTupleIndex - this.tupleIndex + 1;
                int nextLeafPage = this.frame.getNextLeaf();
                if (nextLeafPage < 0) break;
                this.fetchNextLeafPage(nextLeafPage);
                this.tupleIndex = 0;
                this.stopTupleIndex = this.getHighKeyIndex();
            }
            return true;
        }
        return false;
    }

    public void next() throws HyracksDataException {
        IntegerPointable.setInteger((byte[])this.countBuf, (int)0, (int)this.count);
        this.tupleBuilder.addField(this.countBuf, 0, 4);
        this.countTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
    }

    public void close() throws HyracksDataException {
        if (this.page != null) {
            this.releasePage();
        }
        this.tupleBuilder.reset();
        this.tupleIndex = 0;
        this.page = null;
        this.isPageDirty = false;
        this.pred = null;
        this.count = -1;
    }

    public void reset() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ITupleReference getTuple() {
        return this.countTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public boolean isExclusiveLatchNodes() {
        return this.exclusiveLatchNodes;
    }
}

