/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.dataflow;

import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class BTreeResource
implements IResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final IStorageManager storageManager;
    private final ITypeTraits[] typeTraits;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPageManagerFactory pageManagerFactory;

    public BTreeResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] comparatorFactories, IPageManagerFactory pageManagerFactory) {
        this.path = path;
        this.storageManager = storageManager;
        this.typeTraits = typeTraits;
        this.comparatorFactories = comparatorFactories;
        this.pageManagerFactory = pageManagerFactory;
    }

    public IIndex createInstance(INCServiceContext ctx) throws HyracksDataException {
        IBufferCache bufferCache = this.storageManager.getBufferCache(ctx);
        IIOManager ioManager = ctx.getIoManager();
        FileReference resourceRef = ioManager.resolve(this.path);
        return BTreeUtils.createBTree(bufferCache, this.typeTraits, this.comparatorFactories, BTreeLeafFrameType.REGULAR_NSM, resourceRef, this.pageManagerFactory.createPageManager(bufferCache));
    }

    public String getPath() {
        return this.path;
    }
}

