/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IPartitionedInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.AbstractTOccurrenceSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListPartitions;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class PartitionedTOccurrenceSearcher
extends AbstractTOccurrenceSearcher {
    protected final ArrayTupleBuilder lowerBoundTupleBuilder = new ArrayTupleBuilder(1);
    protected final ArrayTupleReference lowerBoundTuple = new ArrayTupleReference();
    protected final ArrayTupleBuilder upperBoundTupleBuilder = new ArrayTupleBuilder(1);
    protected final ArrayTupleReference upperBoundTuple = new ArrayTupleReference();
    protected final ConcatenatingTupleReference fullLowSearchKey = new ConcatenatingTupleReference(2);
    protected final ConcatenatingTupleReference fullHighSearchKey = new ConcatenatingTupleReference(2);
    protected final ArrayList<IInvertedListCursor> cursorsOrderedByTokens = new ArrayList();
    protected final InvertedListPartitions partitions = new InvertedListPartitions();

    public PartitionedTOccurrenceSearcher(IHyracksCommonContext ctx, IInPlaceInvertedIndex invIndex) throws HyracksDataException {
        super(ctx, invIndex);
        this.initHelperTuples();
    }

    private void initHelperTuples() {
        try {
            this.lowerBoundTupleBuilder.reset();
            this.lowerBoundTupleBuilder.getDataOutput().writeShort(Short.MIN_VALUE);
            this.lowerBoundTupleBuilder.addFieldEndOffset();
            this.lowerBoundTuple.reset(this.lowerBoundTupleBuilder.getFieldEndOffsets(), this.lowerBoundTupleBuilder.getByteArray());
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, 0);
            this.fullLowSearchKey.reset();
            this.fullLowSearchKey.addTuple((ITupleReference)this.searchKey);
            this.fullLowSearchKey.addTuple((ITupleReference)this.lowerBoundTuple);
            this.upperBoundTupleBuilder.reset();
            this.upperBoundTupleBuilder.getDataOutput().writeShort(Short.MAX_VALUE);
            this.upperBoundTupleBuilder.addFieldEndOffset();
            this.upperBoundTuple.reset(this.upperBoundTupleBuilder.getFieldEndOffsets(), this.upperBoundTupleBuilder.getByteArray());
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, 0);
            this.fullHighSearchKey.reset();
            this.fullHighSearchKey.addTuple((ITupleReference)this.searchKey);
            this.fullHighSearchKey.addTuple((ITupleReference)this.upperBoundTuple);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void search(OnDiskInvertedIndexSearchCursor resultCursor, InvertedIndexSearchPredicate searchPred, IIndexOperationContext ictx) throws HyracksDataException {
        int i;
        IPartitionedInvertedIndex partInvIndex = (IPartitionedInvertedIndex)((Object)this.invIndex);
        this.searchResult.reset();
        if (partInvIndex.isEmpty()) {
            return;
        }
        this.tokenizeQuery(searchPred);
        int numQueryTokens = this.queryTokenAppender.getTupleCount();
        IInvertedIndexSearchModifier searchModifier = searchPred.getSearchModifier();
        short numTokensLowerBound = searchModifier.getNumTokensLowerBound((short)numQueryTokens);
        short numTokensUpperBound = searchModifier.getNumTokensUpperBound((short)numQueryTokens);
        this.occurrenceThreshold = searchModifier.getOccurrenceThreshold(numQueryTokens);
        if (this.occurrenceThreshold <= 0) {
            throw HyracksDataException.create((int)39, (Serializable[])new Serializable[0]);
        }
        int maxCountPossible = numQueryTokens;
        this.invListCursorCache.reset();
        this.partitions.reset(numTokensLowerBound, numTokensUpperBound);
        this.cursorsOrderedByTokens.clear();
        for (int i2 = 0; i2 < numQueryTokens; ++i2) {
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, i2);
            if (partInvIndex.openInvertedListPartitionCursors(this, ictx, numTokensLowerBound, numTokensUpperBound, this.partitions, this.cursorsOrderedByTokens) || (maxCountPossible = (int)((short)(maxCountPossible - 1))) >= this.occurrenceThreshold) continue;
            return;
        }
        ArrayList<IInvertedListCursor>[] partitionCursors = this.partitions.getPartitions();
        int start = this.partitions.getMinValidPartitionIndex();
        short end = this.partitions.getMaxValidPartitionIndex();
        if (!this.cursorsOrderedByTokens.isEmpty()) {
            for (i = start; i <= end; ++i) {
                if (partitionCursors[i] == null || partitionCursors[i].size() >= this.occurrenceThreshold) continue;
                this.cursorsOrderedByTokens.removeAll(partitionCursors[i]);
            }
            int numCursors = this.cursorsOrderedByTokens.size();
            for (int i3 = 0; i3 < numCursors; ++i3) {
                this.cursorsOrderedByTokens.get(i3).pinPages();
            }
        }
        for (i = start; i <= end; ++i) {
            if (partitionCursors[i] == null || partitionCursors[i].size() < this.occurrenceThreshold) continue;
            int numPrefixLists = searchModifier.getNumPrefixLists(this.occurrenceThreshold, partitionCursors[i].size());
            this.invListMerger.reset();
            this.invListMerger.merge(partitionCursors[i], this.occurrenceThreshold, numPrefixLists, this.searchResult);
        }
        resultCursor.open(null, (ISearchPredicate)searchPred);
    }

    public void setNumTokensBoundsInSearchKeys(short numTokensLowerBound, short numTokensUpperBound) {
        ShortPointable.setShort((byte[])this.lowerBoundTuple.getFieldData(0), (int)this.lowerBoundTuple.getFieldStart(0), (short)numTokensLowerBound);
        ShortPointable.setShort((byte[])this.upperBoundTuple.getFieldData(0), (int)this.upperBoundTuple.getFieldStart(0), (short)numTokensUpperBound);
    }

    public ITupleReference getPrefixSearchKey() {
        return this.searchKey;
    }

    public ITupleReference getFullLowSearchKey() {
        return this.fullLowSearchKey;
    }

    public ITupleReference getFullHighSearchKey() {
        return this.fullHighSearchKey;
    }

    public IInvertedListCursor getCachedInvertedListCursor() {
        return (IInvertedListCursor)this.invListCursorCache.getNext();
    }
}

