/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IPartitionedInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListPartitions;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.PartitionedTOccurrenceSearcher;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class PartitionedOnDiskInvertedIndex
extends OnDiskInvertedIndex
implements IPartitionedInvertedIndex {
    protected final int PARTITIONING_NUM_TOKENS_FIELD = 1;

    public PartitionedOnDiskInvertedIndex(IBufferCache bufferCache, IInvertedListBuilder invListBuilder, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, FileReference btreeFile, FileReference invListsFile, IPageManagerFactory pageManagerFactory) throws HyracksDataException {
        super(bufferCache, invListBuilder, invListTypeTraits, invListCmpFactories, tokenTypeTraits, tokenCmpFactories, btreeFile, invListsFile, pageManagerFactory);
    }

    @Override
    public IIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new PartitionedOnDiskInvertedIndexAccessor((OnDiskInvertedIndex)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openInvertedListPartitionCursors(IInvertedIndexSearcher searcher, IIndexOperationContext ictx, short numTokensLowerBound, short numTokensUpperBound, InvertedListPartitions invListPartitions, List<IInvertedListCursor> cursorsOrderedByTokens) throws HyracksDataException {
        PartitionedTOccurrenceSearcher partSearcher = (PartitionedTOccurrenceSearcher)searcher;
        OnDiskInvertedIndexOpContext ctx = (OnDiskInvertedIndexOpContext)ictx;
        ITupleReference lowSearchKey = null;
        ITupleReference highSearchKey = null;
        partSearcher.setNumTokensBoundsInSearchKeys(numTokensLowerBound, numTokensUpperBound);
        if (numTokensLowerBound < 0) {
            ctx.getBtreePred().setLowKeyComparator(ctx.getPrefixSearchCmp());
            lowSearchKey = partSearcher.getPrefixSearchKey();
        } else {
            ctx.getBtreePred().setLowKeyComparator(ctx.getSearchCmp());
            lowSearchKey = partSearcher.getFullLowSearchKey();
        }
        if (numTokensUpperBound < 0) {
            ctx.getBtreePred().setHighKeyComparator(ctx.getPrefixSearchCmp());
            highSearchKey = partSearcher.getPrefixSearchKey();
        } else {
            ctx.getBtreePred().setHighKeyComparator(ctx.getSearchCmp());
            highSearchKey = partSearcher.getFullHighSearchKey();
        }
        ctx.getBtreePred().setLowKey(lowSearchKey, true);
        ctx.getBtreePred().setHighKey(highSearchKey, true);
        ctx.getBtreeAccessor().search(ctx.getBtreeCursor(), (ISearchPredicate)ctx.getBtreePred());
        boolean tokenExists = false;
        try {
            while (ctx.getBtreeCursor().hasNext()) {
                ctx.getBtreeCursor().next();
                ITupleReference btreeTuple = ctx.getBtreeCursor().getTuple();
                short numTokens = ShortPointable.getShort((byte[])btreeTuple.getFieldData(1), (int)btreeTuple.getFieldStart(1));
                IInvertedListCursor invListCursor = partSearcher.getCachedInvertedListCursor();
                this.resetInvertedListCursor(btreeTuple, invListCursor);
                cursorsOrderedByTokens.add(invListCursor);
                invListPartitions.addInvertedListCursor(invListCursor, numTokens);
                tokenExists = true;
            }
        }
        finally {
            ctx.getBtreeCursor().close();
            ctx.getBtreeCursor().reset();
        }
        return tokenExists;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public class PartitionedOnDiskInvertedIndexAccessor
    extends OnDiskInvertedIndex.OnDiskInvertedIndexAccessor {
        public PartitionedOnDiskInvertedIndexAccessor(OnDiskInvertedIndex index) throws HyracksDataException {
            super(index, new PartitionedTOccurrenceSearcher(PartitionedOnDiskInvertedIndex.this.ctx, index));
        }
    }
}

