/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class OnDiskInvertedIndexSearchCursor
implements IIndexCursor {
    private List<ByteBuffer> resultBuffers;
    private int numResultBuffers;
    private int currentBufferIndex = 0;
    private int tupleIndex = 0;
    private final IInvertedIndexSearcher invIndexSearcher;
    private final IFrameTupleAccessor fta;
    private final FixedSizeTupleReference frameTuple;
    private final PermutingTupleReference resultTuple;

    public OnDiskInvertedIndexSearchCursor(IInvertedIndexSearcher invIndexSearcher, int numInvListFields) {
        this.invIndexSearcher = invIndexSearcher;
        this.fta = invIndexSearcher.createResultFrameTupleAccessor();
        this.frameTuple = (FixedSizeTupleReference)invIndexSearcher.createResultFrameTupleReference();
        int[] fieldPermutation = new int[numInvListFields];
        for (int i = 0; i < numInvListFields; ++i) {
            fieldPermutation[i] = i;
        }
        this.resultTuple = new PermutingTupleReference(fieldPermutation);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        this.currentBufferIndex = 0;
        this.tupleIndex = 0;
        this.resultBuffers = this.invIndexSearcher.getResultBuffers();
        this.numResultBuffers = this.invIndexSearcher.getNumValidResultBuffers();
        if (this.numResultBuffers > 0) {
            this.fta.reset(this.resultBuffers.get(0));
        }
    }

    public boolean hasNext() {
        return this.currentBufferIndex < this.numResultBuffers && this.tupleIndex < this.fta.getTupleCount();
    }

    public void next() {
        this.frameTuple.reset(this.fta.getBuffer().array(), this.fta.getTupleStartOffset(this.tupleIndex));
        this.resultTuple.reset((ITupleReference)this.frameTuple);
        ++this.tupleIndex;
        if (this.tupleIndex >= this.fta.getTupleCount() && this.currentBufferIndex + 1 < this.numResultBuffers) {
            ++this.currentBufferIndex;
            this.fta.reset(this.resultBuffers.get(this.currentBufferIndex));
            this.tupleIndex = 0;
        }
    }

    public ITupleReference getTuple() {
        return this.resultTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public void reset() {
        this.currentBufferIndex = 0;
        this.tupleIndex = 0;
        this.invIndexSearcher.reset();
        this.resultBuffers = this.invIndexSearcher.getResultBuffers();
        this.numResultBuffers = this.invIndexSearcher.getNumValidResultBuffers();
    }

    public void close() throws HyracksDataException {
        this.currentBufferIndex = 0;
        this.tupleIndex = 0;
        this.resultBuffers = null;
        this.numResultBuffers = 0;
    }
}

