/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeElementInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.TOccurrenceSearcher;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class OnDiskInvertedIndex
implements IInPlaceInvertedIndex {
    protected final IHyracksCommonContext ctx = new DefaultHyracksCommonContext();
    protected final int invListStartPageIdField;
    protected final int invListEndPageIdField;
    protected final int invListStartOffField;
    protected final int invListNumElementsField;
    protected static final ITypeTraits[] btreeValueTypeTraits = new ITypeTraits[4];
    protected BTree btree;
    protected int rootPageId = 0;
    protected IBufferCache bufferCache;
    protected int fileId = -1;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    protected final IInvertedListBuilder invListBuilder;
    protected final int numTokenFields;
    protected final int numInvListKeys;
    protected final FileReference invListsFile;
    protected int invListsMaxPageId = -1;
    protected boolean isOpen = false;
    protected boolean wasOpen = false;

    public OnDiskInvertedIndex(IBufferCache bufferCache, IInvertedListBuilder invListBuilder, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, FileReference btreeFile, FileReference invListsFile, IPageManagerFactory pageManagerFactory) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.invListBuilder = invListBuilder;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.btree = BTreeUtils.createBTree((IBufferCache)bufferCache, (ITypeTraits[])OnDiskInvertedIndex.getBTreeTypeTraits(tokenTypeTraits), (IBinaryComparatorFactory[])tokenCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)btreeFile, (IPageManager)pageManagerFactory.createPageManager(bufferCache));
        this.numTokenFields = this.btree.getComparatorFactories().length;
        this.numInvListKeys = invListCmpFactories.length;
        this.invListsFile = invListsFile;
        this.invListStartPageIdField = this.numTokenFields;
        this.invListEndPageIdField = this.numTokenFields + 1;
        this.invListStartOffField = this.numTokenFields + 2;
        this.invListNumElementsField = this.numTokenFields + 3;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to create since index is already open.");
        }
        this.btree.create();
        this.fileId = this.bufferCache.createFile(this.invListsFile);
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        this.btree.activate();
        if (this.fileId >= 0) {
            this.bufferCache.openFile(this.fileId);
        } else {
            this.fileId = this.bufferCache.openFile(this.invListsFile);
        }
        this.isOpen = true;
        this.wasOpen = true;
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isOpen && this.wasOpen) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        this.btree.deactivate();
        this.bufferCache.closeFile(this.fileId);
        this.isOpen = false;
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to destroy since index is already open.");
        }
        this.btree.destroy();
        this.bufferCache.deleteFile(this.invListsFile);
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isOpen) {
            throw new HyracksDataException("Failed to clear since index is not open.");
        }
        this.btree.clear();
        this.bufferCache.closeFile(this.fileId);
        this.bufferCache.deleteFile(this.fileId);
        this.fileId = this.bufferCache.createFile(this.invListsFile);
        this.bufferCache.openFile(this.fileId);
    }

    @Override
    public IInvertedListCursor createInvertedListCursor() {
        return new FixedSizeElementInvertedListCursor(this.bufferCache, this.fileId, this.invListTypeTraits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openInvertedListCursor(IInvertedListCursor listCursor, ITupleReference searchKey, IIndexOperationContext ictx) throws HyracksDataException {
        OnDiskInvertedIndexOpContext ctx = (OnDiskInvertedIndexOpContext)ictx;
        ctx.getBtreePred().setLowKeyComparator(ctx.getSearchCmp());
        ctx.getBtreePred().setHighKeyComparator(ctx.getSearchCmp());
        ctx.getBtreePred().setLowKey(searchKey, true);
        ctx.getBtreePred().setHighKey(searchKey, true);
        ctx.getBtreeAccessor().search(ctx.getBtreeCursor(), (ISearchPredicate)ctx.getBtreePred());
        try {
            if (ctx.getBtreeCursor().hasNext()) {
                ctx.getBtreeCursor().next();
                this.resetInvertedListCursor(ctx.getBtreeCursor().getTuple(), listCursor);
            } else {
                listCursor.reset(0, 0, 0, 0);
            }
        }
        finally {
            ctx.getBtreeCursor().close();
            ctx.getBtreeCursor().reset();
        }
    }

    public void resetInvertedListCursor(ITupleReference btreeTuple, IInvertedListCursor listCursor) {
        int startPageId = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListStartPageIdField), (int)btreeTuple.getFieldStart(this.invListStartPageIdField));
        int endPageId = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListEndPageIdField), (int)btreeTuple.getFieldStart(this.invListEndPageIdField));
        int startOff = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListStartOffField), (int)btreeTuple.getFieldStart(this.invListStartOffField));
        int numElements = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListNumElementsField), (int)btreeTuple.getFieldStart(this.invListNumElementsField));
        listCursor.reset(startPageId, endPageId, startOff, numElements);
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    public int getInvListsFileId() {
        return this.fileId;
    }

    public int getInvListsMaxPageId() {
        return this.invListsMaxPageId;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    public BTree getBTree() {
        return this.btree;
    }

    public FileReference getInvListsFile() {
        return this.invListsFile;
    }

    public IIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new OnDiskInvertedIndexAccessor(this);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        return new OnDiskInvertedIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, this.rootPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws HyracksDataException {
        this.btree.validate();
        ITreeIndexAccessor btreeAccessor = this.btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        IIndexCursor btreeCursor = btreeAccessor.createSearchCursor(false);
        MultiComparator btreeCmp = MultiComparator.create((IBinaryComparatorFactory[])this.btree.getComparatorFactories());
        RangePredicate rangePred = new RangePredicate(null, null, true, true, btreeCmp, btreeCmp);
        int[] fieldPermutation = new int[this.tokenTypeTraits.length];
        for (int i = 0; i < this.tokenTypeTraits.length; ++i) {
            fieldPermutation[i] = i;
        }
        PermutingTupleReference tokenTuple = new PermutingTupleReference(fieldPermutation);
        IInvertedIndexAccessor invIndexAccessor = (IInvertedIndexAccessor)this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        IInvertedListCursor invListCursor = invIndexAccessor.createInvertedListCursor();
        MultiComparator invListCmp = MultiComparator.create((IBinaryComparatorFactory[])this.invListCmpFactories);
        try {
            ArrayTupleBuilder prevBuilder = new ArrayTupleBuilder(this.invListTypeTraits.length);
            ArrayTupleReference prevTuple = new ArrayTupleReference();
            btreeAccessor.search(btreeCursor, (ISearchPredicate)rangePred);
            while (btreeCursor.hasNext()) {
                btreeCursor.next();
                tokenTuple.reset(btreeCursor.getTuple());
                invIndexAccessor.openInvertedListCursor(invListCursor, (ITupleReference)tokenTuple);
                invListCursor.pinPages();
                try {
                    ITupleReference invListElement;
                    if (invListCursor.hasNext()) {
                        invListCursor.next();
                        invListElement = invListCursor.getTuple();
                        TupleUtils.copyTuple((ArrayTupleBuilder)prevBuilder, (ITupleReference)invListElement, (int)invListElement.getFieldCount());
                        prevTuple.reset(prevBuilder.getFieldEndOffsets(), prevBuilder.getByteArray());
                    }
                    while (invListCursor.hasNext()) {
                        invListCursor.next();
                        invListElement = invListCursor.getTuple();
                        if (invListCmp.compare(invListElement, (ITupleReference)prevTuple) <= 0) {
                            throw new HyracksDataException("Index validation failed.");
                        }
                        TupleUtils.copyTuple((ArrayTupleBuilder)prevBuilder, (ITupleReference)invListElement, (int)invListElement.getFieldCount());
                        prevTuple.reset(prevBuilder.getFieldEndOffsets(), prevBuilder.getByteArray());
                    }
                }
                finally {
                    invListCursor.unpinPages();
                }
            }
        }
        finally {
            btreeCursor.close();
        }
    }

    public long getMemoryAllocationSize() {
        return 0L;
    }

    protected static ITypeTraits[] getBTreeTypeTraits(ITypeTraits[] tokenTypeTraits) {
        int i;
        ITypeTraits[] btreeTypeTraits = new ITypeTraits[tokenTypeTraits.length + btreeValueTypeTraits.length];
        for (i = 0; i < tokenTypeTraits.length; ++i) {
            btreeTypeTraits[i] = tokenTypeTraits[i];
        }
        for (i = 0; i < btreeValueTypeTraits.length; ++i) {
            btreeTypeTraits[i + tokenTypeTraits.length] = btreeValueTypeTraits[i];
        }
        return btreeTypeTraits;
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public boolean hasMemoryComponents() {
        return true;
    }

    public int getNumOfFilterFields() {
        return 0;
    }

    @Override
    public synchronized void purge() throws HyracksDataException {
        if (this.isOpen) {
            throw HyracksDataException.create((int)77, (Serializable[])new Serializable[0]);
        }
        this.btree.purge();
        this.bufferCache.purgeHandle(this.fileId);
        this.fileId = -1;
    }

    static {
        OnDiskInvertedIndex.btreeValueTypeTraits[0] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[1] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[2] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[3] = IntegerPointable.TYPE_TRAITS;
    }

    public static class DefaultHyracksCommonContext
    implements IHyracksCommonContext {
        private final int FRAME_SIZE = 32768;

        public int getInitialFrameSize() {
            return 32768;
        }

        public IIOManager getIoManager() {
            return null;
        }

        public ByteBuffer allocateFrame() {
            return ByteBuffer.allocate(32768);
        }

        public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
            return ByteBuffer.allocate(bytes);
        }

        public ByteBuffer reallocateFrame(ByteBuffer bytes, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
            throw new HyracksDataException("TODO");
        }

        public void deallocateFrames(int bytes) {
        }
    }

    public class OnDiskInvertedIndexAccessor
    implements IInvertedIndexAccessor {
        private final OnDiskInvertedIndex index;
        private final IInvertedIndexSearcher searcher;
        private final IIndexOperationContext opCtx;

        public OnDiskInvertedIndexAccessor(OnDiskInvertedIndex index) throws HyracksDataException {
            this.opCtx = new OnDiskInvertedIndexOpContext(OnDiskInvertedIndex.this.btree);
            this.index = index;
            this.searcher = new TOccurrenceSearcher(OnDiskInvertedIndex.this.ctx, index);
        }

        protected OnDiskInvertedIndexAccessor(OnDiskInvertedIndex index, IInvertedIndexSearcher searcher) {
            this.opCtx = new OnDiskInvertedIndexOpContext(OnDiskInvertedIndex.this.btree);
            this.index = index;
            this.searcher = searcher;
        }

        public IIndexCursor createSearchCursor(boolean exclusive) {
            return new OnDiskInvertedIndexSearchCursor(this.searcher, this.index.getInvListTypeTraits().length);
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            this.searcher.search((OnDiskInvertedIndexSearchCursor)cursor, (InvertedIndexSearchPredicate)searchPred, this.opCtx);
        }

        @Override
        public IInvertedListCursor createInvertedListCursor() {
            return this.index.createInvertedListCursor();
        }

        @Override
        public void openInvertedListCursor(IInvertedListCursor listCursor, ITupleReference searchKey) throws HyracksDataException {
            this.index.openInvertedListCursor(listCursor, searchKey, this.opCtx);
        }

        @Override
        public IIndexCursor createRangeSearchCursor() {
            return new OnDiskInvertedIndexRangeSearchCursor(this.index, this.opCtx);
        }

        @Override
        public void rangeSearch(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            OnDiskInvertedIndexRangeSearchCursor rangeSearchCursor = (OnDiskInvertedIndexRangeSearchCursor)cursor;
            rangeSearchCursor.open(null, searchPred);
        }

        public void insert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Insert not supported by inverted index.");
        }

        public void update(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Update not supported by inverted index.");
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Delete not supported by inverted index.");
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Upsert not supported by inverted index.");
        }
    }

    public final class OnDiskInvertedIndexBulkLoader
    implements IIndexBulkLoader {
        private final ArrayTupleBuilder btreeTupleBuilder;
        private final ArrayTupleReference btreeTupleReference;
        private final IIndexBulkLoader btreeBulkloader;
        private int currentInvListStartPageId;
        private int currentInvListStartOffset;
        private final ArrayTupleBuilder lastTupleBuilder;
        private final ArrayTupleReference lastTuple;
        private int currentPageId;
        private ICachedPage currentPage;
        private final MultiComparator tokenCmp;
        private final MultiComparator invListCmp;
        private final boolean verifyInput;
        private final MultiComparator allCmp;
        private IFIFOPageQueue queue;

        public OnDiskInvertedIndexBulkLoader(float btreeFillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, int startPageId) throws HyracksDataException {
            this.verifyInput = verifyInput;
            this.tokenCmp = MultiComparator.create((IBinaryComparatorFactory[])OnDiskInvertedIndex.this.btree.getComparatorFactories());
            this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])OnDiskInvertedIndex.this.invListCmpFactories);
            this.allCmp = verifyInput ? MultiComparator.create((IBinaryComparatorFactory[][])new IBinaryComparatorFactory[][]{OnDiskInvertedIndex.this.btree.getComparatorFactories(), OnDiskInvertedIndex.this.invListCmpFactories}) : null;
            this.btreeTupleBuilder = new ArrayTupleBuilder(OnDiskInvertedIndex.this.btree.getFieldCount());
            this.btreeTupleReference = new ArrayTupleReference();
            this.lastTupleBuilder = new ArrayTupleBuilder(OnDiskInvertedIndex.this.numTokenFields + OnDiskInvertedIndex.this.numInvListKeys);
            this.lastTuple = new ArrayTupleReference();
            this.btreeBulkloader = OnDiskInvertedIndex.this.btree.createBulkLoader(btreeFillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
            this.currentPageId = startPageId;
            this.currentPage = OnDiskInvertedIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)OnDiskInvertedIndex.this.fileId, (int)this.currentPageId));
            OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
            this.queue = OnDiskInvertedIndex.this.bufferCache.createFIFOQueue();
        }

        public void pinNextPage() throws HyracksDataException {
            this.queue.put(this.currentPage);
            ++this.currentPageId;
            this.currentPage = OnDiskInvertedIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)OnDiskInvertedIndex.this.fileId, (int)this.currentPageId));
        }

        private void createAndInsertBTreeTuple() throws HyracksDataException {
            this.btreeTupleBuilder.reset();
            DataOutput output = this.btreeTupleBuilder.getDataOutput();
            this.lastTuple.reset(this.lastTupleBuilder.getFieldEndOffsets(), this.lastTupleBuilder.getByteArray());
            for (int i = 0; i < OnDiskInvertedIndex.this.numTokenFields; ++i) {
                this.btreeTupleBuilder.addField(this.lastTuple.getFieldData(i), this.lastTuple.getFieldStart(i), this.lastTuple.getFieldLength(i));
            }
            try {
                output.writeInt(this.currentInvListStartPageId);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(this.currentPageId);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(this.currentInvListStartOffset);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(OnDiskInvertedIndex.this.invListBuilder.getListSize());
                this.btreeTupleBuilder.addFieldEndOffset();
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            this.btreeTupleReference.reset(this.btreeTupleBuilder.getFieldEndOffsets(), this.btreeTupleBuilder.getByteArray());
            this.btreeBulkloader.add((ITupleReference)this.btreeTupleReference);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            boolean firstElement;
            boolean startNewList = firstElement = this.lastTupleBuilder.getSize() == 0;
            if (!firstElement) {
                this.lastTuple.reset(this.lastTupleBuilder.getFieldEndOffsets(), this.lastTupleBuilder.getByteArray());
                boolean bl = startNewList = this.tokenCmp.compare(tuple, (ITupleReference)this.lastTuple) != 0;
            }
            if (startNewList) {
                if (!firstElement) {
                    this.createAndInsertBTreeTuple();
                }
                if (!OnDiskInvertedIndex.this.invListBuilder.startNewList(tuple, OnDiskInvertedIndex.this.numTokenFields)) {
                    this.pinNextPage();
                    OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
                    if (!OnDiskInvertedIndex.this.invListBuilder.startNewList(tuple, OnDiskInvertedIndex.this.numTokenFields)) {
                        throw new IllegalStateException("Failed to create first inverted list.");
                    }
                }
                this.currentInvListStartPageId = this.currentPageId;
                this.currentInvListStartOffset = OnDiskInvertedIndex.this.invListBuilder.getPos();
            } else if (this.invListCmp.compare(tuple, (ITupleReference)this.lastTuple, OnDiskInvertedIndex.this.numTokenFields) == 0) {
                return;
            }
            if (!OnDiskInvertedIndex.this.invListBuilder.appendElement(tuple, OnDiskInvertedIndex.this.numTokenFields, OnDiskInvertedIndex.this.numInvListKeys)) {
                this.pinNextPage();
                OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
                if (!OnDiskInvertedIndex.this.invListBuilder.appendElement(tuple, OnDiskInvertedIndex.this.numTokenFields, OnDiskInvertedIndex.this.numInvListKeys)) {
                    throw new IllegalStateException("Failed to append element to inverted list after switching to a new page.");
                }
            }
            if (this.verifyInput && this.lastTupleBuilder.getSize() != 0 && this.allCmp.compare(tuple, (ITupleReference)this.lastTuple) <= 0) {
                throw new HyracksDataException("Input stream given to OnDiskInvertedIndex bulk load is not sorted.");
            }
            this.lastTupleBuilder.reset();
            for (int i = 0; i < tuple.getFieldCount(); ++i) {
                this.lastTupleBuilder.addField(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            }
        }

        public void end() throws HyracksDataException {
            if (this.lastTupleBuilder.getSize() != 0) {
                this.createAndInsertBTreeTuple();
            }
            this.btreeBulkloader.end();
            if (this.currentPage != null) {
                this.queue.put(this.currentPage);
            }
            OnDiskInvertedIndex.this.invListsMaxPageId = this.currentPageId;
            OnDiskInvertedIndex.this.bufferCache.finishQueue();
        }

        public void abort() throws HyracksDataException {
            if (this.btreeBulkloader != null) {
                this.btreeBulkloader.abort();
            }
        }
    }
}

