/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;

public class FixedSizeElementInvertedListBuilder
implements IInvertedListBuilder {
    private final int listElementSize;
    private int listSize = 0;
    private byte[] targetBuf;
    private int pos;

    public FixedSizeElementInvertedListBuilder(ITypeTraits[] invListFields) {
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmp += invListFields[i].getFixedLength();
        }
        this.listElementSize = tmp;
    }

    @Override
    public boolean startNewList(ITupleReference tuple, int tokenField) {
        if (this.pos + this.listElementSize > this.targetBuf.length) {
            return false;
        }
        this.listSize = 0;
        return true;
    }

    @Override
    public boolean appendElement(ITupleReference tuple, int numTokenFields, int numElementFields) {
        if (this.pos + this.listElementSize > this.targetBuf.length) {
            return false;
        }
        for (int i = 0; i < numElementFields; ++i) {
            int field = numTokenFields + i;
            System.arraycopy(tuple.getFieldData(field), tuple.getFieldStart(field), this.targetBuf, this.pos, tuple.getFieldLength(field));
        }
        ++this.listSize;
        this.pos += this.listElementSize;
        return true;
    }

    @Override
    public void setTargetBuffer(byte[] targetBuf, int startPos) {
        this.targetBuf = targetBuf;
        this.pos = startPos;
    }

    @Override
    public int getListSize() {
        return this.listSize;
    }

    @Override
    public int getPos() {
        return this.pos;
    }
}

