/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexFlushOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMergeOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMInvertedIndex
extends AbstractLSMIndex
implements IInvertedIndex {
    private static final Logger LOGGER = Logger.getLogger(LSMInvertedIndex.class.getName());
    protected final IBinaryTokenizerFactory tokenizerFactory;
    protected final ILSMDiskComponentFactory componentFactory;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;

    public LSMInvertedIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, OnDiskInvertedIndexFactory diskInvIndexFactory, BTreeFactory deletedKeysBTreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, ILSMIndexFileManager fileManager, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] invertedIndexFields, int[] filterFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, boolean durable) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskInvIndexFactory.getBufferCache(), fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable, filterHelper, invertedIndexFields);
        this.tokenizerFactory = tokenizerFactory;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        this.componentFactory = new LSMInvertedIndexDiskComponentFactory(diskInvIndexFactory, (TreeIndexFactory<BTree>)deletedKeysBTreeFactory, bloomFilterFactory, filterHelper);
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            InMemoryInvertedIndex memInvIndex = this.createInMemoryInvertedIndex(virtualBufferCache, new VirtualFreePageManager((IBufferCache)virtualBufferCache), i);
            BTree deleteKeysBTree = BTreeUtils.createBTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), (ITypeTraits[])invListTypeTraits, (IBinaryComparatorFactory[])invListCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_del_" + i));
            LSMInvertedIndexMemoryComponent mutableComponent = new LSMInvertedIndexMemoryComponent(memInvIndex, deleteKeysBTree, virtualBufferCache, i == 0, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
    }

    protected ILSMDiskComponent loadComponent(LSMComponentFileReferences refs) throws HyracksDataException {
        return this.createDiskInvIndexComponent(this.componentFactory, refs.getInsertIndexFileReference(), refs.getDeleteIndexFileReference(), refs.getBloomFilterFileReference(), false);
    }

    protected void clearDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
        component.getBloomFilter().deactivate();
        component.getInvIndex().deactivate();
        component.getDeletedKeysBTree().deactivate();
        component.getBloomFilter().destroy();
        component.getInvIndex().destroy();
        component.getDeletedKeysBTree().destroy();
    }

    protected void deactivateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
        mutableComponent.getInvIndex().deactivate();
        mutableComponent.getDeletedKeysBTree().deactivate();
        mutableComponent.getInvIndex().destroy();
        mutableComponent.getDeletedKeysBTree().destroy();
        ((IVirtualBufferCache)mutableComponent.getInvIndex().getBufferCache()).close();
    }

    protected void deactivateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
        component.getBloomFilter().deactivate();
        component.getBloomFilter().purge();
        component.getInvIndex().deactivate();
        component.getInvIndex().purge();
        component.getDeletedKeysBTree().deactivate();
        component.getDeletedKeysBTree().purge();
    }

    protected void destroyDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
        component.getInvIndex().destroy();
        component.getDeletedKeysBTree().destroy();
        component.getBloomFilter().destroy();
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        ITupleReference indexTuple;
        LSMInvertedIndexOpContext ctx = (LSMInvertedIndexOpContext)ictx;
        if (ctx.getIndexTuple() != null) {
            ctx.getIndexTuple().reset(tuple);
            indexTuple = ctx.getIndexTuple();
            ((InMemoryInvertedIndexAccessor)ctx.getCurrentMutableInvIndexAccessors()).resetLogTuple(tuple);
        } else {
            indexTuple = tuple;
        }
        ctx.getModificationCallback().before(tuple);
        ctx.getModificationCallback().found(null, tuple);
        switch (ctx.getOperation()) {
            case INSERT: {
                ctx.getCurrentMutableInvIndexAccessors().insert(indexTuple);
                break;
            }
            case DELETE: {
                ctx.getCurrentMutableInvIndexAccessors().delete(indexTuple);
                ctx.getKeysOnlyTuple().reset(indexTuple);
                try {
                    ctx.getCurrentDeletedKeysBTreeAccessors().insert((ITupleReference)ctx.getKeysOnlyTuple());
                    break;
                }
                catch (HyracksDataException e) {
                    if (e.getErrorCode() == 33) break;
                    LOGGER.log(Level.WARNING, "Failure during index delete operation", e);
                    throw e;
                }
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        List operationalComponents = ictx.getComponentHolder();
        int numComponents = operationalComponents.size();
        boolean includeMutableComponent = false;
        ArrayList<IIndexAccessor> indexAccessors = new ArrayList<IIndexAccessor>(numComponents);
        ArrayList<IIndexAccessor> deletedKeysBTreeAccessors = new ArrayList<IIndexAccessor>(numComponents);
        for (int i = 0; i < operationalComponents.size(); ++i) {
            ITreeIndexAccessor deletedKeysAccessor;
            IIndexAccessor invIndexAccessor;
            ILSMComponent component = (ILSMComponent)operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                includeMutableComponent = true;
                invIndexAccessor = ((LSMInvertedIndexMemoryComponent)component).getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                indexAccessors.add(invIndexAccessor);
                deletedKeysAccessor = ((LSMInvertedIndexMemoryComponent)component).getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                deletedKeysBTreeAccessors.add((IIndexAccessor)deletedKeysAccessor);
                continue;
            }
            invIndexAccessor = ((LSMInvertedIndexDiskComponent)component).getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            indexAccessors.add(invIndexAccessor);
            deletedKeysAccessor = ((LSMInvertedIndexDiskComponent)component).getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            deletedKeysBTreeAccessors.add((IIndexAccessor)deletedKeysAccessor);
        }
        ICursorInitialState initState = this.createCursorInitialState(pred, (IIndexOperationContext)ictx, includeMutableComponent, indexAccessors, deletedKeysBTreeAccessors, operationalComponents);
        cursor.open(initState, pred);
    }

    private ICursorInitialState createCursorInitialState(ISearchPredicate pred, IIndexOperationContext ictx, boolean includeMutableComponent, ArrayList<IIndexAccessor> indexAccessors, ArrayList<IIndexAccessor> deletedKeysBTreeAccessors, List<ILSMComponent> operationalComponents) {
        Object initState;
        PermutingTupleReference keysOnlyTuple = this.createKeysOnlyTupleReference();
        MultiComparator keyCmp = MultiComparator.create((IBinaryComparatorFactory[])this.invListCmpFactories);
        if (pred instanceof InvertedIndexSearchPredicate) {
            initState = new LSMInvertedIndexSearchCursorInitialState(keyCmp, keysOnlyTuple, indexAccessors, deletedKeysBTreeAccessors, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getDeletedKeysBTree().getLeafFrameFactory(), ictx, includeMutableComponent, this.getLsmHarness(), operationalComponents);
        } else {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
            InMemoryInvertedIndex memInvIndex = (InMemoryInvertedIndex)mutableComponent.getInvIndex();
            MultiComparator tokensAndKeysCmp = MultiComparator.create((IBinaryComparatorFactory[])memInvIndex.getBTree().getComparatorFactories());
            initState = new LSMInvertedIndexRangeSearchCursorInitialState(tokensAndKeysCmp, keyCmp, keysOnlyTuple, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getDeletedKeysBTree().getLeafFrameFactory(), includeMutableComponent, this.getLsmHarness(), indexAccessors, deletedKeysBTreeAccessors, pred, operationalComponents);
        }
        return initState;
    }

    private PermutingTupleReference createKeysOnlyTupleReference() {
        int[] keyFieldPermutation = new int[this.invListTypeTraits.length];
        int numTokenFields = this.tokenTypeTraits.length;
        for (int i = 0; i < this.invListTypeTraits.length; ++i) {
            keyFieldPermutation[i] = numTokenFields + i;
        }
        return new PermutingTupleReference(keyFieldPermutation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException {
        LSMInvertedIndexFlushOperation flushOp = (LSMInvertedIndexFlushOperation)operation;
        LSMInvertedIndexDiskComponent component = this.createDiskInvIndexComponent(this.componentFactory, flushOp.getTarget(), flushOp.getDeletedKeysBTreeTarget(), flushOp.getBloomFilterTarget(), true);
        LSMInvertedIndexMemoryComponent flushingComponent = (LSMInvertedIndexMemoryComponent)flushOp.getFlushingComponent();
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        ITreeIndexAccessor deletedKeysBTreeAccessor = flushingComponent.getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ITreeIndexCursor btreeCountingCursor = ((BTree.BTreeAccessor)deletedKeysBTreeAccessor).createCountingSearchCursor();
        deletedKeysBTreeAccessor.search((IIndexCursor)btreeCountingCursor, (ISearchPredicate)nullPred);
        long numBTreeTuples = 0L;
        try {
            while (btreeCountingCursor.hasNext()) {
                btreeCountingCursor.next();
                ITupleReference countTuple = btreeCountingCursor.getTuple();
                numBTreeTuples = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
            }
        }
        finally {
            btreeCountingCursor.close();
        }
        ILSMDiskComponentBulkLoader componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, numBTreeTuples, false, false, false);
        deletedKeysBTreeAccessor.search(deletedKeysScanCursor, (ISearchPredicate)nullPred);
        try (IIndexCursor deletedKeysScanCursor = deletedKeysBTreeAccessor.createSearchCursor(false);){
            while (deletedKeysScanCursor.hasNext()) {
                deletedKeysScanCursor.next();
                ((LSMInvertedIndexDiskComponentBulkLoader)componentBulkLoader).delete(deletedKeysScanCursor.getTuple());
            }
        }
        InMemoryInvertedIndexAccessor memInvIndexAccessor = (InMemoryInvertedIndexAccessor)flushingComponent.getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        BTree.BTreeAccessor memBTreeAccessor = memInvIndexAccessor.getBTreeAccessor();
        memBTreeAccessor.search((IIndexCursor)scanCursor, (ISearchPredicate)nullPred);
        try (ITreeIndexCursor scanCursor = memBTreeAccessor.createSearchCursor(false);){
            while (scanCursor.hasNext()) {
                scanCursor.next();
                componentBulkLoader.add(scanCursor.getTuple());
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMDiskComponentBulkLoader componentBulkLoader;
        LSMInvertedIndexMergeOperation mergeOp = (LSMInvertedIndexMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        RangePredicate mergePred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)mergePred);
        LSMInvertedIndexDiskComponent component = this.createDiskInvIndexComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getDeletedKeysBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        if (mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            LSMInvertedIndexDeletedKeysBTreeMergeCursor btreeCursor = new LSMInvertedIndexDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)mergePred);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMInvertedIndexDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
            }
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, numElements, false, false, false);
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    componentBulkLoader.delete(tuple);
                }
            }
            finally {
                btreeCursor.close();
            }
        } else {
            componentBulkLoader = this.createComponentBulkLoader((ILSMDiskComponent)component, 1.0f, false, 0L, false, false, false);
        }
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference tuple = cursor.getTuple();
                componentBulkLoader.add(tuple);
            }
        }
        finally {
            cursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                ITupleReference min = ((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple();
                ITupleReference max = ((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple();
                if (min != null) {
                    filterTuples.add(min);
                }
                if (max == null) continue;
                filterTuples.add(max);
            }
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        componentBulkLoader.end();
        return component;
    }

    public ILSMDiskComponentBulkLoader createComponentBulkLoader(ILSMDiskComponent component, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        BloomFilterSpecification bloomFilterSpec = null;
        if (numElementsHint > 0L) {
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        if (withFilter && this.filterFields != null) {
            return new LSMInvertedIndexDiskComponentBulkLoader((LSMInvertedIndexDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent, (ILSMComponentFilterManager)this.filterManager, this.treeFields, this.filterFields, MultiComparator.create((IBinaryComparatorFactory[])component.getLSMComponentFilter().getFilterCmpFactories()));
        }
        return new LSMInvertedIndexDiskComponentBulkLoader((LSMInvertedIndexDiskComponent)component, bloomFilterSpec, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, cleanupEmptyComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMInvertedIndexBulkLoader(fillFactor, verifyInput, numElementsHint);
    }

    public ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskInvIndexComponent(this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    protected InMemoryInvertedIndex createInMemoryInvertedIndex(IVirtualBufferCache virtualBufferCache, VirtualFreePageManager virtualFreePageManager, int id) throws HyracksDataException {
        return InvertedIndexUtils.createInMemoryBTreeInvertedindex((IBufferCache)virtualBufferCache, (IPageManager)virtualFreePageManager, this.invListTypeTraits, this.invListCmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, this.ioManager.resolveAbsolutePath(this.fileManager.getBaseDir() + "_virtual_vocab_" + id));
    }

    protected LSMInvertedIndexDiskComponent createDiskInvIndexComponent(ILSMDiskComponentFactory factory, FileReference dictBTreeFileRef, FileReference btreeFileRef, FileReference bloomFilterFileRef, boolean create) throws HyracksDataException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)factory.createComponent(new LSMComponentFileReferences(dictBTreeFileRef, btreeFileRef, bloomFilterFileRef));
        if (create) {
            component.getInvIndex().create();
            component.getDeletedKeysBTree().create();
            component.getBloomFilter().create();
        }
        component.getInvIndex().activate();
        component.getDeletedKeysBTree().activate();
        component.getBloomFilter().activate();
        if (component.getLSMComponentFilter() != null && !create) {
            this.getFilterManager().readFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        return component;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMInvertedIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback));
    }

    protected LSMInvertedIndexOpContext createOpContext(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMInvertedIndexOpContext(this.memoryComponents, modificationCallback, searchCallback, this.invertedIndexFieldsForNonBulkLoadOps, this.filterFieldsForNonBulkLoadOps, this.getFilterCmpFactories());
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public IBinaryTokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)lsmComponent;
        OnDiskInvertedIndex invIndex = (OnDiskInvertedIndex)invIndexComponent.getInvIndex();
        IBufferCache bufferCache = invIndex.getBufferCache();
        this.markAsValidInternal(invIndex.getBufferCache(), invIndexComponent.getBloomFilter());
        bufferCache.force(invIndex.getInvListsFileId(), true);
        this.markAsValidInternal((ITreeIndex)invIndex.getBTree());
        this.markAsValidInternal((ITreeIndex)invIndexComponent.getDeletedKeysBTree());
    }

    public String toString() {
        return "LSMInvertedIndex [" + this.fileManager.getBaseDir() + "]";
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)lsmComponent;
        OnDiskInvertedIndex invIndex = (OnDiskInvertedIndex)invIndexComponent.getInvIndex();
        files.add(invIndex.getInvListsFile().getFile().getAbsolutePath());
        files.add(invIndex.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(invIndexComponent.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        files.add(invIndexComponent.getDeletedKeysBTree().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    protected void clearMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
        mutableComponent.getInvIndex().clear();
        mutableComponent.getDeletedKeysBTree().clear();
        mutableComponent.reset();
    }

    protected long getMemoryComponentSize(ILSMMemoryComponent c) {
        LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
        IBufferCache virtualBufferCache = mutableComponent.getInvIndex().getBufferCache();
        return (long)virtualBufferCache.getNumPages() * (long)virtualBufferCache.getPageSize();
    }

    protected void validateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
        mutableComponent.getInvIndex().validate();
        mutableComponent.getDeletedKeysBTree().validate();
    }

    protected void validateDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
        component.getInvIndex().validate();
        component.getDeletedKeysBTree().validate();
    }

    protected void allocateMemoryComponent(ILSMMemoryComponent c) throws HyracksDataException {
        LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
        ((IVirtualBufferCache)mutableComponent.getInvIndex().getBufferCache()).open();
        mutableComponent.getInvIndex().create();
        mutableComponent.getInvIndex().activate();
        mutableComponent.getDeletedKeysBTree().create();
        mutableComponent.getDeletedKeysBTree().activate();
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        LSMInvertedIndexDiskComponent first = (LSMInvertedIndexDiskComponent)firstComponent;
        OnDiskInvertedIndex firstInvIndex = (OnDiskInvertedIndex)first.getInvIndex();
        String firstFileName = firstInvIndex.getBTree().getFileReference().getFile().getName();
        LSMInvertedIndexDiskComponent last = (LSMInvertedIndexDiskComponent)lastComponent;
        OnDiskInvertedIndex lastInvIndex = (OnDiskInvertedIndex)last.getInvIndex();
        String lastFileName = lastInvIndex.getBTree().getFileReference().getFile().getName();
        return this.fileManager.getRelMergeFileReference(firstFileName, lastFileName);
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, ILSMMemoryComponent flushingComponent, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return new LSMInvertedIndexFlushOperation(new LSMInvertedIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx), flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, List<ILSMComponent> mergingComponents, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMInvertedIndexAccessor accessor = new LSMInvertedIndexAccessor(this.getLsmHarness(), (ILSMIndexOperationContext)opCtx);
        LSMInvertedIndexRangeSearchCursor cursor = new LSMInvertedIndexRangeSearchCursor((ILSMIndexOperationContext)opCtx);
        return new LSMInvertedIndexMergeOperation(accessor, mergingComponents, (IIndexCursor)cursor, mergeFileRefs.getInsertIndexFileReference(), mergeFileRefs.getDeleteIndexFileReference(), mergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath());
    }

    public class LSMInvertedIndexBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader componentBulkLoader;

        public LSMInvertedIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
            this.component = LSMInvertedIndex.this.createBulkLoadTarget();
            this.componentBulkLoader = LSMInvertedIndex.this.createComponentBulkLoader(this.component, fillFactor, verifyInput, numElementsHint, false, true, true);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            this.componentBulkLoader.end();
            if (this.component.getComponentSize() > 0L) {
                LSMInvertedIndex.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                LSMInvertedIndex.this.lsmHarness.addBulkLoadedComponent(this.component);
            }
        }

        public void abort() throws HyracksDataException {
            this.componentBulkLoader.abort();
        }
    }
}

