/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMInvertedIndexSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected final IInvertedIndexSearchModifier searchModifier;
    protected final IBinaryTokenizerFactory binaryTokenizerFactory;
    protected final int queryFieldIndex;
    protected final int numOfFields;
    protected final boolean isFullTextSearchQuery;

    public LSMInvertedIndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, IInvertedIndexSearchModifier searchModifier, IBinaryTokenizerFactory binaryTokenizerFactory, int queryFieldIndex, boolean isFullTextSearchQuery, int numOfFields, boolean appendIndexFilter) throws HyracksDataException {
        super(ctx, inputRecDesc, partition, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter);
        this.searchModifier = searchModifier;
        this.binaryTokenizerFactory = binaryTokenizerFactory;
        this.queryFieldIndex = queryFieldIndex;
        this.isFullTextSearchQuery = isFullTextSearchQuery;
        if (!retainInput) {
            this.frameTuple = new FrameTupleReference();
        }
        this.numOfFields = numOfFields;
    }

    protected ISearchPredicate createSearchPredicate() {
        return new InvertedIndexSearchPredicate(this.binaryTokenizerFactory.createTokenizer(), this.searchModifier, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey, this.isFullTextSearchQuery);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        InvertedIndexSearchPredicate invIndexSearchPred = (InvertedIndexSearchPredicate)this.searchPred;
        invIndexSearchPred.setQueryTuple((ITupleReference)this.frameTuple);
        invIndexSearchPred.setQueryFieldIndex(this.queryFieldIndex);
        invIndexSearchPred.setIsFullTextSearchQuery(this.isFullTextSearchQuery);
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected int getFieldCount() {
        return this.numOfFields;
    }
}

