/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class AbstractIOStrategy
implements IOStrategy {
    protected static final IOEventProcessingHandler enableInterestProcessingHandler = new EnableInterestProcessingHandler();

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig().copy();
        int coresCount = Runtime.getRuntime().availableProcessors();
        config.setCorePoolSize(coresCount * 2);
        config.setMaxPoolSize(coresCount * 2);
        config.setMemoryManager(transport.getMemoryManager());
        return config;
    }

    protected static boolean isReadWrite(IOEvent ioEvent) {
        return ioEvent == IOEvent.READ || ioEvent == IOEvent.WRITE;
    }

    protected static boolean isExecuteInWorkerThread(IOEvent ioEvent) {
        return AbstractIOStrategy.isReadWrite(ioEvent) || ioEvent == IOEvent.CLOSED;
    }

    protected static Executor getWorkerThreadPool(Connection c) {
        return c.getTransport().getWorkerThreadPool();
    }

    protected static void fireIOEvent(Connection connection, IOEvent ioEvent, IOEventProcessingHandler ph, Logger logger) {
        try {
            connection.getTransport().fireIOEvent(ioEvent, connection, ph);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Uncaught exception: ", e);
            try {
                connection.close().markForRecycle(true);
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Uncaught exception: ", e);
            try {
                connection.close().markForRecycle(true);
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Exception occurred when closing the connection: ", ee);
            }
        }
    }

    private static final class EnableInterestProcessingHandler
    extends EmptyIOEventProcessingHandler {
        private EnableInterestProcessingHandler() {
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context);
        }

        @Override
        public void onComplete(Context context) throws IOException {
            IOEvent ioEvent = context.getIoEvent();
            Connection connection = context.getConnection();
            connection.enableIOEvent(ioEvent);
        }
    }
}

