/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.service;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.installer.schema.conf.Configuration;

class ZookeeperUtil {
    ZookeeperUtil() {
    }

    public static void writeConfiguration(String zooKeeperConfigPath, Configuration conf, int leaderConnPort, int leaderElecPort) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("tickTime=1000\n");
        buffer.append("dataDir=" + conf.getZookeeper().getHomeDir() + File.separator + "data\n");
        buffer.append("clientPort=" + conf.getZookeeper().getClientPort().intValue() + "\n");
        buffer.append("initLimit=2\n");
        buffer.append("syncLimit=2\n");
        List<String> servers = conf.getZookeeper().getServers().getServer();
        int serverId = 1;
        for (String server : servers) {
            buffer.append("server." + serverId + "=" + server + ":" + leaderConnPort + ":" + leaderElecPort + "\n");
            ++serverId;
        }
        AsterixEventServiceUtil.dumpToFile(zooKeeperConfigPath, buffer.toString());
    }
}

