/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.io.File;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ClusterStateWatcher;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.StartConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class StartCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((StartConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        AsterixEventServiceUtil.createAsterixZip((AsterixInstance)instance);
        AsterixEventServiceClient client = AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster());
        Patterns asterixBinaryTransferPattern = PatternCreator.INSTANCE.getAsterixBinaryTransferPattern(asterixInstanceName, instance.getCluster());
        client.submit(asterixBinaryTransferPattern);
        ClusterStateWatcher stateWatcher = ServiceProvider.INSTANCE.getLookupService().startWatchingClusterState(asterixInstanceName);
        AsterixEventServiceUtil.createClusterProperties((Cluster)instance.getCluster(), (AsterixConfiguration)instance.getAsterixConfiguration());
        Patterns patterns = PatternCreator.INSTANCE.getStartAsterixPattern(asterixInstanceName, instance.getCluster(), false);
        client.submit(patterns);
        IClusterManagementWork.ClusterState clusterState = stateWatcher.waitForClusterStart();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            throw new Exception("CC failed to start");
        }
        AsterixEventServiceUtil.deleteDirectory((String)(InstallerDriver.getManagixHome() + File.separator + "asterix" + File.separator + asterixInstanceName));
        AsterixRuntimeState runtimeState = VerificationUtil.getAsterixRuntimeState((AsterixInstance)instance);
        VerificationUtil.updateInstanceWithRuntimeDescription((AsterixInstance)instance, (AsterixRuntimeState)runtimeState, (boolean)true);
        LOGGER.info((Object)instance.getDescription(false));
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(instance);
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new StartConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nStarts an ASTERIX instance that is in INACTIVE state.\nAfter executing the start command, the ASTERIX instance transits to the ACTIVE state,\nindicating that it is now available for executing statements/queries.\n\nAvailable arguments/options\n-n name of the ASTERIX instance. ";
    }
}

