/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.AlterCommand;
import org.apache.asterix.installer.command.BackupCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.ConfigureCommand;
import org.apache.asterix.installer.command.CreateCommand;
import org.apache.asterix.installer.command.DeleteCommand;
import org.apache.asterix.installer.command.DescribeCommand;
import org.apache.asterix.installer.command.HelpConfig;
import org.apache.asterix.installer.command.ICommand;
import org.apache.asterix.installer.command.InstallCommand;
import org.apache.asterix.installer.command.LogCommand;
import org.apache.asterix.installer.command.RestoreCommand;
import org.apache.asterix.installer.command.ShutdownCommand;
import org.apache.asterix.installer.command.StartCommand;
import org.apache.asterix.installer.command.StartNodeCommand;
import org.apache.asterix.installer.command.StopCommand;
import org.apache.asterix.installer.command.StopNodeCommand;
import org.apache.asterix.installer.command.UninstallCommand;
import org.apache.asterix.installer.command.ValidateCommand;
import org.apache.asterix.installer.command.VersionCommand;

public class HelpCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        HelpConfig helpConfig = (HelpConfig)this.config;
        String command = helpConfig.command;
        ICommand.CommandType cmdType = ICommand.CommandType.valueOf(command.toUpperCase());
        String helpMessage = null;
        switch (cmdType) {
            case CREATE: {
                helpMessage = new CreateCommand().getUsageDescription();
                break;
            }
            case CONFIGURE: {
                helpMessage = new ConfigureCommand().getUsageDescription();
                break;
            }
            case DELETE: {
                helpMessage = new DeleteCommand().getUsageDescription();
                break;
            }
            case DESCRIBE: {
                helpMessage = new DescribeCommand().getUsageDescription();
                break;
            }
            case RESTORE: {
                helpMessage = new RestoreCommand().getUsageDescription();
                break;
            }
            case START: {
                helpMessage = new StartCommand().getUsageDescription();
                break;
            }
            case SHUTDOWN: {
                helpMessage = new ShutdownCommand().getUsageDescription();
                break;
            }
            case BACKUP: {
                helpMessage = new BackupCommand().getUsageDescription();
                break;
            }
            case STOP: {
                helpMessage = new StopCommand().getUsageDescription();
                break;
            }
            case VALIDATE: {
                helpMessage = new ValidateCommand().getUsageDescription();
                break;
            }
            case INSTALL: {
                helpMessage = new InstallCommand().getUsageDescription();
                break;
            }
            case UNINSTALL: {
                helpMessage = new UninstallCommand().getUsageDescription();
                break;
            }
            case ALTER: {
                helpMessage = new AlterCommand().getUsageDescription();
                break;
            }
            case LOG: {
                helpMessage = new LogCommand().getUsageDescription();
                break;
            }
            case STOPNODE: {
                helpMessage = new StopNodeCommand().getUsageDescription();
                break;
            }
            case STARTNODE: {
                helpMessage = new StartNodeCommand().getUsageDescription();
                break;
            }
            case VERSION: {
                helpMessage = new VersionCommand().getUsageDescription();
                break;
            }
            default: {
                helpMessage = "Unknown command " + command;
            }
        }
        System.out.println(helpMessage);
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new HelpConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nAlter the instance's configuration settings.\nPrior to running this command, the instance is required to be INACTIVE state.\n\nAvailable arguments/options\n-n name of the ASTERIX instance\n-conf path to the ASTERIX configuration file.";
    }
}

