/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.DeleteConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class DeleteCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((DeleteConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        Patterns patterns = PatternCreator.INSTANCE.createDeleteInstancePattern(instance);
        AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster()).submit(patterns);
        patterns = PatternCreator.INSTANCE.createRemoveAsterixWorkingDirPattern(instance);
        AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster()).submit(patterns);
        ServiceProvider.INSTANCE.getLookupService().removeAsterixInstance(asterixInstanceName);
        LOGGER.info((Object)("Deleted Asterix instance: " + asterixInstanceName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new DeleteConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nPermanently deletes an ASTERIX instance.\nThe instance must be in the INACTIVE state.\n\nAvailable arguments/options\n-n name of the ASTERIX instance.";
    }
}

