/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.event.error.EventException;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ClusterStateWatcher;
import org.apache.asterix.event.service.ILookupService;
import org.apache.asterix.event.service.ZooKeeperWatcher;
import org.apache.asterix.event.service.ZookeeperUtil;
import org.apache.asterix.installer.schema.conf.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperService
implements ILookupService {
    private static final Logger LOGGER = Logger.getLogger((String)ZooKeeperService.class.getName());
    private static final int ZOOKEEPER_LEADER_CONN_PORT = 2222;
    private static final int ZOOKEEPER_LEADER_ELEC_PORT = 2223;
    private static final int ZOOKEEPER_SESSION_TIME_OUT = 40000;
    private static final String ZOOKEEPER_HOME = AsterixEventService.getEventHome() + File.separator + "zookeeper";
    private static final String ZOO_KEEPER_CONFIG = ZOOKEEPER_HOME + File.separator + "zk.cfg";
    private boolean isRunning = false;
    private ZooKeeper zk;
    private String zkConnectionString;
    public static final String ASTERIX_INSTANCE_BASE_PATH = File.separator + "Asterix";
    public static final String ASTERIX_INSTANCE_STATE_PATH = File.separator + "state";
    public static final String ASTERIX_INSTANCE_STATE_REPORT = File.separator + "clusterState";
    public static final int DEFAULT_NODE_VERSION = -1;
    private LinkedBlockingQueue<String> msgQ = new LinkedBlockingQueue();
    private ZooKeeperWatcher watcher = new ZooKeeperWatcher(this.msgQ);

    @Override
    public boolean isRunning(Configuration conf) throws Exception {
        List<String> servers = conf.getZookeeper().getServers().getServer();
        int clientPort = conf.getZookeeper().getClientPort().intValue();
        StringBuilder connectionString = new StringBuilder();
        for (String serverAddress : servers) {
            connectionString.append(serverAddress);
            connectionString.append(":");
            connectionString.append(clientPort);
            connectionString.append(",");
        }
        if (connectionString.length() > 0) {
            connectionString.deleteCharAt(connectionString.length() - 1);
        }
        this.zkConnectionString = connectionString.toString();
        this.zk = new ZooKeeper(this.zkConnectionString, 40000, (Watcher)this.watcher);
        try {
            this.zk.exists("/dummy", (Watcher)this.watcher);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("ZooKeeper running at " + connectionString));
            }
            this.createRootIfNotExist();
            this.isRunning = true;
        }
        catch (KeeperException ke) {
            this.isRunning = false;
        }
        return this.isRunning;
    }

    @Override
    public void startService(Configuration conf) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting ZooKeeper at " + this.zkConnectionString));
        }
        ZookeeperUtil.writeConfiguration(ZOO_KEEPER_CONFIG, conf, 2222, 2223);
        String initScript = ZOOKEEPER_HOME + File.separator + "bin" + File.separator + "zk.init";
        StringBuilder cmdBuffer = new StringBuilder();
        cmdBuffer.append(initScript + " ");
        cmdBuffer.append(conf.getZookeeper().getHomeDir() + " ");
        cmdBuffer.append(conf.getZookeeper().getServers().getJavaHome() + " ");
        List<String> zkServers = conf.getZookeeper().getServers().getServer();
        for (String zkServer : zkServers) {
            cmdBuffer.append(zkServer + " ");
        }
        Process zkProcess = Runtime.getRuntime().exec(cmdBuffer.toString());
        int exitCode = zkProcess.waitFor();
        Pair<CharSequence, CharSequence> outputs = this.getProcessStreams(zkProcess);
        if (exitCode != 0) {
            StringBuilder msg = new StringBuilder("Error starting zookeeper server; output code = ");
            msg.append(exitCode);
            this.appendNonEmptyStreams(outputs, msg);
            throw new Exception(msg.toString());
        }
        this.zk = new ZooKeeper(this.zkConnectionString, 40000, (Watcher)this.watcher);
        String head = this.msgQ.poll(60L, TimeUnit.SECONDS);
        if (head == null) {
            StringBuilder msg = new StringBuilder("Unable to start Zookeeper Service. This could be because of the following reasons.\n1) Managix is incorrectly configured. Please run managix validate to run a validation test and correct the errors reported.\n2) If validation in (1) is successful, ensure that java_home parameter is set correctly in Managix configuration (" + AsterixEventServiceUtil.MANAGIX_CONF_XML + ")");
            this.appendNonEmptyStreams(outputs, msg);
            throw new Exception(msg.toString());
        }
        this.msgQ.take();
        this.createRootIfNotExist();
    }

    private void appendNonEmptyStreams(Pair<CharSequence, CharSequence> outputs, StringBuilder msg) {
        this.appendIfNotEmpty(msg, (CharSequence)outputs.getLeft(), "stdout");
        this.appendIfNotEmpty(msg, (CharSequence)outputs.getRight(), "stderr");
    }

    private Pair<CharSequence, CharSequence> getProcessStreams(Process process) throws IOException {
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        IOUtils.copy((InputStream)process.getInputStream(), (Writer)stdout, (Charset)Charset.defaultCharset());
        IOUtils.copy((InputStream)process.getErrorStream(), (Writer)stderr, (Charset)Charset.defaultCharset());
        return new ImmutablePair((Object)stdout.getBuffer(), (Object)stderr.getBuffer());
    }

    private void appendIfNotEmpty(StringBuilder msg, CharSequence output, String outputName) {
        if (output.length() > 0) {
            msg.append(", ").append(outputName).append(" = ").append(output);
        }
    }

    @Override
    public void stopService(Configuration conf) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Stopping ZooKeeper running at " + this.zkConnectionString));
        }
        String stopScript = ZOOKEEPER_HOME + File.separator + "bin" + File.separator + "stop_zk";
        StringBuilder cmdBuffer = new StringBuilder();
        cmdBuffer.append(stopScript + " ");
        cmdBuffer.append(conf.getZookeeper().getHomeDir() + " ");
        List<String> zkServers = conf.getZookeeper().getServers().getServer();
        for (String zkServer : zkServers) {
            cmdBuffer.append(zkServer + " ");
        }
        Runtime.getRuntime().exec(cmdBuffer.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Stopped ZooKeeper service at " + this.zkConnectionString));
        }
    }

    @Override
    public void writeAsterixInstance(AsterixInstance asterixInstance) throws Exception {
        String instanceBasePath = ASTERIX_INSTANCE_BASE_PATH + File.separator + asterixInstance.getName();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(asterixInstance);
        this.zk.create(instanceBasePath, b.toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String instanceStatePath = instanceBasePath + ASTERIX_INSTANCE_STATE_PATH;
        this.zk.create(instanceStatePath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    private void createRootIfNotExist() throws Exception {
        try {
            Stat stat = this.zk.exists(ASTERIX_INSTANCE_BASE_PATH, false);
            if (stat == null) {
                this.zk.create(ASTERIX_INSTANCE_BASE_PATH, "root".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error took place when creating the root in Zookeeper");
            e.printStackTrace();
            this.createRootIfNotExist();
        }
    }

    @Override
    public AsterixInstance getAsterixInstance(String name) throws Exception {
        String path = ASTERIX_INSTANCE_BASE_PATH + File.separator + name;
        Stat stat = this.zk.exists(ASTERIX_INSTANCE_BASE_PATH + File.separator + name, false);
        if (stat == null) {
            return null;
        }
        byte[] asterixInstanceBytes = this.zk.getData(path, false, new Stat());
        return this.readAsterixInstanceObject(asterixInstanceBytes);
    }

    @Override
    public boolean exists(String path) throws Exception {
        return this.zk.exists(ASTERIX_INSTANCE_BASE_PATH + File.separator + path, false) != null;
    }

    @Override
    public void removeAsterixInstance(String name) throws Exception {
        if (!this.exists(name)) {
            throw new EventException("Asterix instance by name " + name + " does not exists.");
        }
        if (this.exists(name + ASTERIX_INSTANCE_STATE_PATH)) {
            if (this.exists(name + ASTERIX_INSTANCE_STATE_PATH + File.separator + "clusterState")) {
                this.zk.delete(ASTERIX_INSTANCE_BASE_PATH + File.separator + name + ASTERIX_INSTANCE_STATE_PATH + ASTERIX_INSTANCE_STATE_REPORT, -1);
            }
            this.zk.delete(ASTERIX_INSTANCE_BASE_PATH + File.separator + name + ASTERIX_INSTANCE_STATE_PATH, -1);
        }
        this.zk.delete(ASTERIX_INSTANCE_BASE_PATH + File.separator + name, -1);
    }

    @Override
    public List<AsterixInstance> getAsterixInstances() throws Exception {
        List instanceNames = this.zk.getChildren(ASTERIX_INSTANCE_BASE_PATH, false);
        ArrayList<AsterixInstance> asterixInstances = new ArrayList<AsterixInstance>();
        for (String instanceName : instanceNames) {
            String path = ASTERIX_INSTANCE_BASE_PATH + File.separator + instanceName;
            byte[] asterixInstanceBytes = this.zk.getData(path, false, new Stat());
            asterixInstances.add(this.readAsterixInstanceObject(asterixInstanceBytes));
        }
        return asterixInstances;
    }

    private AsterixInstance readAsterixInstanceObject(byte[] asterixInstanceBytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(asterixInstanceBytes);
        ObjectInputStream ois = new ObjectInputStream(b);
        return (AsterixInstance)ois.readObject();
    }

    @Override
    public void updateAsterixInstance(AsterixInstance updatedInstance) throws Exception {
        this.removeAsterixInstance(updatedInstance.getName());
        this.writeAsterixInstance(updatedInstance);
    }

    @Override
    public ClusterStateWatcher startWatchingClusterState(String instanceName) {
        ClusterStateWatcher watcher = new ClusterStateWatcher(this.zk, instanceName);
        watcher.startMonitoringThread();
        return watcher;
    }

    @Override
    public void reportClusterState(String instanceName, IClusterManagementWork.ClusterState state) throws Exception {
        String clusterStatePath = ASTERIX_INSTANCE_BASE_PATH + File.separator + instanceName + ASTERIX_INSTANCE_STATE_PATH;
        Integer value = state.ordinal();
        byte[] stateValue = new byte[]{value.byteValue()};
        this.zk.create(clusterStatePath + ASTERIX_INSTANCE_STATE_REPORT, stateValue, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }
}

