/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.SimpleAlgebricksAccumulatingAggregatorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupOperatorDescriptor;

public class PreSortedDistinctByPOperator
extends AbstractPhysicalOperator {
    private List<LogicalVariable> columnList;

    public PreSortedDistinctByPOperator(List<LogicalVariable> columnList) {
        this.columnList = columnList;
    }

    public void setDistinctByColumns(List<LogicalVariable> distinctByColumns) {
        this.columnList = distinctByColumns;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        IPartitioningProperty pp = op2.getDeliveredPhysicalProperties().getPartitioningProperty();
        List<ILocalStructuralProperty> propsLocal = op2.getDeliveredPhysicalProperties().getLocalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(pp, propsLocal);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[1];
        ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>();
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (LogicalVariable column : this.columnList) {
            orderColumns.add(new OrderColumn(column, OrderOperator.IOrder.OrderKind.ASC));
        }
        localProps.add(new LocalOrderProperty(orderColumns));
        UnorderedPartitionedProperty pp = null;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)op;
        if (aop.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            pp = new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet(this.columnList), context.getComputationNodeDomain());
        }
        pv[0] = new StructuralPropertiesVector(pp, localProps);
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        int i;
        JobSpecification spec = builder.getJobSpec();
        int[] keys = JobGenHelper.variablesToFieldIndexes(this.columnList, inputSchemas[0]);
        int sz = inputSchemas[0].getSize();
        int fdSz = sz - this.columnList.size();
        int[] fdColumns = new int[fdSz];
        int j = 0;
        for (LogicalVariable v : inputSchemas[0]) {
            if (this.columnList.contains(v)) continue;
            fdColumns[j++] = inputSchemas[0].findVariable(v);
        }
        int[] keysAndDecs = new int[keys.length + fdColumns.length];
        for (i = 0; i < keys.length; ++i) {
            keysAndDecs[i] = keys[i];
        }
        for (i = 0; i < fdColumns.length; ++i) {
            keysAndDecs[i + keys.length] = fdColumns[i];
        }
        IBinaryComparatorFactory[] comparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(this.columnList, context.getTypeEnvironment(op), context);
        IAggregateEvaluatorFactory[] aggFactories = new IAggregateEvaluatorFactory[]{};
        SimpleAlgebricksAccumulatingAggregatorFactory aggregatorFactory = new SimpleAlgebricksAccumulatingAggregatorFactory(aggFactories, keysAndDecs);
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), opSchema, context);
        PreclusteredGroupOperatorDescriptor opDesc = new PreclusteredGroupOperatorDescriptor((IOperatorDescriptorRegistry)spec, keysAndDecs, comparatorFactories, (IAggregatorDescriptorFactory)aggregatorFactory, recordDescriptor);
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        ILogicalOperator src = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, op, 0);
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.PRE_SORTED_DISTINCT_BY;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }
}

