/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalExpressionDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.IQueryOperatorVisitor;

public class LogicalOperatorDeepCopyWithNewVariablesVisitor
implements IQueryOperatorVisitor<ILogicalOperator, ILogicalOperator> {
    private final ITypingContext typeContext;
    private final IVariableContext varContext;
    private final LogicalExpressionDeepCopyWithNewVariablesVisitor exprDeepCopyVisitor;
    private final LinkedHashMap<LogicalVariable, LogicalVariable> inputVarToOutputVarMapping;
    private final LinkedHashMap<LogicalVariable, LogicalVariable> outputVarToInputVarMapping;

    public LogicalOperatorDeepCopyWithNewVariablesVisitor(IVariableContext varContext, ITypingContext typeContext) {
        this.varContext = varContext;
        this.typeContext = typeContext;
        this.inputVarToOutputVarMapping = new LinkedHashMap();
        this.outputVarToInputVarMapping = new LinkedHashMap();
        this.exprDeepCopyVisitor = new LogicalExpressionDeepCopyWithNewVariablesVisitor(varContext, this.outputVarToInputVarMapping, this.inputVarToOutputVarMapping);
    }

    public LogicalOperatorDeepCopyWithNewVariablesVisitor(IVariableContext varContext, ITypingContext typeContext, LinkedHashMap<LogicalVariable, LogicalVariable> inVarMapping) {
        this.varContext = varContext;
        this.typeContext = typeContext;
        this.inputVarToOutputVarMapping = inVarMapping;
        this.outputVarToInputVarMapping = new LinkedHashMap();
        this.exprDeepCopyVisitor = new LogicalExpressionDeepCopyWithNewVariablesVisitor(varContext, inVarMapping, this.inputVarToOutputVarMapping);
    }

    private void copyAnnotations(ILogicalOperator src, ILogicalOperator dest) {
        dest.getAnnotations().putAll(src.getAnnotations());
    }

    public ILogicalOperator deepCopy(ILogicalOperator op) throws AlgebricksException {
        return this.deepCopy(op, null);
    }

    private ILogicalOperator deepCopy(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        if (op == null) {
            return null;
        }
        ILogicalOperator opCopy = op.accept(this, arg);
        if (this.typeContext != null) {
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp(opCopy, this.typeContext);
        }
        return opCopy;
    }

    private void deepCopyInputs(ILogicalOperator src, ILogicalOperator dest, ILogicalOperator arg) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> inputs = src.getInputs();
        List<Mutable<ILogicalOperator>> inputsCopy = dest.getInputs();
        for (Mutable<ILogicalOperator> input : inputs) {
            inputsCopy.add(this.deepCopyOperatorReference(input, arg));
        }
    }

    private Mutable<ILogicalOperator> deepCopyOperatorReference(Mutable<ILogicalOperator> opRef, ILogicalOperator arg) throws AlgebricksException {
        return new MutableObject((Object)this.deepCopy((ILogicalOperator)opRef.getValue(), arg));
    }

    private List<Mutable<ILogicalOperator>> deepCopyOperatorReferenceList(List<Mutable<ILogicalOperator>> list, ILogicalOperator arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> listCopy = new ArrayList<Mutable<ILogicalOperator>>(list.size());
        for (Mutable<ILogicalOperator> opRef : list) {
            listCopy.add(this.deepCopyOperatorReference(opRef, arg));
        }
        return listCopy;
    }

    private OrderOperator.IOrder deepCopyOrder(OrderOperator.IOrder order) {
        switch (order.getKind()) {
            case ASC: 
            case DESC: {
                return order;
            }
        }
        throw new UnsupportedOperationException();
    }

    private List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> deepCopyOrderExpressionReferencePairList(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> list) throws AlgebricksException {
        ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> listCopy = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>(list.size());
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> pair : list) {
            listCopy.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair((Object)this.deepCopyOrder((OrderOperator.IOrder)pair.first), this.exprDeepCopyVisitor.deepCopyExpressionReference((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        return listCopy;
    }

    private ILogicalPlan deepCopyPlan(ILogicalPlan plan, ILogicalOperator arg) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> rootsCopy = this.deepCopyOperatorReferenceList(plan.getRoots(), arg);
        ALogicalPlanImpl planCopy = new ALogicalPlanImpl(rootsCopy);
        return planCopy;
    }

    private List<ILogicalPlan> deepCopyPlanList(List<ILogicalPlan> list, List<ILogicalPlan> listCopy, ILogicalOperator arg) throws AlgebricksException {
        for (ILogicalPlan plan : list) {
            listCopy.add(this.deepCopyPlan(plan, arg));
        }
        return listCopy;
    }

    private LogicalVariable deepCopyVariable(LogicalVariable var) {
        if (var == null) {
            return null;
        }
        LogicalVariable givenVarReplacement = this.outputVarToInputVarMapping.get(var);
        if (givenVarReplacement != null) {
            this.inputVarToOutputVarMapping.put(var, givenVarReplacement);
            return givenVarReplacement;
        }
        LogicalVariable varCopy = this.inputVarToOutputVarMapping.get(var);
        if (varCopy == null) {
            varCopy = this.varContext.newVar();
            this.inputVarToOutputVarMapping.put(var, varCopy);
        }
        return varCopy;
    }

    private List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> deepCopyVariableExpressionReferencePairList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> list) throws AlgebricksException {
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> listCopy = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>(list.size());
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : list) {
            listCopy.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)this.deepCopyVariable((LogicalVariable)pair.first), this.exprDeepCopyVisitor.deepCopyExpressionReference((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        return listCopy;
    }

    private List<LogicalVariable> deepCopyVariableList(List<LogicalVariable> list) {
        ArrayList<LogicalVariable> listCopy = new ArrayList<LogicalVariable>(list.size());
        for (LogicalVariable var : list) {
            listCopy.add(this.deepCopyVariable(var));
        }
        return listCopy;
    }

    private void deepCopyInputsAnnotationsAndExecutionMode(ILogicalOperator op, ILogicalOperator arg, AbstractLogicalOperator opCopy) throws AlgebricksException {
        this.deepCopyInputs(op, opCopy, arg);
        this.copyAnnotations(op, opCopy);
        opCopy.setExecutionMode(op.getExecutionMode());
    }

    public void reset() {
        this.inputVarToOutputVarMapping.clear();
        this.outputVarToInputVarMapping.clear();
    }

    public void updatePrimaryKeys(IOptimizationContext context) {
        for (Map.Entry<LogicalVariable, LogicalVariable> entry : this.inputVarToOutputVarMapping.entrySet()) {
            List<LogicalVariable> primaryKey = context.findPrimaryKey(entry.getKey());
            if (primaryKey == null) continue;
            ArrayList<LogicalVariable> head = new ArrayList<LogicalVariable>();
            for (LogicalVariable variable : primaryKey) {
                head.add(this.inputVarToOutputVarMapping.get(variable));
            }
            ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>(1);
            tail.add(entry.getValue());
            context.addPrimaryKey(new FunctionalDependency(head, tail));
        }
    }

    public LogicalVariable varCopy(LogicalVariable var) throws AlgebricksException {
        return this.inputVarToOutputVarMapping.get(var);
    }

    @Override
    public ILogicalOperator visitAggregateOperator(AggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        AggregateOperator opCopy = new AggregateOperator(this.deepCopyVariableList(op.getVariables()), this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getExpressions()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitAssignOperator(AssignOperator op, ILogicalOperator arg) throws AlgebricksException {
        AssignOperator opCopy = new AssignOperator(this.deepCopyVariableList(op.getVariables()), this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getExpressions()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitDataScanOperator(DataSourceScanOperator op, ILogicalOperator arg) throws AlgebricksException {
        DataSourceScanOperator opCopy = new DataSourceScanOperator(this.deepCopyVariableList(op.getVariables()), op.getDataSource());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitDistinctOperator(DistinctOperator op, ILogicalOperator arg) throws AlgebricksException {
        DistinctOperator opCopy = new DistinctOperator(this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getExpressions()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, ILogicalOperator arg) {
        EmptyTupleSourceOperator opCopy = new EmptyTupleSourceOperator();
        opCopy.setExecutionMode(op.getExecutionMode());
        return opCopy;
    }

    @Override
    public ILogicalOperator visitExchangeOperator(ExchangeOperator op, ILogicalOperator arg) throws AlgebricksException {
        ExchangeOperator opCopy = new ExchangeOperator();
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitGroupByOperator(GroupByOperator op, ILogicalOperator arg) throws AlgebricksException {
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> groupByListCopy = this.deepCopyVariableExpressionReferencePairList(op.getGroupByList());
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorListCopy = this.deepCopyVariableExpressionReferencePairList(op.getDecorList());
        ArrayList<ILogicalPlan> nestedPlansCopy = new ArrayList<ILogicalPlan>();
        GroupByOperator opCopy = new GroupByOperator(groupByListCopy, decorListCopy, nestedPlansCopy, op.isGroupAll());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        this.deepCopyPlanList(op.getNestedPlans(), nestedPlansCopy, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitInnerJoinOperator(InnerJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        InnerJoinOperator opCopy = new InnerJoinOperator((Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getCondition()), this.deepCopyOperatorReference(op.getInputs().get(0), arg), this.deepCopyOperatorReference(op.getInputs().get(1), arg));
        this.copyAnnotations(op, opCopy);
        opCopy.setExecutionMode(op.getExecutionMode());
        return opCopy;
    }

    @Override
    public ILogicalOperator visitLeftOuterJoinOperator(LeftOuterJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        LeftOuterJoinOperator opCopy = new LeftOuterJoinOperator((Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getCondition()), this.deepCopyOperatorReference(op.getInputs().get(0), arg), this.deepCopyOperatorReference(op.getInputs().get(1), arg));
        this.copyAnnotations(op, opCopy);
        opCopy.setExecutionMode(op.getExecutionMode());
        return opCopy;
    }

    @Override
    public ILogicalOperator visitLimitOperator(LimitOperator op, ILogicalOperator arg) throws AlgebricksException {
        LimitOperator opCopy = new LimitOperator(this.exprDeepCopyVisitor.deepCopy((ILogicalExpression)op.getMaxObjects().getValue()), this.exprDeepCopyVisitor.deepCopy((ILogicalExpression)op.getOffset().getValue()), op.isTopmostLimitOp());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitNestedTupleSourceOperator(NestedTupleSourceOperator op, ILogicalOperator arg) throws AlgebricksException {
        MutableObject dataSourceReference = arg == null ? op.getDataSourceReference() : new MutableObject((Object)arg);
        NestedTupleSourceOperator opCopy = new NestedTupleSourceOperator((Mutable<ILogicalOperator>)dataSourceReference);
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitOrderOperator(OrderOperator op, ILogicalOperator arg) throws AlgebricksException {
        OrderOperator opCopy = new OrderOperator(this.deepCopyOrderExpressionReferencePairList(op.getOrderExpressions()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitProjectOperator(ProjectOperator op, ILogicalOperator arg) throws AlgebricksException {
        ProjectOperator opCopy = new ProjectOperator(this.deepCopyVariableList(op.getVariables()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitReplicateOperator(ReplicateOperator op, ILogicalOperator arg) throws AlgebricksException {
        boolean[] outputMatFlags = op.getOutputMaterializationFlags();
        boolean[] copiedOutputMatFlags = new boolean[outputMatFlags.length];
        System.arraycopy(outputMatFlags, 0, copiedOutputMatFlags, 0, outputMatFlags.length);
        ReplicateOperator opCopy = new ReplicateOperator(op.getOutputArity(), copiedOutputMatFlags);
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitSplitOperator(SplitOperator op, ILogicalOperator arg) throws AlgebricksException {
        SplitOperator opCopy = new SplitOperator(op.getOutputArity(), op.getBranchingExpression());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitMaterializeOperator(MaterializeOperator op, ILogicalOperator arg) throws AlgebricksException {
        MaterializeOperator opCopy = new MaterializeOperator();
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitRunningAggregateOperator(RunningAggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        RunningAggregateOperator opCopy = new RunningAggregateOperator(this.deepCopyVariableList(op.getVariables()), this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getExpressions()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitScriptOperator(ScriptOperator op, ILogicalOperator arg) throws AlgebricksException {
        ScriptOperator opCopy = new ScriptOperator(op.getScriptDescription(), this.deepCopyVariableList(op.getInputVariables()), this.deepCopyVariableList(op.getOutputVariables()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitSelectOperator(SelectOperator op, ILogicalOperator arg) throws AlgebricksException {
        SelectOperator opCopy = new SelectOperator((Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getCondition()), op.getRetainMissing(), this.deepCopyVariable(op.getMissingPlaceholderVariable()));
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitSubplanOperator(SubplanOperator op, ILogicalOperator arg) throws AlgebricksException {
        ArrayList<ILogicalPlan> nestedPlansCopy = new ArrayList<ILogicalPlan>();
        SubplanOperator opCopy = new SubplanOperator(nestedPlansCopy);
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        this.deepCopyPlanList(op.getNestedPlans(), nestedPlansCopy, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitUnionOperator(UnionAllOperator op, ILogicalOperator arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> copiedInputs = new ArrayList<Mutable<ILogicalOperator>>();
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            copiedInputs.add(this.deepCopyOperatorReference(mutable, null));
        }
        ArrayList<ArrayList<LogicalVariable>> liveVarsInInputs = new ArrayList<ArrayList<LogicalVariable>>();
        for (Mutable mutable : copiedInputs) {
            ArrayList<LogicalVariable> liveVars = new ArrayList<LogicalVariable>();
            VariableUtilities.getLiveVariables((ILogicalOperator)mutable.getValue(), liveVars);
            liveVarsInInputs.add(liveVars);
        }
        List list = (List)liveVarsInInputs.get(0);
        List list2 = (List)liveVarsInInputs.get(1);
        ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> copiedTriples = new ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>>();
        int index = 0;
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> triple : op.getVariableMappings()) {
            LogicalVariable producedVar = this.deepCopyVariable((LogicalVariable)triple.third);
            Triple copiedTriple = new Triple(list.get(index), list2.get(index), (Object)producedVar);
            copiedTriples.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)copiedTriple);
            ++index;
        }
        UnionAllOperator opCopy = new UnionAllOperator(copiedTriples);
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitIntersectOperator(IntersectOperator op, ILogicalOperator arg) throws AlgebricksException {
        List<List<LogicalVariable>> liveVarsInInputs = this.getLiveVarsInInputs(op);
        ArrayList<LogicalVariable> outputCopy = new ArrayList<LogicalVariable>();
        for (LogicalVariable var : op.getOutputVars()) {
            outputCopy.add(this.deepCopyVariable(var));
        }
        IntersectOperator opCopy = new IntersectOperator(outputCopy, liveVarsInInputs);
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    private List<List<LogicalVariable>> getLiveVarsInInputs(AbstractLogicalOperator op) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> copiedInputs = new ArrayList<Mutable<ILogicalOperator>>();
        for (Mutable<ILogicalOperator> childRef : op.getInputs()) {
            copiedInputs.add(this.deepCopyOperatorReference(childRef, null));
        }
        ArrayList<List<LogicalVariable>> liveVarsInInputs = new ArrayList<List<LogicalVariable>>();
        for (Mutable mutable : copiedInputs) {
            ArrayList<LogicalVariable> liveVars = new ArrayList<LogicalVariable>();
            VariableUtilities.getLiveVariables((ILogicalOperator)mutable.getValue(), liveVars);
            liveVarsInInputs.add(liveVars);
        }
        return liveVarsInInputs;
    }

    @Override
    public ILogicalOperator visitUnnestMapOperator(UnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        UnnestMapOperator opCopy = new UnnestMapOperator(this.deepCopyVariableList(op.getVariables()), (Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getExpressionRef()), op.getVariableTypes(), op.propagatesInput());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        LeftOuterUnnestMapOperator opCopy = new LeftOuterUnnestMapOperator(this.deepCopyVariableList(op.getVariables()), (Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getExpressionRef()), op.getVariableTypes(), op.propagatesInput());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitUnnestOperator(UnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        UnnestOperator opCopy = new UnnestOperator(this.deepCopyVariable(op.getVariable()), (Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getExpressionRef()), this.deepCopyVariable(op.getPositionalVariable()), op.getPositionalVariableType(), op.getPositionWriter());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitTokenizeOperator(TokenizeOperator op, ILogicalOperator arg) throws AlgebricksException {
        TokenizeOperator opCopy = new TokenizeOperator(op.getDataSourceIndex(), (List<Mutable<ILogicalExpression>>)this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getPrimaryKeyExpressions()), (List<Mutable<ILogicalExpression>>)this.exprDeepCopyVisitor.deepCopyExpressionReferenceList(op.getSecondaryKeyExpressions()), this.deepCopyVariableList(op.getTokenizeVars()), (Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getFilterExpression()), op.getOperation(), op.isBulkload(), op.isPartitioned(), op.getTokenizeVarTypes());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    @Override
    public ILogicalOperator visitDelegateOperator(DelegateOperator op, ILogicalOperator arg) throws AlgebricksException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ILogicalOperator visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        LeftOuterUnnestOperator opCopy = new LeftOuterUnnestOperator(this.deepCopyVariable(op.getVariable()), (Mutable<ILogicalExpression>)this.exprDeepCopyVisitor.deepCopyExpressionReference(op.getExpressionRef()), this.deepCopyVariable(op.getPositionalVariable()), op.getPositionalVariableType(), op.getPositionWriter());
        this.deepCopyInputsAnnotationsAndExecutionMode(op, arg, opCopy);
        return opCopy;
    }

    public LinkedHashMap<LogicalVariable, LogicalVariable> getOutputToInputVariableMapping() {
        return this.outputVarToInputVarMapping;
    }

    public LinkedHashMap<LogicalVariable, LogicalVariable> getInputToOutputVariableMapping() {
        return this.inputVarToOutputVarMapping;
    }
}

