/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public abstract class AbstractReplicateOperator
extends AbstractLogicalOperator {
    private int outputArity;
    protected boolean[] outputMaterializationFlags;
    private List<Mutable<ILogicalOperator>> outputs;

    public AbstractReplicateOperator(int outputArity) {
        this.outputArity = outputArity;
        this.outputMaterializationFlags = new boolean[outputArity];
        this.outputs = new ArrayList<Mutable<ILogicalOperator>>();
    }

    public AbstractReplicateOperator(int outputArity, boolean[] outputMaterializationFlags) {
        this.outputArity = outputArity;
        this.outputMaterializationFlags = outputMaterializationFlags;
        this.outputs = new ArrayList<Mutable<ILogicalOperator>>();
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList<LogicalVariable>(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
    }

    public int getOutputArity() {
        return this.outputArity;
    }

    public void setOutputMaterializationFlags(boolean[] outputMaterializationFlags) {
        this.outputMaterializationFlags = outputMaterializationFlags;
    }

    public boolean[] getOutputMaterializationFlags() {
        return this.outputMaterializationFlags;
    }

    public List<Mutable<ILogicalOperator>> getOutputs() {
        return this.outputs;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    public boolean isBlocker() {
        for (boolean requiresMaterialization : this.outputMaterializationFlags) {
            if (!requiresMaterialization) continue;
            return true;
        }
        return false;
    }
}

