/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPropertiesComputer;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class StatefulFunctionCallExpression
extends AbstractFunctionCallExpression {
    private final IPropertiesComputer propertiesComputer;

    public StatefulFunctionCallExpression(IFunctionInfo finfo, IPropertiesComputer propertiesComputer) {
        super(AbstractFunctionCallExpression.FunctionKind.STATEFUL, finfo);
        this.propertiesComputer = propertiesComputer;
    }

    public StatefulFunctionCallExpression(IFunctionInfo finfo, IPropertiesComputer propertiesComputer, List<Mutable<ILogicalExpression>> arguments) {
        super(AbstractFunctionCallExpression.FunctionKind.STATEFUL, finfo, arguments);
        this.propertiesComputer = propertiesComputer;
    }

    public StatefulFunctionCallExpression(IFunctionInfo finfo, IPropertiesComputer propertiesComputer, Mutable<ILogicalExpression> ... expressions) {
        super(AbstractFunctionCallExpression.FunctionKind.STATEFUL, finfo, expressions);
        this.propertiesComputer = propertiesComputer;
    }

    @Override
    public StatefulFunctionCallExpression cloneExpression() {
        this.cloneAnnotations();
        List<Mutable<ILogicalExpression>> clonedArgs = this.cloneArguments();
        return new StatefulFunctionCallExpression(this.finfo, this.propertiesComputer, clonedArgs);
    }

    public IPartitioningProperty getRequiredPartitioningProperty() {
        return this.propertiesComputer.computePartitioningProperty(this);
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitStatefulFunctionCallExpression(this, arg);
    }

    public IPropertiesComputer getPropertiesComputer() {
        return this.propertiesComputer;
    }
}

