/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveUnusedAssignAndAggregateRule
implements IAlgebraicRewriteRule {
    private Map<Mutable<ILogicalOperator>, Set<LogicalVariable>> assignedVarMap = new LinkedHashMap<Mutable<ILogicalOperator>, Set<LogicalVariable>>();
    private Set<LogicalVariable> assignedVarSet = new HashSet<LogicalVariable>();
    private Map<Mutable<ILogicalOperator>, Set<LogicalVariable>> accumulatedUsedVarFromRootMap = new LinkedHashMap<Mutable<ILogicalOperator>, Set<LogicalVariable>>();
    private boolean isTransformed = false;
    private Set<LogicalVariable> survivedUnionSourceVarSet = new HashSet<LogicalVariable>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.clear();
        HashSet<LogicalVariable> accumulatedUsedVarFromRootSet = new HashSet<LogicalVariable>();
        this.collectUnusedAssignedVars(opRef, accumulatedUsedVarFromRootSet, true, context);
        if (!this.assignedVarMap.isEmpty()) {
            this.removeUnusedAssigns(opRef, context);
        }
        return this.isTransformed;
    }

    private Set<LogicalVariable> removeAssignVarFromConsideration(Mutable<ILogicalOperator> opRef) {
        Set<LogicalVariable> assignVarsSetForThisOp = null;
        Set<LogicalVariable> usedVarsSetForThisOp = null;
        if (this.accumulatedUsedVarFromRootMap.containsKey(opRef)) {
            usedVarsSetForThisOp = this.accumulatedUsedVarFromRootMap.get(opRef);
        }
        if (this.assignedVarMap.containsKey(opRef)) {
            assignVarsSetForThisOp = this.assignedVarMap.get(opRef);
        }
        if (assignVarsSetForThisOp != null && !assignVarsSetForThisOp.isEmpty()) {
            Iterator<LogicalVariable> varIter = assignVarsSetForThisOp.iterator();
            while (varIter.hasNext()) {
                LogicalVariable v = varIter.next();
                if ((usedVarsSetForThisOp == null || !usedVarsSetForThisOp.contains(v)) && !this.survivedUnionSourceVarSet.contains(v)) continue;
                varIter.remove();
            }
        }
        if (((ILogicalOperator)opRef.getValue()).getOperatorTag() == LogicalOperatorTag.UNIONALL) {
            for (Triple varMapping : ((UnionAllOperator)opRef.getValue()).getVariableMappings()) {
                this.survivedUnionSourceVarSet.add((LogicalVariable)varMapping.first);
                this.survivedUnionSourceVarSet.add((LogicalVariable)varMapping.second);
            }
        }
        return assignVarsSetForThisOp;
    }

    private void removeUnusedAssigns(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        Set<LogicalVariable> assignVarsSetForThisOp = this.removeAssignVarFromConsideration(opRef);
        while (this.removeFromAssigns(op, assignVarsSetForThisOp, context) == 0 && op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            opRef.setValue((Object)op);
            assignVarsSetForThisOp = this.removeAssignVarFromConsideration(opRef);
        }
        for (Mutable cRef : op.getInputs()) {
            this.removeUnusedAssigns((Mutable<ILogicalOperator>)cRef, context);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opWithNest.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    this.removeUnusedAssigns((Mutable<ILogicalOperator>)r, context);
                }
            }
            for (int i = opWithNest.getNestedPlans().size() - 1; i >= 0; --i) {
                ILogicalPlan nestedPlan = (ILogicalPlan)opWithNest.getNestedPlans().get(i);
                ArrayList<Mutable> rootsToBeRemoved = new ArrayList<Mutable>();
                for (Mutable r : nestedPlan.getRoots()) {
                    ILogicalOperator topOp = (ILogicalOperator)r.getValue();
                    ListSet producedVars = new ListSet();
                    VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)topOp, (Collection)producedVars);
                    if (producedVars.size() != 0) continue;
                    rootsToBeRemoved.add(r);
                }
                if (nestedPlan.getRoots().size() != rootsToBeRemoved.size() || opWithNest.getNestedPlans().size() <= 1) continue;
                nestedPlan.getRoots().removeAll(rootsToBeRemoved);
                opWithNest.getNestedPlans().remove(nestedPlan);
            }
        }
    }

    private int removeFromAssigns(AbstractLogicalOperator op, Set<LogicalVariable> toRemove, IOptimizationContext context) throws AlgebricksException {
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                if (this.removeUnusedVarsAndExprs(toRemove, assign.getVariables(), assign.getExpressions())) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
                    this.isTransformed = true;
                }
                return assign.getVariables().size();
            }
            case AGGREGATE: {
                AggregateOperator agg = (AggregateOperator)op;
                if (this.removeUnusedVarsAndExprs(toRemove, agg.getVariables(), agg.getExpressions())) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)agg);
                    this.isTransformed = true;
                }
                return agg.getVariables().size();
            }
            case UNNEST: {
                UnnestOperator uOp = (UnnestOperator)op;
                LogicalVariable pVar = uOp.getPositionalVariable();
                if (pVar == null || toRemove == null || !toRemove.contains(pVar)) break;
                uOp.setPositionalVariable(null);
                this.assignedVarSet.remove(pVar);
                this.isTransformed = true;
                break;
            }
            case UNIONALL: {
                UnionAllOperator unionOp = (UnionAllOperator)op;
                if (this.removeUnusedVarsFromUnionAll(unionOp, toRemove)) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionOp);
                    this.isTransformed = true;
                }
                return unionOp.getVariableMappings().size();
            }
            case GROUP: {
                GroupByOperator groupByOp = (GroupByOperator)op;
                if (this.removeUnusedVarsFromGroupBy(groupByOp, toRemove)) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)groupByOp);
                    this.isTransformed = true;
                }
                return groupByOp.getGroupByList().size() + groupByOp.getNestedPlans().size() + groupByOp.getDecorList().size();
            }
        }
        return -1;
    }

    private boolean removeUnusedVarsFromUnionAll(UnionAllOperator unionOp, Set<LogicalVariable> toRemove) {
        Iterator iter = unionOp.getVariableMappings().iterator();
        boolean modified = false;
        if (toRemove != null && !toRemove.isEmpty()) {
            while (iter.hasNext()) {
                Triple varMapping = (Triple)iter.next();
                if (toRemove.contains(varMapping.third)) {
                    iter.remove();
                    this.assignedVarSet.remove(varMapping.third);
                    modified = true;
                    continue;
                }
                this.survivedUnionSourceVarSet.add((LogicalVariable)varMapping.first);
                this.survivedUnionSourceVarSet.add((LogicalVariable)varMapping.second);
            }
        }
        return modified;
    }

    private boolean removeUnusedVarsFromGroupBy(GroupByOperator groupByOp, Set<LogicalVariable> toRemove) {
        if (toRemove == null || toRemove.isEmpty()) {
            return false;
        }
        Iterator iter = groupByOp.getDecorList().iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Pair varMapping = (Pair)iter.next();
            LogicalVariable decorVar = (LogicalVariable)varMapping.first;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)((Mutable)varMapping.second).getValue();
            LogicalVariable decorReferredVar = varExpr.getVariableReference();
            boolean removeReBoundDecorVar = toRemove.contains(decorReferredVar);
            if ((decorVar == null || !toRemove.contains(decorVar)) && !removeReBoundDecorVar) continue;
            iter.remove();
            modified = true;
            if (!removeReBoundDecorVar) continue;
            toRemove.remove(decorReferredVar);
        }
        return modified;
    }

    private boolean removeUnusedVarsAndExprs(Set<LogicalVariable> toRemove, List<LogicalVariable> varList, List<Mutable<ILogicalExpression>> exprList) {
        boolean changed = false;
        if (toRemove != null && !toRemove.isEmpty()) {
            Iterator<LogicalVariable> varIter = varList.iterator();
            Iterator<Mutable<ILogicalExpression>> exprIter = exprList.iterator();
            while (varIter.hasNext()) {
                LogicalVariable v = varIter.next();
                exprIter.next();
                if (!toRemove.contains(v)) continue;
                varIter.remove();
                exprIter.remove();
                this.assignedVarSet.remove(v);
                changed = true;
            }
        }
        return changed;
    }

    private void collectUnusedAssignedVars(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> accumulatedUsedVarFromRootSet, boolean first, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (!first) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        HashSet<Object> assignVarsSetInThisOp = new HashSet<Object>();
        HashSet usedVarsSetInThisOp = new HashSet();
        boolean addUsedVarsInThisOp = true;
        boolean targetOpFound = false;
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                assignVarsSetInThisOp.addAll(assign.getVariables());
                targetOpFound = true;
                break;
            }
            case AGGREGATE: {
                AggregateOperator agg = (AggregateOperator)op;
                assignVarsSetInThisOp.addAll(agg.getVariables());
                targetOpFound = true;
                break;
            }
            case UNNEST: {
                UnnestOperator uOp = (UnnestOperator)op;
                LogicalVariable pVar = uOp.getPositionalVariable();
                if (pVar == null) break;
                assignVarsSetInThisOp.add(pVar);
                targetOpFound = true;
                break;
            }
            case UNIONALL: {
                UnionAllOperator unionOp = (UnionAllOperator)op;
                for (Triple varMapping : unionOp.getVariableMappings()) {
                    assignVarsSetInThisOp.add(varMapping.third);
                }
                targetOpFound = true;
                addUsedVarsInThisOp = false;
                break;
            }
            case GROUP: {
                GroupByOperator groupByOp = (GroupByOperator)op;
                for (Pair decorMapping : groupByOp.getDecorList()) {
                    LogicalVariable decorVar = (LogicalVariable)decorMapping.first;
                    if (decorVar != null) {
                        assignVarsSetInThisOp.add(decorVar);
                        targetOpFound = true;
                        continue;
                    }
                    VariableReferenceExpression varExpr = (VariableReferenceExpression)((Mutable)decorMapping.second).getValue();
                    LogicalVariable reboundDecorVar = varExpr.getVariableReference();
                    assignVarsSetInThisOp.add(reboundDecorVar);
                }
                break;
            }
        }
        if (targetOpFound) {
            this.assignedVarMap.put(opRef, assignVarsSetInThisOp);
            this.assignedVarSet.addAll(assignVarsSetInThisOp);
        }
        if (addUsedVarsInThisOp) {
            VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVarsSetInThisOp);
            accumulatedUsedVarFromRootSet.addAll(usedVarsSetInThisOp);
            if (this.accumulatedUsedVarFromRootMap.containsKey(opRef)) {
                this.accumulatedUsedVarFromRootMap.get(opRef).addAll(accumulatedUsedVarFromRootSet);
            } else {
                this.accumulatedUsedVarFromRootMap.put(opRef, new HashSet<LogicalVariable>(accumulatedUsedVarFromRootSet));
            }
        } else {
            this.accumulatedUsedVarFromRootMap.put(opRef, new HashSet<LogicalVariable>(accumulatedUsedVarFromRootSet));
        }
        for (Mutable c : op.getInputs()) {
            this.collectUnusedAssignedVars((Mutable<ILogicalOperator>)c, new HashSet<LogicalVariable>(accumulatedUsedVarFromRootSet), false, context);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan plan : opWithNested.getNestedPlans()) {
                for (Mutable r : plan.getRoots()) {
                    this.collectUnusedAssignedVars((Mutable<ILogicalOperator>)r, new HashSet<LogicalVariable>(accumulatedUsedVarFromRootSet), false, context);
                }
            }
        }
    }

    private void clear() {
        this.assignedVarMap.clear();
        this.assignedVarSet.clear();
        this.accumulatedUsedVarFromRootMap.clear();
        this.survivedUnionSourceVarSet.clear();
        this.isTransformed = false;
    }
}

