/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.OneToOneExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.HeuristicOptimizer;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ExtractCommonOperatorsRule
implements IAlgebraicRewriteRule {
    private final HashMap<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>> childrenToParents = new HashMap();
    private final List<Mutable<ILogicalOperator>> roots = new ArrayList<Mutable<ILogicalOperator>>();
    private final List<List<Mutable<ILogicalOperator>>> equivalenceClasses = new ArrayList<List<Mutable<ILogicalOperator>>>();
    private final HashMap<Mutable<ILogicalOperator>, BitSet> opToCandidateInputs = new HashMap();
    private final HashMap<Mutable<ILogicalOperator>, MutableInt> clusterMap = new HashMap();
    private final HashMap<Integer, BitSet> clusterWaitForMap = new HashMap();
    private int lastUsedClusterId = 0;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.WRITE && op.getOperatorTag() != LogicalOperatorTag.WRITE_RESULT && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        MutableObject mutableOp = new MutableObject((Object)op);
        if (!this.roots.contains(mutableOp)) {
            this.roots.add((Mutable<ILogicalOperator>)mutableOp);
        }
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.WRITE && op.getOperatorTag() != LogicalOperatorTag.WRITE_RESULT && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        boolean rewritten = false;
        if (!this.roots.isEmpty()) {
            boolean changed;
            do {
                changed = false;
                this.topDownMaterialization(this.roots);
                this.genCandidates(context);
                this.removeTrivialShare();
                if (!this.equivalenceClasses.isEmpty()) {
                    changed = this.rewrite(context);
                }
                if (!rewritten) {
                    rewritten = changed;
                }
                this.equivalenceClasses.clear();
                this.childrenToParents.clear();
                this.opToCandidateInputs.clear();
                this.clusterMap.clear();
                this.clusterWaitForMap.clear();
                this.lastUsedClusterId = 0;
            } while (changed);
            this.roots.clear();
        }
        return rewritten;
    }

    private void removeTrivialShare() {
        for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
            for (int i = candidates.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> opRef = candidates.get(i);
                AbstractLogicalOperator aop = (AbstractLogicalOperator)opRef.getValue();
                if (aop.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                    aop = (AbstractLogicalOperator)((Mutable)aop.getInputs().get(0)).getValue();
                }
                if (aop.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) continue;
                candidates.remove(i);
            }
        }
        for (int i = this.equivalenceClasses.size() - 1; i >= 0; --i) {
            if (this.equivalenceClasses.get(i).size() >= 2) continue;
            this.equivalenceClasses.remove(i);
        }
    }

    private boolean rewrite(IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        for (List<Mutable<ILogicalOperator>> members : this.equivalenceClasses) {
            if (!this.rewriteForOneEquivalentClass(members, context)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean rewriteForOneEquivalentClass(List<Mutable<ILogicalOperator>> members, IOptimizationContext context) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> group = new ArrayList<Mutable<ILogicalOperator>>();
        boolean rewritten = false;
        while (members.size() > 0) {
            group.clear();
            Mutable candidate = members.remove(members.size() - 1);
            group.add(candidate);
            for (int i = members.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> peer = members.get(i);
                if (!IsomorphismUtilities.isOperatorIsomorphic((ILogicalOperator)((ILogicalOperator)candidate.getValue()), (ILogicalOperator)((ILogicalOperator)peer.getValue()))) continue;
                group.add(peer);
                members.remove(i);
            }
            boolean[] materializationFlags = this.computeMaterilizationFlags(group);
            if (group.isEmpty()) continue;
            candidate = (Mutable)group.get(0);
            ReplicateOperator rop = new ReplicateOperator(group.size(), materializationFlags);
            rop.setPhysicalOperator((IPhysicalOperator)new ReplicatePOperator());
            MutableObject ropRef = new MutableObject((Object)rop);
            AbstractLogicalOperator aopCandidate = (AbstractLogicalOperator)candidate.getValue();
            List<Mutable<ILogicalOperator>> originalCandidateParents = this.childrenToParents.get(candidate);
            rop.setExecutionMode(((AbstractLogicalOperator)candidate.getValue()).getExecutionMode());
            if (aopCandidate.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                rop.getInputs().add(candidate);
            } else {
                ExchangeOperator beforeExchange = new ExchangeOperator();
                beforeExchange.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                beforeExchange.setExecutionMode(rop.getExecutionMode());
                MutableObject mutableObject = new MutableObject((Object)beforeExchange);
                beforeExchange.getInputs().add(candidate);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)beforeExchange);
                rop.getInputs().add(mutableObject);
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)rop);
            for (Mutable mutable : originalCandidateParents) {
                AbstractLogicalOperator parent = (AbstractLogicalOperator)mutable.getValue();
                int n = parent.getInputs().indexOf(candidate);
                if (parent.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                    parent.getInputs().set(n, ropRef);
                    rop.getOutputs().add(mutable);
                    continue;
                }
                ExchangeOperator exchange = new ExchangeOperator();
                exchange.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                exchange.setExecutionMode(rop.getExecutionMode());
                MutableObject exchangeRef = new MutableObject((Object)exchange);
                exchange.getInputs().add(ropRef);
                rop.getOutputs().add(exchangeRef);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchange);
                parent.getInputs().set(n, exchangeRef);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)parent);
            }
            ArrayList liveVarsNew = new ArrayList();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)candidate.getValue()), liveVarsNew);
            ArrayList<MutableObject> arrayList = new ArrayList<MutableObject>();
            for (LogicalVariable logicalVariable : liveVarsNew) {
                arrayList.add(new MutableObject((Object)new VariableReferenceExpression(logicalVariable)));
            }
            for (Mutable mutable : group) {
                if (mutable.equals(candidate)) continue;
                ArrayList liveVars = new ArrayList();
                HashMap variableMappingBack = new HashMap();
                IsomorphismUtilities.mapVariablesTopDown((ILogicalOperator)((ILogicalOperator)mutable.getValue()), (ILogicalOperator)((ILogicalOperator)candidate.getValue()), variableMappingBack);
                for (int i = 0; i < liveVarsNew.size(); ++i) {
                    liveVars.add(variableMappingBack.get(liveVarsNew.get(i)));
                }
                AssignOperator assignOperator = new AssignOperator(liveVars, arrayList);
                assignOperator.setExecutionMode(rop.getExecutionMode());
                assignOperator.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
                ProjectOperator projectOperator = new ProjectOperator(liveVars);
                projectOperator.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
                projectOperator.setExecutionMode(rop.getExecutionMode());
                ExchangeOperator exchOp = new ExchangeOperator();
                exchOp.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                exchOp.setExecutionMode(rop.getExecutionMode());
                exchOp.getInputs().add(ropRef);
                MutableObject exchOpRef = new MutableObject((Object)exchOp);
                rop.getOutputs().add(exchOpRef);
                assignOperator.getInputs().add(exchOpRef);
                projectOperator.getInputs().add(new MutableObject((Object)assignOperator));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchOp);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOperator);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOperator);
                List<Mutable<ILogicalOperator>> parentOpList = this.childrenToParents.get(mutable);
                for (Mutable<ILogicalOperator> parentOpRef : parentOpList) {
                    AssignOperator childOp;
                    AbstractLogicalOperator parentOp = (AbstractLogicalOperator)parentOpRef.getValue();
                    int index = parentOp.getInputs().indexOf(mutable);
                    Object object = childOp = parentOp.getOperatorTag() == LogicalOperatorTag.PROJECT ? assignOperator : projectOperator;
                    if (!HeuristicOptimizer.isHyracksOp((PhysicalOperatorTag)parentOp.getPhysicalOperator().getOperatorTag())) {
                        parentOp.getInputs().set(index, new MutableObject((Object)childOp));
                    } else {
                        ExchangeOperator exchg = new ExchangeOperator();
                        exchg.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                        exchg.setExecutionMode(childOp.getExecutionMode());
                        exchg.getInputs().add(new MutableObject((Object)childOp));
                        parentOp.getInputs().set(index, new MutableObject((Object)exchg));
                        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchg);
                    }
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)parentOp);
                }
            }
            rewritten = true;
        }
        return rewritten;
    }

    private void genCandidates(IOptimizationContext context) throws AlgebricksException {
        ArrayList previousEquivalenceClasses = new ArrayList();
        while (this.equivalenceClasses.size() > 0) {
            previousEquivalenceClasses.clear();
            for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
                ArrayList<Mutable<ILogicalOperator>> candidatesCopy = new ArrayList<Mutable<ILogicalOperator>>();
                candidatesCopy.addAll(candidates);
                previousEquivalenceClasses.add(candidatesCopy);
            }
            ArrayList<Mutable<ILogicalOperator>> currentLevelOpRefs = new ArrayList<Mutable<ILogicalOperator>>();
            for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
                if (candidates.size() > 0) {
                    for (Mutable<ILogicalOperator> opRef : candidates) {
                        List<Mutable<ILogicalOperator>> refs = this.childrenToParents.get(opRef);
                        if (refs == null) continue;
                        currentLevelOpRefs.addAll(refs);
                    }
                }
                if (currentLevelOpRefs.size() == 0) continue;
                this.candidatesGrow(currentLevelOpRefs, candidates);
            }
            if (currentLevelOpRefs.size() == 0) break;
            this.prune(context);
        }
        if (this.equivalenceClasses.size() < 1 && previousEquivalenceClasses.size() > 0) {
            this.equivalenceClasses.addAll(previousEquivalenceClasses);
            this.prune(context);
        }
    }

    private void topDownMaterialization(List<Mutable<ILogicalOperator>> tops) {
        ArrayList<Mutable<ILogicalOperator>> candidates = new ArrayList<Mutable<ILogicalOperator>>();
        ArrayList<Mutable<ILogicalOperator>> nextLevel = new ArrayList<Mutable<ILogicalOperator>>();
        for (Mutable<ILogicalOperator> op : tops) {
            for (Mutable opRef : ((ILogicalOperator)op.getValue()).getInputs()) {
                List<Mutable<ILogicalOperator>> opRefList = this.childrenToParents.get(opRef);
                if (opRefList == null) {
                    opRefList = new ArrayList<Mutable<ILogicalOperator>>();
                    this.childrenToParents.put((Mutable<ILogicalOperator>)opRef, opRefList);
                    nextLevel.add((Mutable<ILogicalOperator>)opRef);
                }
                opRefList.add(op);
            }
            if (!((ILogicalOperator)op.getValue()).getInputs().isEmpty()) continue;
            candidates.add(op);
        }
        if (!this.equivalenceClasses.isEmpty()) {
            this.equivalenceClasses.get(0).addAll(candidates);
        } else {
            this.equivalenceClasses.add(candidates);
        }
        if (!nextLevel.isEmpty()) {
            this.topDownMaterialization(nextLevel);
        }
    }

    private void candidatesGrow(List<Mutable<ILogicalOperator>> opList, List<Mutable<ILogicalOperator>> candidates) {
        ArrayList<Mutable<ILogicalOperator>> previousCandidates = new ArrayList<Mutable<ILogicalOperator>>();
        previousCandidates.addAll(candidates);
        candidates.clear();
        boolean validCandidate = false;
        for (Mutable<ILogicalOperator> op : opList) {
            List inputs = ((ILogicalOperator)op.getValue()).getInputs();
            block1: for (int i = 0; i < inputs.size(); ++i) {
                Mutable inputRef = (Mutable)inputs.get(i);
                validCandidate = false;
                for (Mutable mutable : previousCandidates) {
                    if (!((ILogicalOperator)inputRef.getValue()).equals(mutable.getValue())) continue;
                    if (inputs.size() == 1) {
                        validCandidate = true;
                        continue block1;
                    }
                    BitSet candidateInputBitMap = this.opToCandidateInputs.get(op);
                    if (candidateInputBitMap == null) {
                        candidateInputBitMap = new BitSet(inputs.size());
                        this.opToCandidateInputs.put(op, candidateInputBitMap);
                    }
                    candidateInputBitMap.set(i);
                    if (candidateInputBitMap.cardinality() != inputs.size()) continue block1;
                    validCandidate = true;
                    continue block1;
                }
            }
            if (!validCandidate || candidates.contains(op)) continue;
            candidates.add(op);
        }
    }

    private void prune(IOptimizationContext context) throws AlgebricksException {
        ArrayList previousEquivalenceClasses = new ArrayList();
        for (List<Mutable<ILogicalOperator>> list : this.equivalenceClasses) {
            ArrayList<Mutable<ILogicalOperator>> candidatesCopy = new ArrayList<Mutable<ILogicalOperator>>();
            candidatesCopy.addAll(list);
            previousEquivalenceClasses.add(candidatesCopy);
        }
        this.equivalenceClasses.clear();
        for (List<Object> list : previousEquivalenceClasses) {
            int i;
            boolean[] reserved = new boolean[list.size()];
            for (i = 0; i < reserved.length; ++i) {
                reserved[i] = false;
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (reserved[i]) continue;
                ArrayList<Object> equivalentClass = new ArrayList<Object>();
                ILogicalOperator candidate = (ILogicalOperator)((Mutable)list.get(i)).getValue();
                equivalentClass.add(list.get(i));
                for (int j = i - 1; j >= 0; --j) {
                    ILogicalOperator peer = (ILogicalOperator)((Mutable)list.get(j)).getValue();
                    if (!IsomorphismUtilities.isOperatorIsomorphic((ILogicalOperator)candidate, (ILogicalOperator)peer)) continue;
                    reserved[i] = true;
                    reserved[j] = true;
                    equivalentClass.add(list.get(j));
                }
                if (equivalentClass.size() <= 1) continue;
                this.equivalenceClasses.add(equivalentClass);
                Collections.reverse(equivalentClass);
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (reserved[i]) continue;
                list.remove(i);
            }
        }
    }

    private boolean[] computeMaterilizationFlags(List<Mutable<ILogicalOperator>> group) {
        int i;
        for (Mutable<ILogicalOperator> root : this.roots) {
            this.computeClusters(null, root, new MutableInt(++this.lastUsedClusterId));
        }
        boolean[] materializationFlags = new boolean[group.size()];
        boolean worthMaterialization = this.worthMaterialization(group.get(0));
        ArrayList<Integer> groupClusterIds = new ArrayList<Integer>(group.size());
        for (i = 0; i < group.size(); ++i) {
            groupClusterIds.add(this.clusterMap.get(group.get(i)).getValue());
        }
        for (i = group.size() - 1; i >= 0; --i) {
            boolean requiresMaterialization = this.requiresMaterialization(groupClusterIds, i);
            if (requiresMaterialization && !worthMaterialization) {
                group.remove(i);
                groupClusterIds.remove(i);
            }
            materializationFlags[i] = requiresMaterialization;
        }
        if (group.size() < 2) {
            group.clear();
        }
        return worthMaterialization ? materializationFlags : new boolean[group.size()];
    }

    private boolean requiresMaterialization(List<Integer> groupClusterIds, int index) {
        Integer clusterId = groupClusterIds.get(index);
        BitSet blockingClusters = new BitSet();
        this.getAllBlockingClusterIds(clusterId, blockingClusters);
        if (!blockingClusters.isEmpty()) {
            for (int i = 0; i < groupClusterIds.size(); ++i) {
                if (i == index || !blockingClusters.get(groupClusterIds.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void getAllBlockingClusterIds(int clusterId, BitSet blockingClusters) {
        BitSet waitFor = this.clusterWaitForMap.get(clusterId);
        if (waitFor != null) {
            int i = waitFor.nextSetBit(0);
            while (i >= 0) {
                this.getAllBlockingClusterIds(i, blockingClusters);
                i = waitFor.nextSetBit(i + 1);
            }
            blockingClusters.or(waitFor);
        }
    }

    private void computeClusters(Mutable<ILogicalOperator> parentRef, Mutable<ILogicalOperator> opRef, MutableInt currentClusterId) {
        int outputIndex = 0;
        if (((ILogicalOperator)opRef.getValue()).getOperatorTag() == LogicalOperatorTag.REPLICATE || ((ILogicalOperator)opRef.getValue()).getOperatorTag() == LogicalOperatorTag.SPLIT) {
            ReplicateOperator rop = (ReplicateOperator)opRef.getValue();
            List outputs = rop.getOutputs();
            for (outputIndex = 0; outputIndex < outputs.size() && !((Mutable)outputs.get(outputIndex)).equals(parentRef); ++outputIndex) {
            }
        }
        AbstractLogicalOperator aop = (AbstractLogicalOperator)opRef.getValue();
        Pair labels = aop.getPhysicalOperator().getInputOutputDependencyLabels((ILogicalOperator)opRef.getValue());
        List inputs = ((ILogicalOperator)opRef.getValue()).getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Mutable inputRef = (Mutable)inputs.get(i);
            if (((int[])labels.second)[outputIndex] == 1 && ((int[])labels.first)[i] == 0) {
                if (((int[])labels.second).length != 1) continue;
                this.clusterMap.put(opRef, currentClusterId);
                MutableInt newClusterId = new MutableInt(++this.lastUsedClusterId);
                this.computeClusters(opRef, (Mutable<ILogicalOperator>)inputRef, newClusterId);
                BitSet waitForList = this.clusterWaitForMap.get(currentClusterId.getValue());
                if (waitForList == null) {
                    waitForList = new BitSet();
                    this.clusterWaitForMap.put(currentClusterId.getValue(), waitForList);
                }
                waitForList.set(newClusterId.getValue());
                continue;
            }
            MutableInt prevClusterId = this.clusterMap.get(opRef);
            if (prevClusterId == null || prevClusterId.getValue().equals(currentClusterId.getValue())) {
                this.clusterMap.put(opRef, currentClusterId);
                this.computeClusters(opRef, (Mutable<ILogicalOperator>)inputRef, currentClusterId);
                continue;
            }
            for (BitSet bs : this.clusterWaitForMap.values()) {
                if (!bs.get(currentClusterId.getValue())) continue;
                bs.clear(currentClusterId.getValue());
                bs.set(prevClusterId.getValue());
            }
            this.clusterWaitForMap.remove(currentClusterId.getValue());
            currentClusterId.setValue((Number)prevClusterId.getValue());
        }
    }

    protected boolean worthMaterialization(Mutable<ILogicalOperator> candidate) {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)candidate.getValue();
        if (aop.getPhysicalOperator().expensiveThanMaterialization()) {
            return true;
        }
        List inputs = ((ILogicalOperator)candidate.getValue()).getInputs();
        for (Mutable inputRef : inputs) {
            if (!this.worthMaterialization((Mutable<ILogicalOperator>)inputRef)) continue;
            return true;
        }
        return false;
    }
}

