/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;

public abstract class AbstractDecorrelationRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    protected boolean descOrSelfIsScanOrJoin(AbstractLogicalOperator op2) {
        LogicalOperatorTag t = op2.getOperatorTag();
        if (this.isScanOrJoin(t)) {
            return true;
        }
        if (op2.getInputs().size() != 1) {
            return false;
        }
        AbstractLogicalOperator alo = (AbstractLogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
        return this.descOrSelfIsScanOrJoin(alo);
    }

    protected boolean isScanOrJoin(LogicalOperatorTag t) {
        return t == LogicalOperatorTag.DATASOURCESCAN || t == LogicalOperatorTag.INNERJOIN || t == LogicalOperatorTag.UNNEST || t == LogicalOperatorTag.UNNEST_MAP || t == LogicalOperatorTag.LEFTOUTERJOIN;
    }

    protected Set<LogicalVariable> computeGbyVarsUsingPksOnly(Set<LogicalVariable> varSet, AbstractLogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses((ILogicalOperator)op, context);
        List fdList = context.getFDList((ILogicalOperator)op);
        if (fdList == null) {
            return null;
        }
        for (FunctionalDependency fd : fdList) {
            if (!fd.getTail().containsAll(varSet)) continue;
            return new HashSet<LogicalVariable>(fd.getHead());
        }
        return null;
    }

    protected void buildVarExprList(Collection<LogicalVariable> vars, IOptimizationContext context, GroupByOperator g, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> outVeList) throws AlgebricksException {
        for (LogicalVariable ov : vars) {
            LogicalVariable newVar = context.newVar();
            VariableReferenceExpression varExpr = new VariableReferenceExpression(newVar);
            outVeList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)ov, (Object)new MutableObject((Object)varExpr)));
            for (ILogicalPlan p : g.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)((AbstractLogicalOperator)r.getValue()), (LogicalVariable)ov, (LogicalVariable)newVar, (boolean)true, (ITypingContext)context);
                }
            }
        }
    }
}

