/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.utils;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrameFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMLeafFrameFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeWithBuddy;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeFileManager;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyFileManager;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeCopyTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeRefrencingTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.frames.LSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMBTreeUtil {
    private LSMBTreeUtil() {
    }

    public static LSMBTree createLSMTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, FileReference file, IBufferCache diskBufferCache, IFileMapProvider diskFileMapProvider, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean needKeyDupCheck, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] btreeFields, int[] filterFields, boolean durable, IMetadataPageManagerFactory freePageManagerFactory) throws HyracksDataException {
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false);
        LSMBTreeTupleWriterFactory deleteTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, true);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMLeafFrameFactory deleteLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)deleteTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        BTreeFactory bulkLoadBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, cmpFactories, typeTraits.length);
        BloomFilterFactory bloomFilterFactory = needKeyDupCheck ? new BloomFilterFactory(diskBufferCache, diskFileMapProvider, bloomFilterKeyFields) : null;
        LSMComponentFilterFactory filterFactory = null;
        LSMComponentFilterFrameFactory filterFrameFactory = null;
        LSMComponentFilterManager filterManager = null;
        if (filterCmpFactories != null) {
            TypeAwareTupleWriterFactory filterTupleWriterFactory = new TypeAwareTupleWriterFactory(filterTypeTraits);
            filterFactory = new LSMComponentFilterFactory((ITreeIndexTupleWriterFactory)filterTupleWriterFactory, filterCmpFactories);
            filterFrameFactory = new LSMComponentFilterFrameFactory((ITreeIndexTupleWriterFactory)filterTupleWriterFactory);
            filterManager = new LSMComponentFilterManager((ILSMComponentFilterFrameFactory)filterFrameFactory);
        }
        LSMBTreeFileManager fileNameManager = new LSMBTreeFileManager(ioManager, diskFileMapProvider, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, needKeyDupCheck);
        LSMBTree lsmTree = new LSMBTree(ioManager, virtualBufferCaches, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)deleteLeafFrameFactory, (ILSMIndexFileManager)fileNameManager, (TreeIndexFactory<BTree>)diskBTreeFactory, (TreeIndexFactory<BTree>)bulkLoadBTreeFactory, bloomFilterFactory, (ILSMComponentFilterFactory)filterFactory, (ILSMComponentFilterFrameFactory)filterFrameFactory, filterManager, bloomFilterFalsePositiveRate, diskFileMapProvider, typeTraits.length, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallback, needKeyDupCheck, btreeFields, filterFields, durable);
        return lsmTree;
    }

    public static ExternalBTree createExternalBTree(IIOManager ioManager, FileReference file, IBufferCache diskBufferCache, IFileMapProvider diskFileMapProvider, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int startWithVersion, boolean durable, IMetadataPageManagerFactory freePageManagerFactory) {
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false);
        LSMBTreeTupleWriterFactory deleteTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, true);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMLeafFrameFactory deleteLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)deleteTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        LSMBTreeRefrencingTupleWriterFactory referencingTupleWriterFactory = new LSMBTreeRefrencingTupleWriterFactory(typeTraits, cmpFactories.length, false);
        BTreeNSMLeafFrameFactory dualLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)referencingTupleWriterFactory);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        BTreeFactory bulkLoadBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, cmpFactories, typeTraits.length);
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, diskFileMapProvider, bloomFilterKeyFields);
        BTreeFactory transactionBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)dualLeafFrameFactory, cmpFactories, typeTraits.length);
        LSMBTreeFileManager fileNameManager = new LSMBTreeFileManager(ioManager, diskFileMapProvider, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, true);
        ExternalBTree lsmTree = new ExternalBTree(ioManager, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)deleteLeafFrameFactory, (ILSMIndexFileManager)fileNameManager, (TreeIndexFactory<BTree>)diskBTreeFactory, (TreeIndexFactory<BTree>)bulkLoadBTreeFactory, bloomFilterFactory, bloomFilterFalsePositiveRate, diskFileMapProvider, typeTraits.length, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallback, (TreeIndexFactory<BTree>)transactionBTreeFactory, startWithVersion, durable);
        return lsmTree;
    }

    public static ExternalBTreeWithBuddy createExternalBTreeWithBuddy(IIOManager ioManager, FileReference file, IBufferCache diskBufferCache, IFileMapProvider diskFileMapProvider, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] buddyBTreeFields, int startWithVersion, boolean durable, IMetadataPageManagerFactory freePageManagerFactory) {
        ITypeTraits[] buddyBtreeTypeTraits = new ITypeTraits[buddyBTreeFields.length];
        IBinaryComparatorFactory[] buddyBtreeCmpFactories = new IBinaryComparatorFactory[buddyBTreeFields.length];
        for (int i = 0; i < buddyBtreeTypeTraits.length; ++i) {
            buddyBtreeTypeTraits[i] = typeTraits[buddyBTreeFields[i]];
            buddyBtreeCmpFactories[i] = cmpFactories[buddyBTreeFields[i]];
        }
        TypeAwareTupleWriterFactory buddyBtreeTupleWriterFactory = new TypeAwareTupleWriterFactory(buddyBtreeTypeTraits);
        BTreeNSMInteriorFrameFactory buddyBtreeInteriorFrameFactory = new BTreeNSMInteriorFrameFactory((ITreeIndexTupleWriterFactory)buddyBtreeTupleWriterFactory);
        BTreeNSMLeafFrameFactory buddyBtreeLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)buddyBtreeTupleWriterFactory);
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((ITreeIndexTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((ITreeIndexTupleWriterFactory)insertTupleWriterFactory);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        BTreeFactory bulkLoadBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, cmpFactories, typeTraits.length);
        int[] bloomFilterKeyFields = new int[buddyBtreeCmpFactories.length];
        for (int i = 0; i < buddyBtreeCmpFactories.length; ++i) {
            bloomFilterKeyFields[i] = i;
        }
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, diskFileMapProvider, bloomFilterKeyFields);
        BTreeFactory diskBuddyBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, diskFileMapProvider, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)buddyBtreeInteriorFrameFactory, (ITreeIndexFrameFactory)buddyBtreeLeafFrameFactory, buddyBtreeCmpFactories, buddyBtreeTypeTraits.length);
        LSMBTreeWithBuddyFileManager fileNameManager = new LSMBTreeWithBuddyFileManager(ioManager, diskFileMapProvider, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, (TreeIndexFactory<? extends ITreeIndex>)diskBuddyBTreeFactory);
        ExternalBTreeWithBuddy lsmTree = new ExternalBTreeWithBuddy(ioManager, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)buddyBtreeLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, (TreeIndexFactory<BTree>)bulkLoadBTreeFactory, (TreeIndexFactory<BTree>)diskBTreeFactory, (TreeIndexFactory<BTree>)diskBuddyBTreeFactory, bloomFilterFactory, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, cmpFactories, buddyBtreeCmpFactories, buddyBTreeFields, startWithVersion, durable);
        return lsmTree;
    }
}

