/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyAbstractCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;

public class LSMBTreeWithBuddySortedCursor
extends LSMBTreeWithBuddyAbstractCursor {
    private boolean[] depletedBtreeCursors;
    private int foundIn = -1;
    private PermutingTupleReference buddyBtreeTuple;

    public LSMBTreeWithBuddySortedCursor(ILSMIndexOperationContext opCtx, int[] buddyBTreeFields) throws HyracksDataException {
        super(opCtx);
        this.buddyBtreeTuple = new PermutingTupleReference(buddyBTreeFields);
        this.reset();
    }

    public ILSMIndexOperationContext getOpCtx() {
        return this.opCtx;
    }

    public void reset() throws HyracksDataException {
        this.depletedBtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.btreeCursors[i].reset();
                try {
                    this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                if (this.btreeCursors[i].hasNext()) {
                    this.btreeCursors[i].next();
                    continue;
                }
                this.depletedBtreeCursors[i] = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HyracksDataException("error while reseting the btrees of the lsm btree with buddy btree", (Throwable)e);
        }
        finally {
            if (this.open) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws HyracksDataException, IndexException {
        while (!this.foundNext) {
            this.frameTuple = null;
            if (this.foundIn != -1) {
                if (this.btreeCursors[this.foundIn].hasNext()) {
                    this.btreeCursors[this.foundIn].next();
                } else {
                    this.depletedBtreeCursors[this.foundIn] = true;
                }
            }
            this.foundIn = -1;
            for (int i = 0; i < this.numberOfTrees; ++i) {
                if (this.depletedBtreeCursors[i]) continue;
                if (this.frameTuple == null) {
                    this.frameTuple = this.btreeCursors[i].getTuple();
                    this.foundIn = i;
                    continue;
                }
                if (this.btreeCmp.compare(this.frameTuple, this.btreeCursors[i].getTuple()) <= 0) continue;
                this.frameTuple = this.btreeCursors[i].getTuple();
                this.foundIn = i;
            }
            if (this.foundIn == -1) {
                return false;
            }
            boolean killed = false;
            this.buddyBtreeTuple.reset(this.frameTuple);
            for (int i = 0; i < this.foundIn; ++i) {
                try {
                    this.buddyBtreeCursors[i].reset();
                    this.buddyBtreeRangePredicate.setHighKey((ITupleReference)this.buddyBtreeTuple, true);
                    this.btreeRangePredicate.setLowKey((ITupleReference)this.buddyBtreeTuple, true);
                    this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                try {
                    if (!this.btreeCursors[i].hasNext()) continue;
                    killed = true;
                    break;
                }
                finally {
                    this.btreeCursors[i].close();
                }
            }
            if (killed) continue;
            this.foundNext = true;
        }
        return true;
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    @Override
    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        super.open(initialState, searchPred);
        this.depletedBtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        for (int i = 0; i < this.numberOfTrees; ++i) {
            this.btreeCursors[i].reset();
            try {
                this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            if (this.btreeCursors[i].hasNext()) {
                this.btreeCursors[i].next();
                continue;
            }
            this.depletedBtreeCursors[i] = true;
        }
    }
}

