/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMBTreeWithBuddyFileManager
extends AbstractLSMIndexFileManager {
    public static final String BUDDY_BTREE_STRING = "buddy";
    public static final String BTREE_STRING = "b";
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory;
    private static FilenameFilter btreeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMBTreeWithBuddyFileManager.BTREE_STRING);
        }
    };
    private static FilenameFilter buddyBtreeFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(LSMBTreeWithBuddyFileManager.BUDDY_BTREE_STRING);
        }
    };

    public LSMBTreeWithBuddyFileManager(IIOManager ioManager, IFileMapProvider fileMapProvider, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, TreeIndexFactory<? extends ITreeIndex> buddyBtreeFactory) {
        super(ioManager, fileMapProvider, file, null);
        this.buddyBtreeFactory = buddyBtreeFactory;
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        String baseName = this.baseDir + ts + "_" + ts;
        return new LSMComponentFileReferences(this.createFlushFile(baseName + "_" + BTREE_STRING), this.createFlushFile(baseName + "_" + BUDDY_BTREE_STRING), this.createFlushFile(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split("_");
        String[] lastTimestampRange = lastFileName.split("_");
        String baseName = this.baseDir + firstTimestampRange[0] + "_" + lastTimestampRange[1];
        return new LSMComponentFileReferences(this.createMergeFile(baseName + "_" + BTREE_STRING), this.createMergeFile(baseName + "_" + BUDDY_BTREE_STRING), this.createMergeFile(baseName + "_" + "f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException, IndexException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBuddyBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilefilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(btreeFilter, transactionFilefilter), this.btreeFactory, allBTreeFiles);
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (AbstractLSMIndexFileManager.ComparableFileName cmpFileName : allBTreeFiles) {
            int index = cmpFileName.fileName.lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.fileName.substring(0, index));
        }
        this.validateFiles(btreeFilesSet, allBuddyBTreeFiles, this.getCompoundFilter(buddyBtreeFilter, transactionFilefilter), this.buddyBtreeFactory);
        this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(bloomFilterFilter, transactionFilefilter), null);
        if (allBTreeFiles.size() != allBuddyBTreeFiles.size() || allBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw new HyracksDataException("Unequal number of valid BTree, Buddy BTree, and Bloom Filter files found. Aborting cleanup.");
        }
        if (allBTreeFiles.isEmpty() || allBuddyBTreeFiles.isEmpty() || allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (allBTreeFiles.size() == 1 && allBuddyBTreeFiles.size() == 1 && allBloomFilterFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get((int)0)).fileRef, ((AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get((int)0)).fileRef));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        Collections.sort(allBuddyBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBuddyBTreeFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBuddyBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get(0);
        validComparableBuddyBTreeFiles.add(lastBuddyBTree);
        ArrayList<AbstractLSMIndexFileManager.ComparableFileName> validComparableBloomFilterFiles = new ArrayList<AbstractLSMIndexFileManager.ComparableFileName>();
        AbstractLSMIndexFileManager.ComparableFileName lastBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            AbstractLSMIndexFileManager.ComparableFileName currentBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName currentBuddyBTree = (AbstractLSMIndexFileManager.ComparableFileName)allBuddyBTreeFiles.get(i);
            AbstractLSMIndexFileManager.ComparableFileName currentBloomFilter = (AbstractLSMIndexFileManager.ComparableFileName)allBloomFilterFiles.get(i);
            if (currentBTree.interval[0].compareTo(lastBTree.interval[1]) > 0 && currentBuddyBTree.interval[0].compareTo(lastBuddyBTree.interval[1]) > 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[1]) > 0) {
                validComparableBTreeFiles.add(currentBTree);
                validComparableBuddyBTreeFiles.add(currentBuddyBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBTree = currentBTree;
                lastBuddyBTree = currentBuddyBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.interval[0].compareTo(lastBTree.interval[0]) >= 0 && currentBTree.interval[1].compareTo(lastBTree.interval[1]) <= 0 && currentBuddyBTree.interval[0].compareTo(lastBuddyBTree.interval[0]) >= 0 && currentBuddyBTree.interval[1].compareTo(lastBuddyBTree.interval[1]) <= 0 && currentBloomFilter.interval[0].compareTo(lastBloomFilter.interval[0]) >= 0 && currentBloomFilter.interval[1].compareTo(lastBloomFilter.interval[1]) <= 0) {
                File invalidBTreeFile = new File(currentBTree.fullPath);
                invalidBTreeFile.delete();
                File invalidBuddyBTreeFile = new File(currentBuddyBTree.fullPath);
                invalidBuddyBTreeFile.delete();
                File invalidBloomFilterFile = new File(currentBloomFilter.fullPath);
                invalidBloomFilterFile.delete();
                continue;
            }
            throw new HyracksDataException("Found LSM files with overlapping but not contained timetamp intervals.");
        }
        Collections.sort(validComparableBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableBuddyBTreeFiles, this.recencyCmp);
        Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator buddyBtreeFileIter = validComparableBuddyBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (btreeFileIter.hasNext() && buddyBtreeFileIter.hasNext()) {
            AbstractLSMIndexFileManager.ComparableFileName cmpBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)btreeFileIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpBuddyBTreeFileName = (AbstractLSMIndexFileManager.ComparableFileName)buddyBtreeFileIter.next();
            AbstractLSMIndexFileManager.ComparableFileName cmpBloomFilterFileName = (AbstractLSMIndexFileManager.ComparableFileName)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.fileRef, cmpBuddyBTreeFileName.fileRef, cmpBloomFilterFileName.fileRef));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String ts = this.getCurrentTimestamp();
        Files.createFile(Paths.get(this.baseDir + ".T" + ts, new String[0]), new FileAttribute[0]);
        String baseName = this.baseDir + ts + "_" + ts;
        return new LSMComponentFileReferences(this.createFlushFile(baseName + "_" + BTREE_STRING), this.createFlushFile(baseName + "_" + BUDDY_BTREE_STRING), this.createFlushFile(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        File dir = new File(this.baseDir);
        String[] files = dir.list(transactionFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw new HyracksDataException("More than one transaction lock found:" + files.length);
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        String txnFileName = dir.getPath() + File.separator + files[0];
        files = dir.list(transactionFilter);
        if (files.length < 3) {
            throw new HyracksDataException("LSM Btree with buddy transaction has less than 3 files :" + files.length);
        }
        try {
            Files.delete(Paths.get(txnFileName, new String[0]));
        }
        catch (IOException e) {
            throw new HyracksDataException("Failed to delete transaction lock :" + txnFileName);
        }
        File bTreeFile = null;
        File buddyBTreeFile = null;
        File bloomFilterFile = null;
        for (String fileName : files) {
            if (fileName.endsWith(BTREE_STRING)) {
                bTreeFile = new File(dir.getPath() + File.separator + fileName);
                continue;
            }
            if (fileName.endsWith(BUDDY_BTREE_STRING)) {
                buddyBTreeFile = new File(dir.getPath() + File.separator + fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFile = new File(dir.getPath() + File.separator + fileName);
                continue;
            }
            throw new HyracksDataException("unrecognized file found = " + fileName);
        }
        FileReference bTreeFileRef = this.ioManager.resolveAbsolutePath(bTreeFile.getAbsolutePath());
        FileReference buddyBTreeFileRef = this.ioManager.resolveAbsolutePath(buddyBTreeFile.getAbsolutePath());
        FileReference bloomFilterFileRef = this.ioManager.resolveAbsolutePath(bloomFilterFile.getAbsolutePath());
        return new LSMComponentFileReferences(bTreeFileRef, buddyBTreeFileRef, bloomFilterFileRef);
    }
}

