/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeWithBuddyDiskComponentFactory
implements ILSMDiskComponentFactory {
    private final TreeIndexFactory<BTree> btreeFactory;
    private final TreeIndexFactory<BTree> buddyBtreeFactory;
    private final BloomFilterFactory bloomFilterFactory;

    public LSMBTreeWithBuddyDiskComponentFactory(TreeIndexFactory<BTree> btreeFactory, TreeIndexFactory<BTree> buddyBtreeFactory, BloomFilterFactory bloomFilterFactory) {
        this.btreeFactory = btreeFactory;
        this.buddyBtreeFactory = buddyBtreeFactory;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public LSMBTreeWithBuddyDiskComponent createComponent(LSMComponentFileReferences cfr) throws HyracksDataException {
        return new LSMBTreeWithBuddyDiskComponent((BTree)this.btreeFactory.createIndexInstance(cfr.getInsertIndexFileReference()), (BTree)this.buddyBtreeFactory.createIndexInstance(cfr.getDeleteIndexFileReference()), this.bloomFilterFactory.createBloomFiltertInstance(cfr.getBloomFilterFileReference()), null);
    }
}

