/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class LSMBTreeSearchCursor
implements ITreeIndexCursor {
    private final LSMBTreePointSearchCursor pointCursor;
    private final LSMBTreeRangeSearchCursor rangeCursor;
    private ITreeIndexCursor currentCursor;

    public LSMBTreeSearchCursor(ILSMIndexOperationContext opCtx) {
        this.pointCursor = new LSMBTreePointSearchCursor(opCtx);
        this.rangeCursor = new LSMBTreeRangeSearchCursor(opCtx);
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws IndexException, HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        LSMBTreeSearchType searchType = LSMBTreeSearchType.RANGE;
        RangePredicate btreePred = (RangePredicate)searchPred;
        if (btreePred.getLowKey() != null && btreePred.getHighKey() != null && btreePred.isLowKeyInclusive() && btreePred.isHighKeyInclusive() && btreePred.getLowKeyComparator().getKeyFieldCount() == btreePred.getHighKeyComparator().getKeyFieldCount() && btreePred.getLowKeyComparator().getKeyFieldCount() == lsmInitialState.getOriginalKeyComparator().getKeyFieldCount() && lsmInitialState.getOriginalKeyComparator().compare(btreePred.getLowKey(), btreePred.getHighKey()) == 0) {
            searchType = LSMBTreeSearchType.POINT;
        }
        switch (searchType) {
            case POINT: {
                this.currentCursor = this.pointCursor;
                break;
            }
            case RANGE: {
                this.currentCursor = this.rangeCursor;
                break;
            }
            default: {
                throw new HyracksDataException("Wrong search type");
            }
        }
        this.currentCursor.open((ICursorInitialState)lsmInitialState, searchPred);
    }

    public boolean hasNext() throws HyracksDataException, IndexException {
        return this.currentCursor.hasNext();
    }

    public void next() throws HyracksDataException {
        this.currentCursor.next();
    }

    public void close() throws HyracksDataException {
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
        this.currentCursor = null;
    }

    public void reset() throws HyracksDataException, IndexException {
        if (this.currentCursor != null) {
            this.currentCursor.reset();
        }
        this.currentCursor = null;
    }

    public ITupleReference getTuple() {
        return this.currentCursor.getTuple();
    }

    public ICachedPage getPage() {
        return this.currentCursor.getPage();
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.currentCursor.setBufferCache(bufferCache);
    }

    public void setFileId(int fileId) {
        this.currentCursor.setFileId(fileId);
    }

    public boolean exclusiveLatchNodes() {
        return this.currentCursor.exclusiveLatchNodes();
    }

    public void markCurrentTupleAsUpdated() throws HyracksDataException {
        throw new HyracksDataException("Updating tuples is not supported with this cursor.");
    }

    public static enum LSMBTreeSearchType {
        POINT,
        RANGE;

    }
}

